# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import OpenMessageEvent
    from . import OpenMessagingChannel

class OpenEventNormalizedMessage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        OpenEventNormalizedMessage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'channel': 'OpenMessagingChannel',
            'type': 'str',
            'events': 'list[OpenMessageEvent]'
        }

        self.attribute_map = {
            'id': 'id',
            'channel': 'channel',
            'type': 'type',
            'events': 'events'
        }

        self._id = None
        self._channel = None
        self._type = None
        self._events = None

    @property
    def id(self) -> str:
        """
        Gets the id of this OpenEventNormalizedMessage.
        Unique ID of the message generated by Messaging Platform.

        :return: The id of this OpenEventNormalizedMessage.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this OpenEventNormalizedMessage.
        Unique ID of the message generated by Messaging Platform.

        :param id: The id of this OpenEventNormalizedMessage.
        :type: str
        """
        

        self._id = id

    @property
    def channel(self) -> 'OpenMessagingChannel':
        """
        Gets the channel of this OpenEventNormalizedMessage.
        Channel-specific information that describes the message and the message channel/provider.

        :return: The channel of this OpenEventNormalizedMessage.
        :rtype: OpenMessagingChannel
        """
        return self._channel

    @channel.setter
    def channel(self, channel: 'OpenMessagingChannel') -> None:
        """
        Sets the channel of this OpenEventNormalizedMessage.
        Channel-specific information that describes the message and the message channel/provider.

        :param channel: The channel of this OpenEventNormalizedMessage.
        :type: OpenMessagingChannel
        """
        

        self._channel = channel

    @property
    def type(self) -> str:
        """
        Gets the type of this OpenEventNormalizedMessage.
        Message type.

        :return: The type of this OpenEventNormalizedMessage.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this OpenEventNormalizedMessage.
        Message type.

        :param type: The type of this OpenEventNormalizedMessage.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Event"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def events(self) -> List['OpenMessageEvent']:
        """
        Gets the events of this OpenEventNormalizedMessage.
        List of event elements.

        :return: The events of this OpenEventNormalizedMessage.
        :rtype: list[OpenMessageEvent]
        """
        return self._events

    @events.setter
    def events(self, events: List['OpenMessageEvent']) -> None:
        """
        Sets the events of this OpenEventNormalizedMessage.
        List of event elements.

        :param events: The events of this OpenEventNormalizedMessage.
        :type: list[OpenMessageEvent]
        """
        

        self._events = events

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

