# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ComplexVariableInfo

class NuanceBotVariable(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        NuanceBotVariable - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'reserved': 'bool',
            'simple_variable_info': 'str',
            'complex_generic_variable_info': 'ComplexVariableInfo'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'reserved': 'reserved',
            'simple_variable_info': 'simpleVariableInfo',
            'complex_generic_variable_info': 'complexGenericVariableInfo'
        }

        self._id = None
        self._name = None
        self._description = None
        self._reserved = None
        self._simple_variable_info = None
        self._complex_generic_variable_info = None

    @property
    def id(self) -> str:
        """
        Gets the id of this NuanceBotVariable.
        The variable ID

        :return: The id of this NuanceBotVariable.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this NuanceBotVariable.
        The variable ID

        :param id: The id of this NuanceBotVariable.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this NuanceBotVariable.
        The variable display name

        :return: The name of this NuanceBotVariable.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this NuanceBotVariable.
        The variable display name

        :param name: The name of this NuanceBotVariable.
        :type: str
        """
        

        self._name = name

    @property
    def description(self) -> str:
        """
        Gets the description of this NuanceBotVariable.
        The variable description

        :return: The description of this NuanceBotVariable.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this NuanceBotVariable.
        The variable description

        :param description: The description of this NuanceBotVariable.
        :type: str
        """
        

        self._description = description

    @property
    def reserved(self) -> bool:
        """
        Gets the reserved of this NuanceBotVariable.
        True if the variable is a reserved variable

        :return: The reserved of this NuanceBotVariable.
        :rtype: bool
        """
        return self._reserved

    @reserved.setter
    def reserved(self, reserved: bool) -> None:
        """
        Sets the reserved of this NuanceBotVariable.
        True if the variable is a reserved variable

        :param reserved: The reserved of this NuanceBotVariable.
        :type: bool
        """
        

        self._reserved = reserved

    @property
    def simple_variable_info(self) -> str:
        """
        Gets the simple_variable_info of this NuanceBotVariable.
        The type information for this variable

        :return: The simple_variable_info of this NuanceBotVariable.
        :rtype: str
        """
        return self._simple_variable_info

    @simple_variable_info.setter
    def simple_variable_info(self, simple_variable_info: str) -> None:
        """
        Sets the simple_variable_info of this NuanceBotVariable.
        The type information for this variable

        :param simple_variable_info: The simple_variable_info of this NuanceBotVariable.
        :type: str
        """
        

        self._simple_variable_info = simple_variable_info

    @property
    def complex_generic_variable_info(self) -> 'ComplexVariableInfo':
        """
        Gets the complex_generic_variable_info of this NuanceBotVariable.
        The type information for this variable

        :return: The complex_generic_variable_info of this NuanceBotVariable.
        :rtype: ComplexVariableInfo
        """
        return self._complex_generic_variable_info

    @complex_generic_variable_info.setter
    def complex_generic_variable_info(self, complex_generic_variable_info: 'ComplexVariableInfo') -> None:
        """
        Sets the complex_generic_variable_info of this NuanceBotVariable.
        The type information for this variable

        :param complex_generic_variable_info: The complex_generic_variable_info of this NuanceBotVariable.
        :type: ComplexVariableInfo
        """
        

        self._complex_generic_variable_info = complex_generic_variable_info

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

