# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import NuanceApplication
    from . import NuanceBotCredentials
    from . import NuanceBotTransferNode
    from . import NuanceBotVariable
    from . import NuanceChannel
    from . import NuanceEnvironment
    from . import NuanceGeography
    from . import NuanceOrganization

class NuanceBot(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        NuanceBot - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'integration_id': 'str',
            'nuance_organization': 'NuanceOrganization',
            'application': 'NuanceApplication',
            'nuance_environment': 'NuanceEnvironment',
            'geography': 'NuanceGeography',
            'credentials': 'list[NuanceBotCredentials]',
            'variables': 'list[NuanceBotVariable]',
            'transfer_nodes': 'list[NuanceBotTransferNode]',
            'locales': 'list[str]',
            'channels': 'list[NuanceChannel]',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'integration_id': 'integrationId',
            'nuance_organization': 'nuanceOrganization',
            'application': 'application',
            'nuance_environment': 'nuanceEnvironment',
            'geography': 'geography',
            'credentials': 'credentials',
            'variables': 'variables',
            'transfer_nodes': 'transferNodes',
            'locales': 'locales',
            'channels': 'channels',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._integration_id = None
        self._nuance_organization = None
        self._application = None
        self._nuance_environment = None
        self._geography = None
        self._credentials = None
        self._variables = None
        self._transfer_nodes = None
        self._locales = None
        self._channels = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this NuanceBot.
        Nuance bot Id

        :return: The id of this NuanceBot.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this NuanceBot.
        Nuance bot Id

        :param id: The id of this NuanceBot.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this NuanceBot.
        Nuance bot name

        :return: The name of this NuanceBot.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this NuanceBot.
        Nuance bot name

        :param name: The name of this NuanceBot.
        :type: str
        """
        

        self._name = name

    @property
    def integration_id(self) -> str:
        """
        Gets the integration_id of this NuanceBot.
        The Integration Id for this bot

        :return: The integration_id of this NuanceBot.
        :rtype: str
        """
        return self._integration_id

    @integration_id.setter
    def integration_id(self, integration_id: str) -> None:
        """
        Sets the integration_id of this NuanceBot.
        The Integration Id for this bot

        :param integration_id: The integration_id of this NuanceBot.
        :type: str
        """
        

        self._integration_id = integration_id

    @property
    def nuance_organization(self) -> 'NuanceOrganization':
        """
        Gets the nuance_organization of this NuanceBot.
        The Nuance Organization for this bot

        :return: The nuance_organization of this NuanceBot.
        :rtype: NuanceOrganization
        """
        return self._nuance_organization

    @nuance_organization.setter
    def nuance_organization(self, nuance_organization: 'NuanceOrganization') -> None:
        """
        Sets the nuance_organization of this NuanceBot.
        The Nuance Organization for this bot

        :param nuance_organization: The nuance_organization of this NuanceBot.
        :type: NuanceOrganization
        """
        

        self._nuance_organization = nuance_organization

    @property
    def application(self) -> 'NuanceApplication':
        """
        Gets the application of this NuanceBot.
        The Application for this bot

        :return: The application of this NuanceBot.
        :rtype: NuanceApplication
        """
        return self._application

    @application.setter
    def application(self, application: 'NuanceApplication') -> None:
        """
        Sets the application of this NuanceBot.
        The Application for this bot

        :param application: The application of this NuanceBot.
        :type: NuanceApplication
        """
        

        self._application = application

    @property
    def nuance_environment(self) -> 'NuanceEnvironment':
        """
        Gets the nuance_environment of this NuanceBot.
        The environment of the Nuance bot

        :return: The nuance_environment of this NuanceBot.
        :rtype: NuanceEnvironment
        """
        return self._nuance_environment

    @nuance_environment.setter
    def nuance_environment(self, nuance_environment: 'NuanceEnvironment') -> None:
        """
        Sets the nuance_environment of this NuanceBot.
        The environment of the Nuance bot

        :param nuance_environment: The nuance_environment of this NuanceBot.
        :type: NuanceEnvironment
        """
        

        self._nuance_environment = nuance_environment

    @property
    def geography(self) -> 'NuanceGeography':
        """
        Gets the geography of this NuanceBot.
        The Geography of the Nuance bot

        :return: The geography of this NuanceBot.
        :rtype: NuanceGeography
        """
        return self._geography

    @geography.setter
    def geography(self, geography: 'NuanceGeography') -> None:
        """
        Sets the geography of this NuanceBot.
        The Geography of the Nuance bot

        :param geography: The geography of this NuanceBot.
        :type: NuanceGeography
        """
        

        self._geography = geography

    @property
    def credentials(self) -> List['NuanceBotCredentials']:
        """
        Gets the credentials of this NuanceBot.
        client ID/Secret objects for the credentials that execute this Nuance bot

        :return: The credentials of this NuanceBot.
        :rtype: list[NuanceBotCredentials]
        """
        return self._credentials

    @credentials.setter
    def credentials(self, credentials: List['NuanceBotCredentials']) -> None:
        """
        Sets the credentials of this NuanceBot.
        client ID/Secret objects for the credentials that execute this Nuance bot

        :param credentials: The credentials of this NuanceBot.
        :type: list[NuanceBotCredentials]
        """
        

        self._credentials = credentials

    @property
    def variables(self) -> List['NuanceBotVariable']:
        """
        Gets the variables of this NuanceBot.
        List of available variables in this Nuance bot.  When querying, use the 'expand=variables' query param to populate this value

        :return: The variables of this NuanceBot.
        :rtype: list[NuanceBotVariable]
        """
        return self._variables

    @variables.setter
    def variables(self, variables: List['NuanceBotVariable']) -> None:
        """
        Sets the variables of this NuanceBot.
        List of available variables in this Nuance bot.  When querying, use the 'expand=variables' query param to populate this value

        :param variables: The variables of this NuanceBot.
        :type: list[NuanceBotVariable]
        """
        

        self._variables = variables

    @property
    def transfer_nodes(self) -> List['NuanceBotTransferNode']:
        """
        Gets the transfer_nodes of this NuanceBot.
        List of transferNodes in this Nuance bot.  When querying, use the 'expand=transferNodes' query param to populate this value

        :return: The transfer_nodes of this NuanceBot.
        :rtype: list[NuanceBotTransferNode]
        """
        return self._transfer_nodes

    @transfer_nodes.setter
    def transfer_nodes(self, transfer_nodes: List['NuanceBotTransferNode']) -> None:
        """
        Sets the transfer_nodes of this NuanceBot.
        List of transferNodes in this Nuance bot.  When querying, use the 'expand=transferNodes' query param to populate this value

        :param transfer_nodes: The transfer_nodes of this NuanceBot.
        :type: list[NuanceBotTransferNode]
        """
        

        self._transfer_nodes = transfer_nodes

    @property
    def locales(self) -> List[str]:
        """
        Gets the locales of this NuanceBot.
        List of locales associated with this Nuance bot.  Generally in the ISO format such as 'en-US'

        :return: The locales of this NuanceBot.
        :rtype: list[str]
        """
        return self._locales

    @locales.setter
    def locales(self, locales: List[str]) -> None:
        """
        Sets the locales of this NuanceBot.
        List of locales associated with this Nuance bot.  Generally in the ISO format such as 'en-US'

        :param locales: The locales of this NuanceBot.
        :type: list[str]
        """
        

        self._locales = locales

    @property
    def channels(self) -> List['NuanceChannel']:
        """
        Gets the channels of this NuanceBot.
        List of channels associated with this Nuance bot.

        :return: The channels of this NuanceBot.
        :rtype: list[NuanceChannel]
        """
        return self._channels

    @channels.setter
    def channels(self, channels: List['NuanceChannel']) -> None:
        """
        Sets the channels of this NuanceBot.
        List of channels associated with this Nuance bot.

        :param channels: The channels of this NuanceBot.
        :type: list[NuanceChannel]
        """
        

        self._channels = channels

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this NuanceBot.
        The URI for this object

        :return: The self_uri of this NuanceBot.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this NuanceBot.
        The URI for this object

        :param self_uri: The self_uri of this NuanceBot.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

