# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AgentWorkPlans
    from . import WorkPlanReference

class MuAgentsWorkPlansResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        MuAgentsWorkPlansResult - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'entities': 'list[AgentWorkPlans]',
            'reference_start_week_date': 'date',
            'work_plan_lookup': 'dict(str, WorkPlanReference)'
        }

        self.attribute_map = {
            'entities': 'entities',
            'reference_start_week_date': 'referenceStartWeekDate',
            'work_plan_lookup': 'workPlanLookup'
        }

        self._entities = None
        self._reference_start_week_date = None
        self._work_plan_lookup = None

    @property
    def entities(self) -> List['AgentWorkPlans']:
        """
        Gets the entities of this MuAgentsWorkPlansResult.


        :return: The entities of this MuAgentsWorkPlansResult.
        :rtype: list[AgentWorkPlans]
        """
        return self._entities

    @entities.setter
    def entities(self, entities: List['AgentWorkPlans']) -> None:
        """
        Sets the entities of this MuAgentsWorkPlansResult.


        :param entities: The entities of this MuAgentsWorkPlansResult.
        :type: list[AgentWorkPlans]
        """
        

        self._entities = entities

    @property
    def reference_start_week_date(self) -> date:
        """
        Gets the reference_start_week_date of this MuAgentsWorkPlansResult.
        The reference date in yyyy-MM-dd format rolled back to nearest BU start day of week. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The reference_start_week_date of this MuAgentsWorkPlansResult.
        :rtype: date
        """
        return self._reference_start_week_date

    @reference_start_week_date.setter
    def reference_start_week_date(self, reference_start_week_date: date) -> None:
        """
        Sets the reference_start_week_date of this MuAgentsWorkPlansResult.
        The reference date in yyyy-MM-dd format rolled back to nearest BU start day of week. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param reference_start_week_date: The reference_start_week_date of this MuAgentsWorkPlansResult.
        :type: date
        """
        

        self._reference_start_week_date = reference_start_week_date

    @property
    def work_plan_lookup(self) -> Dict[str, 'WorkPlanReference']:
        """
        Gets the work_plan_lookup of this MuAgentsWorkPlansResult.
        Map containing lookup values for agent work plans. The integer keys serves as lookup keys for effective work plan from workPlanLookupKeysPerWeek property

        :return: The work_plan_lookup of this MuAgentsWorkPlansResult.
        :rtype: dict(str, WorkPlanReference)
        """
        return self._work_plan_lookup

    @work_plan_lookup.setter
    def work_plan_lookup(self, work_plan_lookup: Dict[str, 'WorkPlanReference']) -> None:
        """
        Sets the work_plan_lookup of this MuAgentsWorkPlansResult.
        Map containing lookup values for agent work plans. The integer keys serves as lookup keys for effective work plan from workPlanLookupKeysPerWeek property

        :param work_plan_lookup: The work_plan_lookup of this MuAgentsWorkPlansResult.
        :type: dict(str, WorkPlanReference)
        """
        

        self._work_plan_lookup = work_plan_lookup

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

