# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import EvaluationForm
    from . import TimeInterval
    from . import User

class MeteredAssignmentByAgent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        MeteredAssignmentByAgent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'evaluation_context_id': 'str',
            'evaluators': 'list[User]',
            'max_number_evaluations': 'int',
            'evaluation_form': 'EvaluationForm',
            'time_interval': 'TimeInterval',
            'time_zone': 'str'
        }

        self.attribute_map = {
            'evaluation_context_id': 'evaluationContextId',
            'evaluators': 'evaluators',
            'max_number_evaluations': 'maxNumberEvaluations',
            'evaluation_form': 'evaluationForm',
            'time_interval': 'timeInterval',
            'time_zone': 'timeZone'
        }

        self._evaluation_context_id = None
        self._evaluators = None
        self._max_number_evaluations = None
        self._evaluation_form = None
        self._time_interval = None
        self._time_zone = None

    @property
    def evaluation_context_id(self) -> str:
        """
        Gets the evaluation_context_id of this MeteredAssignmentByAgent.


        :return: The evaluation_context_id of this MeteredAssignmentByAgent.
        :rtype: str
        """
        return self._evaluation_context_id

    @evaluation_context_id.setter
    def evaluation_context_id(self, evaluation_context_id: str) -> None:
        """
        Sets the evaluation_context_id of this MeteredAssignmentByAgent.


        :param evaluation_context_id: The evaluation_context_id of this MeteredAssignmentByAgent.
        :type: str
        """
        

        self._evaluation_context_id = evaluation_context_id

    @property
    def evaluators(self) -> List['User']:
        """
        Gets the evaluators of this MeteredAssignmentByAgent.


        :return: The evaluators of this MeteredAssignmentByAgent.
        :rtype: list[User]
        """
        return self._evaluators

    @evaluators.setter
    def evaluators(self, evaluators: List['User']) -> None:
        """
        Sets the evaluators of this MeteredAssignmentByAgent.


        :param evaluators: The evaluators of this MeteredAssignmentByAgent.
        :type: list[User]
        """
        

        self._evaluators = evaluators

    @property
    def max_number_evaluations(self) -> int:
        """
        Gets the max_number_evaluations of this MeteredAssignmentByAgent.


        :return: The max_number_evaluations of this MeteredAssignmentByAgent.
        :rtype: int
        """
        return self._max_number_evaluations

    @max_number_evaluations.setter
    def max_number_evaluations(self, max_number_evaluations: int) -> None:
        """
        Sets the max_number_evaluations of this MeteredAssignmentByAgent.


        :param max_number_evaluations: The max_number_evaluations of this MeteredAssignmentByAgent.
        :type: int
        """
        

        self._max_number_evaluations = max_number_evaluations

    @property
    def evaluation_form(self) -> 'EvaluationForm':
        """
        Gets the evaluation_form of this MeteredAssignmentByAgent.


        :return: The evaluation_form of this MeteredAssignmentByAgent.
        :rtype: EvaluationForm
        """
        return self._evaluation_form

    @evaluation_form.setter
    def evaluation_form(self, evaluation_form: 'EvaluationForm') -> None:
        """
        Sets the evaluation_form of this MeteredAssignmentByAgent.


        :param evaluation_form: The evaluation_form of this MeteredAssignmentByAgent.
        :type: EvaluationForm
        """
        

        self._evaluation_form = evaluation_form

    @property
    def time_interval(self) -> 'TimeInterval':
        """
        Gets the time_interval of this MeteredAssignmentByAgent.


        :return: The time_interval of this MeteredAssignmentByAgent.
        :rtype: TimeInterval
        """
        return self._time_interval

    @time_interval.setter
    def time_interval(self, time_interval: 'TimeInterval') -> None:
        """
        Sets the time_interval of this MeteredAssignmentByAgent.


        :param time_interval: The time_interval of this MeteredAssignmentByAgent.
        :type: TimeInterval
        """
        

        self._time_interval = time_interval

    @property
    def time_zone(self) -> str:
        """
        Gets the time_zone of this MeteredAssignmentByAgent.


        :return: The time_zone of this MeteredAssignmentByAgent.
        :rtype: str
        """
        return self._time_zone

    @time_zone.setter
    def time_zone(self, time_zone: str) -> None:
        """
        Sets the time_zone of this MeteredAssignmentByAgent.


        :param time_zone: The time_zone of this MeteredAssignmentByAgent.
        :type: str
        """
        

        self._time_zone = time_zone

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

