# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import MetadataProperty

class MetadataSchema(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        MetadataSchema - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'title': 'str',
            'description': 'str',
            'type': 'str',
            'properties': 'list[dict(str, MetadataProperty)]',
            'required': 'list[str]'
        }

        self.attribute_map = {
            'title': 'title',
            'description': 'description',
            'type': 'type',
            'properties': 'properties',
            'required': 'required'
        }

        self._title = None
        self._description = None
        self._type = None
        self._properties = None
        self._required = None

    @property
    def title(self) -> str:
        """
        Gets the title of this MetadataSchema.
        title for the data gathering page

        :return: The title of this MetadataSchema.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title: str) -> None:
        """
        Sets the title of this MetadataSchema.
        title for the data gathering page

        :param title: The title of this MetadataSchema.
        :type: str
        """
        

        self._title = title

    @property
    def description(self) -> str:
        """
        Gets the description of this MetadataSchema.
        description of the data being gathered on this page

        :return: The description of this MetadataSchema.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this MetadataSchema.
        description of the data being gathered on this page

        :param description: The description of this MetadataSchema.
        :type: str
        """
        

        self._description = description

    @property
    def type(self) -> str:
        """
        Gets the type of this MetadataSchema.
        type of data being gathered

        :return: The type of this MetadataSchema.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this MetadataSchema.
        type of data being gathered

        :param type: The type of this MetadataSchema.
        :type: str
        """
        

        self._type = type

    @property
    def properties(self) -> List[Dict[str, 'MetadataProperty']]:
        """
        Gets the properties of this MetadataSchema.
        list of properties for which input is to be gathered, bother required and optional

        :return: The properties of this MetadataSchema.
        :rtype: list[dict(str, MetadataProperty)]
        """
        return self._properties

    @properties.setter
    def properties(self, properties: List[Dict[str, 'MetadataProperty']]) -> None:
        """
        Sets the properties of this MetadataSchema.
        list of properties for which input is to be gathered, bother required and optional

        :param properties: The properties of this MetadataSchema.
        :type: list[dict(str, MetadataProperty)]
        """
        

        self._properties = properties

    @property
    def required(self) -> List[str]:
        """
        Gets the required of this MetadataSchema.
        list of required properties

        :return: The required of this MetadataSchema.
        :rtype: list[str]
        """
        return self._required

    @required.setter
    def required(self, required: List[str]) -> None:
        """
        Sets the required of this MetadataSchema.
        list of required properties

        :param required: The required of this MetadataSchema.
        :type: list[str]
        """
        

        self._required = required

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

