# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class MessagingInitialConfiguration(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        MessagingInitialConfiguration - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'to_address': 'str',
            'from_address': 'str',
            'message_type': 'str',
            'held': 'bool',
            'alerting': 'bool',
            'inbound': 'bool',
            'invited_by': 'str',
            'additional_info': 'dict(str, str)'
        }

        self.attribute_map = {
            'to_address': 'toAddress',
            'from_address': 'fromAddress',
            'message_type': 'messageType',
            'held': 'held',
            'alerting': 'alerting',
            'inbound': 'inbound',
            'invited_by': 'invitedBy',
            'additional_info': 'additionalInfo'
        }

        self._to_address = None
        self._from_address = None
        self._message_type = None
        self._held = None
        self._alerting = None
        self._inbound = None
        self._invited_by = None
        self._additional_info = None

    @property
    def to_address(self) -> str:
        """
        Gets the to_address of this MessagingInitialConfiguration.
        Address for the participant on receiving side of the message conversation. If the address is a phone number, E.164 format is recommended.

        :return: The to_address of this MessagingInitialConfiguration.
        :rtype: str
        """
        return self._to_address

    @to_address.setter
    def to_address(self, to_address: str) -> None:
        """
        Sets the to_address of this MessagingInitialConfiguration.
        Address for the participant on receiving side of the message conversation. If the address is a phone number, E.164 format is recommended.

        :param to_address: The to_address of this MessagingInitialConfiguration.
        :type: str
        """
        

        self._to_address = to_address

    @property
    def from_address(self) -> str:
        """
        Gets the from_address of this MessagingInitialConfiguration.
        Address for the participant on the sending side of the message conversation. If the address is a phone number, E.164 format is recommended.

        :return: The from_address of this MessagingInitialConfiguration.
        :rtype: str
        """
        return self._from_address

    @from_address.setter
    def from_address(self, from_address: str) -> None:
        """
        Sets the from_address of this MessagingInitialConfiguration.
        Address for the participant on the sending side of the message conversation. If the address is a phone number, E.164 format is recommended.

        :param from_address: The from_address of this MessagingInitialConfiguration.
        :type: str
        """
        

        self._from_address = from_address

    @property
    def message_type(self) -> str:
        """
        Gets the message_type of this MessagingInitialConfiguration.
        The type of message platform from which the message originated.

        :return: The message_type of this MessagingInitialConfiguration.
        :rtype: str
        """
        return self._message_type

    @message_type.setter
    def message_type(self, message_type: str) -> None:
        """
        Sets the message_type of this MessagingInitialConfiguration.
        The type of message platform from which the message originated.

        :param message_type: The message_type of this MessagingInitialConfiguration.
        :type: str
        """
        if isinstance(message_type, int):
            message_type = str(message_type)
        allowed_values = ["Sms", "Twitter", "Facebook", "Line", "WhatsApp", "WebMessage", "Open", "Instagram", "Unknown"]
        if message_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for message_type -> " + message_type)
            self._message_type = "outdated_sdk_version"
        else:
            self._message_type = message_type

    @property
    def held(self) -> bool:
        """
        Gets the held of this MessagingInitialConfiguration.
        Indicates that this communication's initial state is held.

        :return: The held of this MessagingInitialConfiguration.
        :rtype: bool
        """
        return self._held

    @held.setter
    def held(self, held: bool) -> None:
        """
        Sets the held of this MessagingInitialConfiguration.
        Indicates that this communication's initial state is held.

        :param held: The held of this MessagingInitialConfiguration.
        :type: bool
        """
        

        self._held = held

    @property
    def alerting(self) -> bool:
        """
        Gets the alerting of this MessagingInitialConfiguration.
        Indicates that this communication's initial state is alerting. If false, the communication started in a connected state.

        :return: The alerting of this MessagingInitialConfiguration.
        :rtype: bool
        """
        return self._alerting

    @alerting.setter
    def alerting(self, alerting: bool) -> None:
        """
        Sets the alerting of this MessagingInitialConfiguration.
        Indicates that this communication's initial state is alerting. If false, the communication started in a connected state.

        :param alerting: The alerting of this MessagingInitialConfiguration.
        :type: bool
        """
        

        self._alerting = alerting

    @property
    def inbound(self) -> bool:
        """
        Gets the inbound of this MessagingInitialConfiguration.
        Indicates the direction of this communication with respect to the contact center. `true` means the communication is INBOUND. `false` means the communication is OUTBOUND.

        :return: The inbound of this MessagingInitialConfiguration.
        :rtype: bool
        """
        return self._inbound

    @inbound.setter
    def inbound(self, inbound: bool) -> None:
        """
        Sets the inbound of this MessagingInitialConfiguration.
        Indicates the direction of this communication with respect to the contact center. `true` means the communication is INBOUND. `false` means the communication is OUTBOUND.

        :param inbound: The inbound of this MessagingInitialConfiguration.
        :type: bool
        """
        

        self._inbound = inbound

    @property
    def invited_by(self) -> str:
        """
        Gets the invited_by of this MessagingInitialConfiguration.
        The id of the communication (the \"peer\") that \"invited\" this communication, if this occurred.

        :return: The invited_by of this MessagingInitialConfiguration.
        :rtype: str
        """
        return self._invited_by

    @invited_by.setter
    def invited_by(self, invited_by: str) -> None:
        """
        Sets the invited_by of this MessagingInitialConfiguration.
        The id of the communication (the \"peer\") that \"invited\" this communication, if this occurred.

        :param invited_by: The invited_by of this MessagingInitialConfiguration.
        :type: str
        """
        

        self._invited_by = invited_by

    @property
    def additional_info(self) -> Dict[str, str]:
        """
        Gets the additional_info of this MessagingInitialConfiguration.
        Additional metadata about this session which should be recorded by the platform but which will not be indexed or searchable. Primarily for diagnostic value. Any information that needs to be accessible through other components like Analytics should be moved to dedicated fields.

        :return: The additional_info of this MessagingInitialConfiguration.
        :rtype: dict(str, str)
        """
        return self._additional_info

    @additional_info.setter
    def additional_info(self, additional_info: Dict[str, str]) -> None:
        """
        Sets the additional_info of this MessagingInitialConfiguration.
        Additional metadata about this session which should be recorded by the platform but which will not be indexed or searchable. Primarily for diagnostic value. Any information that needs to be accessible through other components like Analytics should be moved to dedicated fields.

        :param additional_info: The additional_info of this MessagingInitialConfiguration.
        :type: dict(str, str)
        """
        

        self._additional_info = additional_info

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

