# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class MediaRtpStatistics(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        MediaRtpStatistics - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'packets_received': 'int',
            'packets_sent': 'int',
            'rtp_events_received': 'int',
            'rtp_events_sent': 'int',
            'estimated_average_mos': 'float'
        }

        self.attribute_map = {
            'packets_received': 'packetsReceived',
            'packets_sent': 'packetsSent',
            'rtp_events_received': 'rtpEventsReceived',
            'rtp_events_sent': 'rtpEventsSent',
            'estimated_average_mos': 'estimatedAverageMos'
        }

        self._packets_received = None
        self._packets_sent = None
        self._rtp_events_received = None
        self._rtp_events_sent = None
        self._estimated_average_mos = None

    @property
    def packets_received(self) -> int:
        """
        Gets the packets_received of this MediaRtpStatistics.
        Number of packets received, including all invalid, duplicate, and discarded packets

        :return: The packets_received of this MediaRtpStatistics.
        :rtype: int
        """
        return self._packets_received

    @packets_received.setter
    def packets_received(self, packets_received: int) -> None:
        """
        Sets the packets_received of this MediaRtpStatistics.
        Number of packets received, including all invalid, duplicate, and discarded packets

        :param packets_received: The packets_received of this MediaRtpStatistics.
        :type: int
        """
        

        self._packets_received = packets_received

    @property
    def packets_sent(self) -> int:
        """
        Gets the packets_sent of this MediaRtpStatistics.
        Number of packets sent

        :return: The packets_sent of this MediaRtpStatistics.
        :rtype: int
        """
        return self._packets_sent

    @packets_sent.setter
    def packets_sent(self, packets_sent: int) -> None:
        """
        Sets the packets_sent of this MediaRtpStatistics.
        Number of packets sent

        :param packets_sent: The packets_sent of this MediaRtpStatistics.
        :type: int
        """
        

        self._packets_sent = packets_sent

    @property
    def rtp_events_received(self) -> int:
        """
        Gets the rtp_events_received of this MediaRtpStatistics.
        Number of RFC#2833 packets received

        :return: The rtp_events_received of this MediaRtpStatistics.
        :rtype: int
        """
        return self._rtp_events_received

    @rtp_events_received.setter
    def rtp_events_received(self, rtp_events_received: int) -> None:
        """
        Sets the rtp_events_received of this MediaRtpStatistics.
        Number of RFC#2833 packets received

        :param rtp_events_received: The rtp_events_received of this MediaRtpStatistics.
        :type: int
        """
        

        self._rtp_events_received = rtp_events_received

    @property
    def rtp_events_sent(self) -> int:
        """
        Gets the rtp_events_sent of this MediaRtpStatistics.
        Number of RFC#2833 packets sent

        :return: The rtp_events_sent of this MediaRtpStatistics.
        :rtype: int
        """
        return self._rtp_events_sent

    @rtp_events_sent.setter
    def rtp_events_sent(self, rtp_events_sent: int) -> None:
        """
        Sets the rtp_events_sent of this MediaRtpStatistics.
        Number of RFC#2833 packets sent

        :param rtp_events_sent: The rtp_events_sent of this MediaRtpStatistics.
        :type: int
        """
        

        self._rtp_events_sent = rtp_events_sent

    @property
    def estimated_average_mos(self) -> float:
        """
        Gets the estimated_average_mos of this MediaRtpStatistics.
        The estimated average MOS score

        :return: The estimated_average_mos of this MediaRtpStatistics.
        :rtype: float
        """
        return self._estimated_average_mos

    @estimated_average_mos.setter
    def estimated_average_mos(self, estimated_average_mos: float) -> None:
        """
        Sets the estimated_average_mos of this MediaRtpStatistics.
        The estimated average MOS score

        :param estimated_average_mos: The estimated_average_mos of this MediaRtpStatistics.
        :type: float
        """
        

        self._estimated_average_mos = estimated_average_mos

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

