# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import LexV2Bot
    from . import LexV2Intent

class LexV2BotAlias(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        LexV2BotAlias - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'region': 'str',
            'alias_id': 'str',
            'bot': 'LexV2Bot',
            'bot_version': 'str',
            'status': 'str',
            'language': 'str',
            'intents': 'list[LexV2Intent]',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'region': 'region',
            'alias_id': 'aliasId',
            'bot': 'bot',
            'bot_version': 'botVersion',
            'status': 'status',
            'language': 'language',
            'intents': 'intents',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._region = None
        self._alias_id = None
        self._bot = None
        self._bot_version = None
        self._status = None
        self._language = None
        self._intents = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this LexV2BotAlias.
        The globally unique identifier for the object.

        :return: The id of this LexV2BotAlias.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this LexV2BotAlias.
        The globally unique identifier for the object.

        :param id: The id of this LexV2BotAlias.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this LexV2BotAlias.


        :return: The name of this LexV2BotAlias.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this LexV2BotAlias.


        :param name: The name of this LexV2BotAlias.
        :type: str
        """
        

        self._name = name

    @property
    def region(self) -> str:
        """
        Gets the region of this LexV2BotAlias.
        The Lex V2 bot region

        :return: The region of this LexV2BotAlias.
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region: str) -> None:
        """
        Sets the region of this LexV2BotAlias.
        The Lex V2 bot region

        :param region: The region of this LexV2BotAlias.
        :type: str
        """
        

        self._region = region

    @property
    def alias_id(self) -> str:
        """
        Gets the alias_id of this LexV2BotAlias.
        The Lex V2 bot alias Id

        :return: The alias_id of this LexV2BotAlias.
        :rtype: str
        """
        return self._alias_id

    @alias_id.setter
    def alias_id(self, alias_id: str) -> None:
        """
        Sets the alias_id of this LexV2BotAlias.
        The Lex V2 bot alias Id

        :param alias_id: The alias_id of this LexV2BotAlias.
        :type: str
        """
        

        self._alias_id = alias_id

    @property
    def bot(self) -> 'LexV2Bot':
        """
        Gets the bot of this LexV2BotAlias.
        The Lex V2 bot this is an alias for

        :return: The bot of this LexV2BotAlias.
        :rtype: LexV2Bot
        """
        return self._bot

    @bot.setter
    def bot(self, bot: 'LexV2Bot') -> None:
        """
        Sets the bot of this LexV2BotAlias.
        The Lex V2 bot this is an alias for

        :param bot: The bot of this LexV2BotAlias.
        :type: LexV2Bot
        """
        

        self._bot = bot

    @property
    def bot_version(self) -> str:
        """
        Gets the bot_version of this LexV2BotAlias.
        The version of the Lex V2 bot this alias points at

        :return: The bot_version of this LexV2BotAlias.
        :rtype: str
        """
        return self._bot_version

    @bot_version.setter
    def bot_version(self, bot_version: str) -> None:
        """
        Sets the bot_version of this LexV2BotAlias.
        The version of the Lex V2 bot this alias points at

        :param bot_version: The bot_version of this LexV2BotAlias.
        :type: str
        """
        

        self._bot_version = bot_version

    @property
    def status(self) -> str:
        """
        Gets the status of this LexV2BotAlias.
        The status of the Lex V2 bot alias

        :return: The status of this LexV2BotAlias.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this LexV2BotAlias.
        The status of the Lex V2 bot alias

        :param status: The status of this LexV2BotAlias.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Creating", "Available", "Deleting", "Failed"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def language(self) -> str:
        """
        Gets the language of this LexV2BotAlias.
        The target language of the Lex V2 bot

        :return: The language of this LexV2BotAlias.
        :rtype: str
        """
        return self._language

    @language.setter
    def language(self, language: str) -> None:
        """
        Sets the language of this LexV2BotAlias.
        The target language of the Lex V2 bot

        :param language: The language of this LexV2BotAlias.
        :type: str
        """
        

        self._language = language

    @property
    def intents(self) -> List['LexV2Intent']:
        """
        Gets the intents of this LexV2BotAlias.
        An array of Intents associated with this bot alias

        :return: The intents of this LexV2BotAlias.
        :rtype: list[LexV2Intent]
        """
        return self._intents

    @intents.setter
    def intents(self, intents: List['LexV2Intent']) -> None:
        """
        Sets the intents of this LexV2BotAlias.
        An array of Intents associated with this bot alias

        :param intents: The intents of this LexV2BotAlias.
        :type: list[LexV2Intent]
        """
        

        self._intents = intents

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this LexV2BotAlias.
        The URI for this object

        :return: The self_uri of this LexV2BotAlias.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this LexV2BotAlias.
        The URI for this object

        :param self_uri: The self_uri of this LexV2BotAlias.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

