# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class LearningScormResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        LearningScormResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'status': 'str',
            'error_code': 'str',
            'error_message': 'str',
            'percentage_unpacked': 'float',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'status': 'status',
            'error_code': 'errorCode',
            'error_message': 'errorMessage',
            'percentage_unpacked': 'percentageUnpacked',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._status = None
        self._error_code = None
        self._error_message = None
        self._percentage_unpacked = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this LearningScormResponse.
        The globally unique identifier for the object.

        :return: The id of this LearningScormResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this LearningScormResponse.
        The globally unique identifier for the object.

        :param id: The id of this LearningScormResponse.
        :type: str
        """
        

        self._id = id

    @property
    def status(self) -> str:
        """
        Gets the status of this LearningScormResponse.
        The status of the SCORM package

        :return: The status of this LearningScormResponse.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this LearningScormResponse.
        The status of the SCORM package

        :param status: The status of this LearningScormResponse.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["UploadPending", "Unpacking", "Error", "Ready"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def error_code(self) -> str:
        """
        Gets the error_code of this LearningScormResponse.
        The error code of the SCORM package (on failure)

        :return: The error_code of this LearningScormResponse.
        :rtype: str
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code: str) -> None:
        """
        Sets the error_code of this LearningScormResponse.
        The error code of the SCORM package (on failure)

        :param error_code: The error_code of this LearningScormResponse.
        :type: str
        """
        

        self._error_code = error_code

    @property
    def error_message(self) -> str:
        """
        Gets the error_message of this LearningScormResponse.
        The error message associated with the error code

        :return: The error_message of this LearningScormResponse.
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message: str) -> None:
        """
        Sets the error_message of this LearningScormResponse.
        The error message associated with the error code

        :param error_message: The error_message of this LearningScormResponse.
        :type: str
        """
        

        self._error_message = error_message

    @property
    def percentage_unpacked(self) -> float:
        """
        Gets the percentage_unpacked of this LearningScormResponse.
        The percentage of the SCORM package that has been unpacked

        :return: The percentage_unpacked of this LearningScormResponse.
        :rtype: float
        """
        return self._percentage_unpacked

    @percentage_unpacked.setter
    def percentage_unpacked(self, percentage_unpacked: float) -> None:
        """
        Sets the percentage_unpacked of this LearningScormResponse.
        The percentage of the SCORM package that has been unpacked

        :param percentage_unpacked: The percentage_unpacked of this LearningScormResponse.
        :type: float
        """
        

        self._percentage_unpacked = percentage_unpacked

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this LearningScormResponse.
        The URI for this object

        :return: The self_uri of this LearningScormResponse.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this LearningScormResponse.
        The URI for this object

        :param self_uri: The self_uri of this LearningScormResponse.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

