# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AssessmentForm
    from . import LearningAssessment
    from . import LearningModulePreviewUpdateRequestCurrentStep
    from . import LearningModulePreviewUpdateStep

class LearningModulePreviewUpdateRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        LearningModulePreviewUpdateRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'state': 'str',
            'current_step': 'LearningModulePreviewUpdateRequestCurrentStep',
            'steps': 'list[LearningModulePreviewUpdateStep]',
            'assessment': 'LearningAssessment',
            'assessment_form': 'AssessmentForm'
        }

        self.attribute_map = {
            'state': 'state',
            'current_step': 'currentStep',
            'steps': 'steps',
            'assessment': 'assessment',
            'assessment_form': 'assessmentForm'
        }

        self._state = None
        self._current_step = None
        self._steps = None
        self._assessment = None
        self._assessment_form = None

    @property
    def state(self) -> str:
        """
        Gets the state of this LearningModulePreviewUpdateRequest.
        The assignment State

        :return: The state of this LearningModulePreviewUpdateRequest.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this LearningModulePreviewUpdateRequest.
        The assignment State

        :param state: The state of this LearningModulePreviewUpdateRequest.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["Assigned", "InProgress", "Completed", "Deleted", "NotCompleted", "InvalidSchedule"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def current_step(self) -> 'LearningModulePreviewUpdateRequestCurrentStep':
        """
        Gets the current_step of this LearningModulePreviewUpdateRequest.
        The assignment current step

        :return: The current_step of this LearningModulePreviewUpdateRequest.
        :rtype: LearningModulePreviewUpdateRequestCurrentStep
        """
        return self._current_step

    @current_step.setter
    def current_step(self, current_step: 'LearningModulePreviewUpdateRequestCurrentStep') -> None:
        """
        Sets the current_step of this LearningModulePreviewUpdateRequest.
        The assignment current step

        :param current_step: The current_step of this LearningModulePreviewUpdateRequest.
        :type: LearningModulePreviewUpdateRequestCurrentStep
        """
        

        self._current_step = current_step

    @property
    def steps(self) -> List['LearningModulePreviewUpdateStep']:
        """
        Gets the steps of this LearningModulePreviewUpdateRequest.
        The assignment Steps

        :return: The steps of this LearningModulePreviewUpdateRequest.
        :rtype: list[LearningModulePreviewUpdateStep]
        """
        return self._steps

    @steps.setter
    def steps(self, steps: List['LearningModulePreviewUpdateStep']) -> None:
        """
        Sets the steps of this LearningModulePreviewUpdateRequest.
        The assignment Steps

        :param steps: The steps of this LearningModulePreviewUpdateRequest.
        :type: list[LearningModulePreviewUpdateStep]
        """
        

        self._steps = steps

    @property
    def assessment(self) -> 'LearningAssessment':
        """
        Gets the assessment of this LearningModulePreviewUpdateRequest.
        The assessment for learning module

        :return: The assessment of this LearningModulePreviewUpdateRequest.
        :rtype: LearningAssessment
        """
        return self._assessment

    @assessment.setter
    def assessment(self, assessment: 'LearningAssessment') -> None:
        """
        Sets the assessment of this LearningModulePreviewUpdateRequest.
        The assessment for learning module

        :param assessment: The assessment of this LearningModulePreviewUpdateRequest.
        :type: LearningAssessment
        """
        

        self._assessment = assessment

    @property
    def assessment_form(self) -> 'AssessmentForm':
        """
        Gets the assessment_form of this LearningModulePreviewUpdateRequest.
        The assessment form for learning module

        :return: The assessment_form of this LearningModulePreviewUpdateRequest.
        :rtype: AssessmentForm
        """
        return self._assessment_form

    @assessment_form.setter
    def assessment_form(self, assessment_form: 'AssessmentForm') -> None:
        """
        Sets the assessment_form of this LearningModulePreviewUpdateRequest.
        The assessment form for learning module

        :param assessment_form: The assessment_form of this LearningModulePreviewUpdateRequest.
        :type: AssessmentForm
        """
        

        self._assessment_form = assessment_form

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

