# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AssessmentForm
    from . import LearningModuleCoverArtResponse
    from . import LearningModulePreviewGetResponseAssignment
    from . import ReviewAssessmentResults

class LearningModulePreviewGetResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        LearningModulePreviewGetResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'cover_art': 'LearningModuleCoverArtResponse',
            'enforce_content_order': 'bool',
            'review_assessment_results': 'ReviewAssessmentResults',
            'assessment_form': 'AssessmentForm',
            'assignment': 'LearningModulePreviewGetResponseAssignment',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'cover_art': 'coverArt',
            'enforce_content_order': 'enforceContentOrder',
            'review_assessment_results': 'reviewAssessmentResults',
            'assessment_form': 'assessmentForm',
            'assignment': 'assignment',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._description = None
        self._cover_art = None
        self._enforce_content_order = None
        self._review_assessment_results = None
        self._assessment_form = None
        self._assignment = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this LearningModulePreviewGetResponse.
        The globally unique identifier for the object.

        :return: The id of this LearningModulePreviewGetResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this LearningModulePreviewGetResponse.
        The globally unique identifier for the object.

        :param id: The id of this LearningModulePreviewGetResponse.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this LearningModulePreviewGetResponse.
        The name of learning module

        :return: The name of this LearningModulePreviewGetResponse.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this LearningModulePreviewGetResponse.
        The name of learning module

        :param name: The name of this LearningModulePreviewGetResponse.
        :type: str
        """
        

        self._name = name

    @property
    def description(self) -> str:
        """
        Gets the description of this LearningModulePreviewGetResponse.
        The description of learning module

        :return: The description of this LearningModulePreviewGetResponse.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this LearningModulePreviewGetResponse.
        The description of learning module

        :param description: The description of this LearningModulePreviewGetResponse.
        :type: str
        """
        

        self._description = description

    @property
    def cover_art(self) -> 'LearningModuleCoverArtResponse':
        """
        Gets the cover_art of this LearningModulePreviewGetResponse.
        The cover art for the learning module

        :return: The cover_art of this LearningModulePreviewGetResponse.
        :rtype: LearningModuleCoverArtResponse
        """
        return self._cover_art

    @cover_art.setter
    def cover_art(self, cover_art: 'LearningModuleCoverArtResponse') -> None:
        """
        Sets the cover_art of this LearningModulePreviewGetResponse.
        The cover art for the learning module

        :param cover_art: The cover_art of this LearningModulePreviewGetResponse.
        :type: LearningModuleCoverArtResponse
        """
        

        self._cover_art = cover_art

    @property
    def enforce_content_order(self) -> bool:
        """
        Gets the enforce_content_order of this LearningModulePreviewGetResponse.
        If true, learning module content should be viewed one by one in order

        :return: The enforce_content_order of this LearningModulePreviewGetResponse.
        :rtype: bool
        """
        return self._enforce_content_order

    @enforce_content_order.setter
    def enforce_content_order(self, enforce_content_order: bool) -> None:
        """
        Sets the enforce_content_order of this LearningModulePreviewGetResponse.
        If true, learning module content should be viewed one by one in order

        :param enforce_content_order: The enforce_content_order of this LearningModulePreviewGetResponse.
        :type: bool
        """
        

        self._enforce_content_order = enforce_content_order

    @property
    def review_assessment_results(self) -> 'ReviewAssessmentResults':
        """
        Gets the review_assessment_results of this LearningModulePreviewGetResponse.
        Allows to view Assessment results in detail

        :return: The review_assessment_results of this LearningModulePreviewGetResponse.
        :rtype: ReviewAssessmentResults
        """
        return self._review_assessment_results

    @review_assessment_results.setter
    def review_assessment_results(self, review_assessment_results: 'ReviewAssessmentResults') -> None:
        """
        Sets the review_assessment_results of this LearningModulePreviewGetResponse.
        Allows to view Assessment results in detail

        :param review_assessment_results: The review_assessment_results of this LearningModulePreviewGetResponse.
        :type: ReviewAssessmentResults
        """
        

        self._review_assessment_results = review_assessment_results

    @property
    def assessment_form(self) -> 'AssessmentForm':
        """
        Gets the assessment_form of this LearningModulePreviewGetResponse.
        The assessment form for learning module

        :return: The assessment_form of this LearningModulePreviewGetResponse.
        :rtype: AssessmentForm
        """
        return self._assessment_form

    @assessment_form.setter
    def assessment_form(self, assessment_form: 'AssessmentForm') -> None:
        """
        Sets the assessment_form of this LearningModulePreviewGetResponse.
        The assessment form for learning module

        :param assessment_form: The assessment_form of this LearningModulePreviewGetResponse.
        :type: AssessmentForm
        """
        

        self._assessment_form = assessment_form

    @property
    def assignment(self) -> 'LearningModulePreviewGetResponseAssignment':
        """
        Gets the assignment of this LearningModulePreviewGetResponse.
        the assignment preview

        :return: The assignment of this LearningModulePreviewGetResponse.
        :rtype: LearningModulePreviewGetResponseAssignment
        """
        return self._assignment

    @assignment.setter
    def assignment(self, assignment: 'LearningModulePreviewGetResponseAssignment') -> None:
        """
        Sets the assignment of this LearningModulePreviewGetResponse.
        the assignment preview

        :param assignment: The assignment of this LearningModulePreviewGetResponse.
        :type: LearningModulePreviewGetResponseAssignment
        """
        

        self._assignment = assignment

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this LearningModulePreviewGetResponse.
        The URI for this object

        :return: The self_uri of this LearningModulePreviewGetResponse.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this LearningModulePreviewGetResponse.
        The URI for this object

        :param self_uri: The self_uri of this LearningModulePreviewGetResponse.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

