# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class KnowledgeSyncJobStatistics(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        KnowledgeSyncJobStatistics - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'count_document_import_activity_create': 'int',
            'count_document_import_activity_update': 'int',
            'count_document_state_draft': 'int',
            'count_document_state_published': 'int',
            'count_document_import_success': 'int',
            'count_document_import_failure': 'int',
            'count_category_import_success': 'int',
            'count_category_import_failure': 'int',
            'count_label_import_success': 'int',
            'count_label_import_failure': 'int',
            'count_document_delete_success': 'int',
            'count_document_delete_failure': 'int',
            'count_category_delete_success': 'int',
            'count_category_delete_failure': 'int',
            'count_label_delete_success': 'int',
            'count_label_delete_failure': 'int'
        }

        self.attribute_map = {
            'count_document_import_activity_create': 'countDocumentImportActivityCreate',
            'count_document_import_activity_update': 'countDocumentImportActivityUpdate',
            'count_document_state_draft': 'countDocumentStateDraft',
            'count_document_state_published': 'countDocumentStatePublished',
            'count_document_import_success': 'countDocumentImportSuccess',
            'count_document_import_failure': 'countDocumentImportFailure',
            'count_category_import_success': 'countCategoryImportSuccess',
            'count_category_import_failure': 'countCategoryImportFailure',
            'count_label_import_success': 'countLabelImportSuccess',
            'count_label_import_failure': 'countLabelImportFailure',
            'count_document_delete_success': 'countDocumentDeleteSuccess',
            'count_document_delete_failure': 'countDocumentDeleteFailure',
            'count_category_delete_success': 'countCategoryDeleteSuccess',
            'count_category_delete_failure': 'countCategoryDeleteFailure',
            'count_label_delete_success': 'countLabelDeleteSuccess',
            'count_label_delete_failure': 'countLabelDeleteFailure'
        }

        self._count_document_import_activity_create = None
        self._count_document_import_activity_update = None
        self._count_document_state_draft = None
        self._count_document_state_published = None
        self._count_document_import_success = None
        self._count_document_import_failure = None
        self._count_category_import_success = None
        self._count_category_import_failure = None
        self._count_label_import_success = None
        self._count_label_import_failure = None
        self._count_document_delete_success = None
        self._count_document_delete_failure = None
        self._count_category_delete_success = None
        self._count_category_delete_failure = None
        self._count_label_delete_success = None
        self._count_label_delete_failure = None

    @property
    def count_document_import_activity_create(self) -> int:
        """
        Gets the count_document_import_activity_create of this KnowledgeSyncJobStatistics.
        Number of documents will be created by the sync.

        :return: The count_document_import_activity_create of this KnowledgeSyncJobStatistics.
        :rtype: int
        """
        return self._count_document_import_activity_create

    @count_document_import_activity_create.setter
    def count_document_import_activity_create(self, count_document_import_activity_create: int) -> None:
        """
        Sets the count_document_import_activity_create of this KnowledgeSyncJobStatistics.
        Number of documents will be created by the sync.

        :param count_document_import_activity_create: The count_document_import_activity_create of this KnowledgeSyncJobStatistics.
        :type: int
        """
        

        self._count_document_import_activity_create = count_document_import_activity_create

    @property
    def count_document_import_activity_update(self) -> int:
        """
        Gets the count_document_import_activity_update of this KnowledgeSyncJobStatistics.
        Number of documents will be updated by the sync.

        :return: The count_document_import_activity_update of this KnowledgeSyncJobStatistics.
        :rtype: int
        """
        return self._count_document_import_activity_update

    @count_document_import_activity_update.setter
    def count_document_import_activity_update(self, count_document_import_activity_update: int) -> None:
        """
        Sets the count_document_import_activity_update of this KnowledgeSyncJobStatistics.
        Number of documents will be updated by the sync.

        :param count_document_import_activity_update: The count_document_import_activity_update of this KnowledgeSyncJobStatistics.
        :type: int
        """
        

        self._count_document_import_activity_update = count_document_import_activity_update

    @property
    def count_document_state_draft(self) -> int:
        """
        Gets the count_document_state_draft of this KnowledgeSyncJobStatistics.
        Number of documents will be imported as draft.

        :return: The count_document_state_draft of this KnowledgeSyncJobStatistics.
        :rtype: int
        """
        return self._count_document_state_draft

    @count_document_state_draft.setter
    def count_document_state_draft(self, count_document_state_draft: int) -> None:
        """
        Sets the count_document_state_draft of this KnowledgeSyncJobStatistics.
        Number of documents will be imported as draft.

        :param count_document_state_draft: The count_document_state_draft of this KnowledgeSyncJobStatistics.
        :type: int
        """
        

        self._count_document_state_draft = count_document_state_draft

    @property
    def count_document_state_published(self) -> int:
        """
        Gets the count_document_state_published of this KnowledgeSyncJobStatistics.
        Number of documents will be imported as published.

        :return: The count_document_state_published of this KnowledgeSyncJobStatistics.
        :rtype: int
        """
        return self._count_document_state_published

    @count_document_state_published.setter
    def count_document_state_published(self, count_document_state_published: int) -> None:
        """
        Sets the count_document_state_published of this KnowledgeSyncJobStatistics.
        Number of documents will be imported as published.

        :param count_document_state_published: The count_document_state_published of this KnowledgeSyncJobStatistics.
        :type: int
        """
        

        self._count_document_state_published = count_document_state_published

    @property
    def count_document_import_success(self) -> int:
        """
        Gets the count_document_import_success of this KnowledgeSyncJobStatistics.
        Number of imported documents.

        :return: The count_document_import_success of this KnowledgeSyncJobStatistics.
        :rtype: int
        """
        return self._count_document_import_success

    @count_document_import_success.setter
    def count_document_import_success(self, count_document_import_success: int) -> None:
        """
        Sets the count_document_import_success of this KnowledgeSyncJobStatistics.
        Number of imported documents.

        :param count_document_import_success: The count_document_import_success of this KnowledgeSyncJobStatistics.
        :type: int
        """
        

        self._count_document_import_success = count_document_import_success

    @property
    def count_document_import_failure(self) -> int:
        """
        Gets the count_document_import_failure of this KnowledgeSyncJobStatistics.
        Number of documents failed to import.

        :return: The count_document_import_failure of this KnowledgeSyncJobStatistics.
        :rtype: int
        """
        return self._count_document_import_failure

    @count_document_import_failure.setter
    def count_document_import_failure(self, count_document_import_failure: int) -> None:
        """
        Sets the count_document_import_failure of this KnowledgeSyncJobStatistics.
        Number of documents failed to import.

        :param count_document_import_failure: The count_document_import_failure of this KnowledgeSyncJobStatistics.
        :type: int
        """
        

        self._count_document_import_failure = count_document_import_failure

    @property
    def count_category_import_success(self) -> int:
        """
        Gets the count_category_import_success of this KnowledgeSyncJobStatistics.
        Number of imported categories.

        :return: The count_category_import_success of this KnowledgeSyncJobStatistics.
        :rtype: int
        """
        return self._count_category_import_success

    @count_category_import_success.setter
    def count_category_import_success(self, count_category_import_success: int) -> None:
        """
        Sets the count_category_import_success of this KnowledgeSyncJobStatistics.
        Number of imported categories.

        :param count_category_import_success: The count_category_import_success of this KnowledgeSyncJobStatistics.
        :type: int
        """
        

        self._count_category_import_success = count_category_import_success

    @property
    def count_category_import_failure(self) -> int:
        """
        Gets the count_category_import_failure of this KnowledgeSyncJobStatistics.
        Number of categories failed to import.

        :return: The count_category_import_failure of this KnowledgeSyncJobStatistics.
        :rtype: int
        """
        return self._count_category_import_failure

    @count_category_import_failure.setter
    def count_category_import_failure(self, count_category_import_failure: int) -> None:
        """
        Sets the count_category_import_failure of this KnowledgeSyncJobStatistics.
        Number of categories failed to import.

        :param count_category_import_failure: The count_category_import_failure of this KnowledgeSyncJobStatistics.
        :type: int
        """
        

        self._count_category_import_failure = count_category_import_failure

    @property
    def count_label_import_success(self) -> int:
        """
        Gets the count_label_import_success of this KnowledgeSyncJobStatistics.
        Number of imported labels.

        :return: The count_label_import_success of this KnowledgeSyncJobStatistics.
        :rtype: int
        """
        return self._count_label_import_success

    @count_label_import_success.setter
    def count_label_import_success(self, count_label_import_success: int) -> None:
        """
        Sets the count_label_import_success of this KnowledgeSyncJobStatistics.
        Number of imported labels.

        :param count_label_import_success: The count_label_import_success of this KnowledgeSyncJobStatistics.
        :type: int
        """
        

        self._count_label_import_success = count_label_import_success

    @property
    def count_label_import_failure(self) -> int:
        """
        Gets the count_label_import_failure of this KnowledgeSyncJobStatistics.
        Number of labels failed to import.

        :return: The count_label_import_failure of this KnowledgeSyncJobStatistics.
        :rtype: int
        """
        return self._count_label_import_failure

    @count_label_import_failure.setter
    def count_label_import_failure(self, count_label_import_failure: int) -> None:
        """
        Sets the count_label_import_failure of this KnowledgeSyncJobStatistics.
        Number of labels failed to import.

        :param count_label_import_failure: The count_label_import_failure of this KnowledgeSyncJobStatistics.
        :type: int
        """
        

        self._count_label_import_failure = count_label_import_failure

    @property
    def count_document_delete_success(self) -> int:
        """
        Gets the count_document_delete_success of this KnowledgeSyncJobStatistics.
        Number of documents will be deleted by the sync.

        :return: The count_document_delete_success of this KnowledgeSyncJobStatistics.
        :rtype: int
        """
        return self._count_document_delete_success

    @count_document_delete_success.setter
    def count_document_delete_success(self, count_document_delete_success: int) -> None:
        """
        Sets the count_document_delete_success of this KnowledgeSyncJobStatistics.
        Number of documents will be deleted by the sync.

        :param count_document_delete_success: The count_document_delete_success of this KnowledgeSyncJobStatistics.
        :type: int
        """
        

        self._count_document_delete_success = count_document_delete_success

    @property
    def count_document_delete_failure(self) -> int:
        """
        Gets the count_document_delete_failure of this KnowledgeSyncJobStatistics.
        Number of documents failed to delete.

        :return: The count_document_delete_failure of this KnowledgeSyncJobStatistics.
        :rtype: int
        """
        return self._count_document_delete_failure

    @count_document_delete_failure.setter
    def count_document_delete_failure(self, count_document_delete_failure: int) -> None:
        """
        Sets the count_document_delete_failure of this KnowledgeSyncJobStatistics.
        Number of documents failed to delete.

        :param count_document_delete_failure: The count_document_delete_failure of this KnowledgeSyncJobStatistics.
        :type: int
        """
        

        self._count_document_delete_failure = count_document_delete_failure

    @property
    def count_category_delete_success(self) -> int:
        """
        Gets the count_category_delete_success of this KnowledgeSyncJobStatistics.
        Number of successfully deleted categories.

        :return: The count_category_delete_success of this KnowledgeSyncJobStatistics.
        :rtype: int
        """
        return self._count_category_delete_success

    @count_category_delete_success.setter
    def count_category_delete_success(self, count_category_delete_success: int) -> None:
        """
        Sets the count_category_delete_success of this KnowledgeSyncJobStatistics.
        Number of successfully deleted categories.

        :param count_category_delete_success: The count_category_delete_success of this KnowledgeSyncJobStatistics.
        :type: int
        """
        

        self._count_category_delete_success = count_category_delete_success

    @property
    def count_category_delete_failure(self) -> int:
        """
        Gets the count_category_delete_failure of this KnowledgeSyncJobStatistics.
        Number of categories failed to delete.

        :return: The count_category_delete_failure of this KnowledgeSyncJobStatistics.
        :rtype: int
        """
        return self._count_category_delete_failure

    @count_category_delete_failure.setter
    def count_category_delete_failure(self, count_category_delete_failure: int) -> None:
        """
        Sets the count_category_delete_failure of this KnowledgeSyncJobStatistics.
        Number of categories failed to delete.

        :param count_category_delete_failure: The count_category_delete_failure of this KnowledgeSyncJobStatistics.
        :type: int
        """
        

        self._count_category_delete_failure = count_category_delete_failure

    @property
    def count_label_delete_success(self) -> int:
        """
        Gets the count_label_delete_success of this KnowledgeSyncJobStatistics.
        Number of successfully deleted labels.

        :return: The count_label_delete_success of this KnowledgeSyncJobStatistics.
        :rtype: int
        """
        return self._count_label_delete_success

    @count_label_delete_success.setter
    def count_label_delete_success(self, count_label_delete_success: int) -> None:
        """
        Sets the count_label_delete_success of this KnowledgeSyncJobStatistics.
        Number of successfully deleted labels.

        :param count_label_delete_success: The count_label_delete_success of this KnowledgeSyncJobStatistics.
        :type: int
        """
        

        self._count_label_delete_success = count_label_delete_success

    @property
    def count_label_delete_failure(self) -> int:
        """
        Gets the count_label_delete_failure of this KnowledgeSyncJobStatistics.
        Number of labels failed to delete.

        :return: The count_label_delete_failure of this KnowledgeSyncJobStatistics.
        :rtype: int
        """
        return self._count_label_delete_failure

    @count_label_delete_failure.setter
    def count_label_delete_failure(self, count_label_delete_failure: int) -> None:
        """
        Sets the count_label_delete_failure of this KnowledgeSyncJobStatistics.
        Number of labels failed to delete.

        :param count_label_delete_failure: The count_label_delete_failure of this KnowledgeSyncJobStatistics.
        :type: int
        """
        

        self._count_label_delete_failure = count_label_delete_failure

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

