# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import Entity

class KnowledgeExportJobDocumentsFilter(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        KnowledgeExportJobDocumentsFilter - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'interval': 'str',
            'entities': 'list[Entity]',
            'source_id': 'str',
            'include_documents_with_file_body': 'bool'
        }

        self.attribute_map = {
            'interval': 'interval',
            'entities': 'entities',
            'source_id': 'sourceId',
            'include_documents_with_file_body': 'includeDocumentsWithFileBody'
        }

        self._interval = None
        self._entities = None
        self._source_id = None
        self._include_documents_with_file_body = None

    @property
    def interval(self) -> str:
        """
        Gets the interval of this KnowledgeExportJobDocumentsFilter.
        Retrieves the documents modified in specified date and time range. Cannot be used together with entities filter. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss

        :return: The interval of this KnowledgeExportJobDocumentsFilter.
        :rtype: str
        """
        return self._interval

    @interval.setter
    def interval(self, interval: str) -> None:
        """
        Sets the interval of this KnowledgeExportJobDocumentsFilter.
        Retrieves the documents modified in specified date and time range. Cannot be used together with entities filter. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss

        :param interval: The interval of this KnowledgeExportJobDocumentsFilter.
        :type: str
        """
        

        self._interval = interval

    @property
    def entities(self) -> List['Entity']:
        """
        Gets the entities of this KnowledgeExportJobDocumentsFilter.
        Retrieves the documents with the given ids. Cannot be used together with internal filter.

        :return: The entities of this KnowledgeExportJobDocumentsFilter.
        :rtype: list[Entity]
        """
        return self._entities

    @entities.setter
    def entities(self, entities: List['Entity']) -> None:
        """
        Sets the entities of this KnowledgeExportJobDocumentsFilter.
        Retrieves the documents with the given ids. Cannot be used together with internal filter.

        :param entities: The entities of this KnowledgeExportJobDocumentsFilter.
        :type: list[Entity]
        """
        

        self._entities = entities

    @property
    def source_id(self) -> str:
        """
        Gets the source_id of this KnowledgeExportJobDocumentsFilter.


        :return: The source_id of this KnowledgeExportJobDocumentsFilter.
        :rtype: str
        """
        return self._source_id

    @source_id.setter
    def source_id(self, source_id: str) -> None:
        """
        Sets the source_id of this KnowledgeExportJobDocumentsFilter.


        :param source_id: The source_id of this KnowledgeExportJobDocumentsFilter.
        :type: str
        """
        

        self._source_id = source_id

    @property
    def include_documents_with_file_body(self) -> bool:
        """
        Gets the include_documents_with_file_body of this KnowledgeExportJobDocumentsFilter.


        :return: The include_documents_with_file_body of this KnowledgeExportJobDocumentsFilter.
        :rtype: bool
        """
        return self._include_documents_with_file_body

    @include_documents_with_file_body.setter
    def include_documents_with_file_body(self, include_documents_with_file_body: bool) -> None:
        """
        Sets the include_documents_with_file_body of this KnowledgeExportJobDocumentsFilter.


        :param include_documents_with_file_body: The include_documents_with_file_body of this KnowledgeExportJobDocumentsFilter.
        :type: bool
        """
        

        self._include_documents_with_file_body = include_documents_with_file_body

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

