# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import KnowledgeAnswerGenerationResponse
    from . import KnowledgeConversationContextResponse
    from . import KnowledgeDocumentSearchResult
    from . import KnowledgeSearchClientApplication

class KnowledgeDocumentSearch(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        KnowledgeDocumentSearch - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'query': 'str',
            'page_size': 'int',
            'page_number': 'int',
            'search_id': 'str',
            'total': 'int',
            'page_count': 'int',
            'query_type': 'str',
            'results': 'list[KnowledgeDocumentSearchResult]',
            'application': 'KnowledgeSearchClientApplication',
            'conversation_context': 'KnowledgeConversationContextResponse',
            'confidence_threshold': 'float',
            'answer_generation': 'KnowledgeAnswerGenerationResponse'
        }

        self.attribute_map = {
            'query': 'query',
            'page_size': 'pageSize',
            'page_number': 'pageNumber',
            'search_id': 'searchId',
            'total': 'total',
            'page_count': 'pageCount',
            'query_type': 'queryType',
            'results': 'results',
            'application': 'application',
            'conversation_context': 'conversationContext',
            'confidence_threshold': 'confidenceThreshold',
            'answer_generation': 'answerGeneration'
        }

        self._query = None
        self._page_size = None
        self._page_number = None
        self._search_id = None
        self._total = None
        self._page_count = None
        self._query_type = None
        self._results = None
        self._application = None
        self._conversation_context = None
        self._confidence_threshold = None
        self._answer_generation = None

    @property
    def query(self) -> str:
        """
        Gets the query of this KnowledgeDocumentSearch.
        Query to search content in the knowledge base. Maximum of 30 records per query can be fetched.

        :return: The query of this KnowledgeDocumentSearch.
        :rtype: str
        """
        return self._query

    @query.setter
    def query(self, query: str) -> None:
        """
        Sets the query of this KnowledgeDocumentSearch.
        Query to search content in the knowledge base. Maximum of 30 records per query can be fetched.

        :param query: The query of this KnowledgeDocumentSearch.
        :type: str
        """
        
        if len(query) > 2147483647:
            raise ValueError("Invalid value for `query`, length must be less than `2147483647`")

        if len(query) < 3:
            raise ValueError("Invalid value for `query`, length must be greater than or equal to `3`")


        self._query = query

    @property
    def page_size(self) -> int:
        """
        Gets the page_size of this KnowledgeDocumentSearch.
        Page size of the returned results.

        :return: The page_size of this KnowledgeDocumentSearch.
        :rtype: int
        """
        return self._page_size

    @page_size.setter
    def page_size(self, page_size: int) -> None:
        """
        Sets the page_size of this KnowledgeDocumentSearch.
        Page size of the returned results.

        :param page_size: The page_size of this KnowledgeDocumentSearch.
        :type: int
        """
        

        self._page_size = page_size

    @property
    def page_number(self) -> int:
        """
        Gets the page_number of this KnowledgeDocumentSearch.
        Page number of the returned results.

        :return: The page_number of this KnowledgeDocumentSearch.
        :rtype: int
        """
        return self._page_number

    @page_number.setter
    def page_number(self, page_number: int) -> None:
        """
        Sets the page_number of this KnowledgeDocumentSearch.
        Page number of the returned results.

        :param page_number: The page_number of this KnowledgeDocumentSearch.
        :type: int
        """
        

        self._page_number = page_number

    @property
    def search_id(self) -> str:
        """
        Gets the search_id of this KnowledgeDocumentSearch.
        The globally unique identifier for the search.

        :return: The search_id of this KnowledgeDocumentSearch.
        :rtype: str
        """
        return self._search_id

    @search_id.setter
    def search_id(self, search_id: str) -> None:
        """
        Sets the search_id of this KnowledgeDocumentSearch.
        The globally unique identifier for the search.

        :param search_id: The search_id of this KnowledgeDocumentSearch.
        :type: str
        """
        

        self._search_id = search_id

    @property
    def total(self) -> int:
        """
        Gets the total of this KnowledgeDocumentSearch.
        The total number of documents matching the query.

        :return: The total of this KnowledgeDocumentSearch.
        :rtype: int
        """
        return self._total

    @total.setter
    def total(self, total: int) -> None:
        """
        Sets the total of this KnowledgeDocumentSearch.
        The total number of documents matching the query.

        :param total: The total of this KnowledgeDocumentSearch.
        :type: int
        """
        

        self._total = total

    @property
    def page_count(self) -> int:
        """
        Gets the page_count of this KnowledgeDocumentSearch.
        Number of pages returned in the result calculated according to the pageSize and the total

        :return: The page_count of this KnowledgeDocumentSearch.
        :rtype: int
        """
        return self._page_count

    @page_count.setter
    def page_count(self, page_count: int) -> None:
        """
        Sets the page_count of this KnowledgeDocumentSearch.
        Number of pages returned in the result calculated according to the pageSize and the total

        :param page_count: The page_count of this KnowledgeDocumentSearch.
        :type: int
        """
        

        self._page_count = page_count

    @property
    def query_type(self) -> str:
        """
        Gets the query_type of this KnowledgeDocumentSearch.
        The type of the query that initiates the search.

        :return: The query_type of this KnowledgeDocumentSearch.
        :rtype: str
        """
        return self._query_type

    @query_type.setter
    def query_type(self, query_type: str) -> None:
        """
        Sets the query_type of this KnowledgeDocumentSearch.
        The type of the query that initiates the search.

        :param query_type: The query_type of this KnowledgeDocumentSearch.
        :type: str
        """
        if isinstance(query_type, int):
            query_type = str(query_type)
        allowed_values = ["AutoSearch", "ManualSearch", "Suggestion"]
        if query_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for query_type -> " + query_type)
            self._query_type = "outdated_sdk_version"
        else:
            self._query_type = query_type

    @property
    def results(self) -> List['KnowledgeDocumentSearchResult']:
        """
        Gets the results of this KnowledgeDocumentSearch.
        Documents matching the search query.

        :return: The results of this KnowledgeDocumentSearch.
        :rtype: list[KnowledgeDocumentSearchResult]
        """
        return self._results

    @results.setter
    def results(self, results: List['KnowledgeDocumentSearchResult']) -> None:
        """
        Sets the results of this KnowledgeDocumentSearch.
        Documents matching the search query.

        :param results: The results of this KnowledgeDocumentSearch.
        :type: list[KnowledgeDocumentSearchResult]
        """
        

        self._results = results

    @property
    def application(self) -> 'KnowledgeSearchClientApplication':
        """
        Gets the application of this KnowledgeDocumentSearch.
        The client application details from which search happened.

        :return: The application of this KnowledgeDocumentSearch.
        :rtype: KnowledgeSearchClientApplication
        """
        return self._application

    @application.setter
    def application(self, application: 'KnowledgeSearchClientApplication') -> None:
        """
        Sets the application of this KnowledgeDocumentSearch.
        The client application details from which search happened.

        :param application: The application of this KnowledgeDocumentSearch.
        :type: KnowledgeSearchClientApplication
        """
        

        self._application = application

    @property
    def conversation_context(self) -> 'KnowledgeConversationContextResponse':
        """
        Gets the conversation_context of this KnowledgeDocumentSearch.
        Conversation context information if the search is initiated in the context of a conversation.

        :return: The conversation_context of this KnowledgeDocumentSearch.
        :rtype: KnowledgeConversationContextResponse
        """
        return self._conversation_context

    @conversation_context.setter
    def conversation_context(self, conversation_context: 'KnowledgeConversationContextResponse') -> None:
        """
        Sets the conversation_context of this KnowledgeDocumentSearch.
        Conversation context information if the search is initiated in the context of a conversation.

        :param conversation_context: The conversation_context of this KnowledgeDocumentSearch.
        :type: KnowledgeConversationContextResponse
        """
        

        self._conversation_context = conversation_context

    @property
    def confidence_threshold(self) -> float:
        """
        Gets the confidence_threshold of this KnowledgeDocumentSearch.
        The confidence threshold for the search results. If applied, the returned results will have an equal or higher confidence than the threshold.

        :return: The confidence_threshold of this KnowledgeDocumentSearch.
        :rtype: float
        """
        return self._confidence_threshold

    @confidence_threshold.setter
    def confidence_threshold(self, confidence_threshold: float) -> None:
        """
        Sets the confidence_threshold of this KnowledgeDocumentSearch.
        The confidence threshold for the search results. If applied, the returned results will have an equal or higher confidence than the threshold.

        :param confidence_threshold: The confidence_threshold of this KnowledgeDocumentSearch.
        :type: float
        """
        

        self._confidence_threshold = confidence_threshold

    @property
    def answer_generation(self) -> 'KnowledgeAnswerGenerationResponse':
        """
        Gets the answer_generation of this KnowledgeDocumentSearch.
        The results with AI-generated answer if the answerMode request property contains \"AnswerGeneration\".

        :return: The answer_generation of this KnowledgeDocumentSearch.
        :rtype: KnowledgeAnswerGenerationResponse
        """
        return self._answer_generation

    @answer_generation.setter
    def answer_generation(self, answer_generation: 'KnowledgeAnswerGenerationResponse') -> None:
        """
        Sets the answer_generation of this KnowledgeDocumentSearch.
        The results with AI-generated answer if the answerMode request property contains \"AnswerGeneration\".

        :param answer_generation: The answer_generation of this KnowledgeDocumentSearch.
        :type: KnowledgeAnswerGenerationResponse
        """
        

        self._answer_generation = answer_generation

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

