# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DocumentQuery
    from . import DocumentQueryInterval

class KnowledgeDocumentQuery(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        KnowledgeDocumentQuery - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'page_size': 'int',
            'page_number': 'int',
            'include_draft_documents': 'bool',
            'interval': 'DocumentQueryInterval',
            'filter': 'DocumentQuery',
            'include_variations': 'str',
            'sort_order': 'str',
            'sort_by': 'str'
        }

        self.attribute_map = {
            'page_size': 'pageSize',
            'page_number': 'pageNumber',
            'include_draft_documents': 'includeDraftDocuments',
            'interval': 'interval',
            'filter': 'filter',
            'include_variations': 'includeVariations',
            'sort_order': 'sortOrder',
            'sort_by': 'sortBy'
        }

        self._page_size = None
        self._page_number = None
        self._include_draft_documents = None
        self._interval = None
        self._filter = None
        self._include_variations = None
        self._sort_order = None
        self._sort_by = None

    @property
    def page_size(self) -> int:
        """
        Gets the page_size of this KnowledgeDocumentQuery.
        Page size of the returned results.

        :return: The page_size of this KnowledgeDocumentQuery.
        :rtype: int
        """
        return self._page_size

    @page_size.setter
    def page_size(self, page_size: int) -> None:
        """
        Sets the page_size of this KnowledgeDocumentQuery.
        Page size of the returned results.

        :param page_size: The page_size of this KnowledgeDocumentQuery.
        :type: int
        """
        

        self._page_size = page_size

    @property
    def page_number(self) -> int:
        """
        Gets the page_number of this KnowledgeDocumentQuery.
        Page number of the returned results.

        :return: The page_number of this KnowledgeDocumentQuery.
        :rtype: int
        """
        return self._page_number

    @page_number.setter
    def page_number(self, page_number: int) -> None:
        """
        Sets the page_number of this KnowledgeDocumentQuery.
        Page number of the returned results.

        :param page_number: The page_number of this KnowledgeDocumentQuery.
        :type: int
        """
        

        self._page_number = page_number

    @property
    def include_draft_documents(self) -> bool:
        """
        Gets the include_draft_documents of this KnowledgeDocumentQuery.
        Indicates whether the results would also include draft documents.

        :return: The include_draft_documents of this KnowledgeDocumentQuery.
        :rtype: bool
        """
        return self._include_draft_documents

    @include_draft_documents.setter
    def include_draft_documents(self, include_draft_documents: bool) -> None:
        """
        Sets the include_draft_documents of this KnowledgeDocumentQuery.
        Indicates whether the results would also include draft documents.

        :param include_draft_documents: The include_draft_documents of this KnowledgeDocumentQuery.
        :type: bool
        """
        

        self._include_draft_documents = include_draft_documents

    @property
    def interval(self) -> 'DocumentQueryInterval':
        """
        Gets the interval of this KnowledgeDocumentQuery.
        Retrieves the documents created/modified/published in specified date and time range.

        :return: The interval of this KnowledgeDocumentQuery.
        :rtype: DocumentQueryInterval
        """
        return self._interval

    @interval.setter
    def interval(self, interval: 'DocumentQueryInterval') -> None:
        """
        Sets the interval of this KnowledgeDocumentQuery.
        Retrieves the documents created/modified/published in specified date and time range.

        :param interval: The interval of this KnowledgeDocumentQuery.
        :type: DocumentQueryInterval
        """
        

        self._interval = interval

    @property
    def filter(self) -> 'DocumentQuery':
        """
        Gets the filter of this KnowledgeDocumentQuery.
        Filter for the document query.

        :return: The filter of this KnowledgeDocumentQuery.
        :rtype: DocumentQuery
        """
        return self._filter

    @filter.setter
    def filter(self, filter: 'DocumentQuery') -> None:
        """
        Sets the filter of this KnowledgeDocumentQuery.
        Filter for the document query.

        :param filter: The filter of this KnowledgeDocumentQuery.
        :type: DocumentQuery
        """
        

        self._filter = filter

    @property
    def include_variations(self) -> str:
        """
        Gets the include_variations of this KnowledgeDocumentQuery.
        Indicates which document variations to include in returned documents. All: all variations regardless of the filter expression; AllMatching: all variations that match the filter expression; SingleMostRelevant: single variation that matches the filter expression and has the highest priority. The default is All.

        :return: The include_variations of this KnowledgeDocumentQuery.
        :rtype: str
        """
        return self._include_variations

    @include_variations.setter
    def include_variations(self, include_variations: str) -> None:
        """
        Sets the include_variations of this KnowledgeDocumentQuery.
        Indicates which document variations to include in returned documents. All: all variations regardless of the filter expression; AllMatching: all variations that match the filter expression; SingleMostRelevant: single variation that matches the filter expression and has the highest priority. The default is All.

        :param include_variations: The include_variations of this KnowledgeDocumentQuery.
        :type: str
        """
        if isinstance(include_variations, int):
            include_variations = str(include_variations)
        allowed_values = ["All", "AllMatching", "SingleMostRelevant"]
        if include_variations.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for include_variations -> " + include_variations)
            self._include_variations = "outdated_sdk_version"
        else:
            self._include_variations = include_variations

    @property
    def sort_order(self) -> str:
        """
        Gets the sort_order of this KnowledgeDocumentQuery.
        The sort order for results.

        :return: The sort_order of this KnowledgeDocumentQuery.
        :rtype: str
        """
        return self._sort_order

    @sort_order.setter
    def sort_order(self, sort_order: str) -> None:
        """
        Sets the sort_order of this KnowledgeDocumentQuery.
        The sort order for results.

        :param sort_order: The sort_order of this KnowledgeDocumentQuery.
        :type: str
        """
        if isinstance(sort_order, int):
            sort_order = str(sort_order)
        allowed_values = ["Asc", "Desc"]
        if sort_order.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for sort_order -> " + sort_order)
            self._sort_order = "outdated_sdk_version"
        else:
            self._sort_order = sort_order

    @property
    def sort_by(self) -> str:
        """
        Gets the sort_by of this KnowledgeDocumentQuery.
        The field in the documents that you want to sort the results by.

        :return: The sort_by of this KnowledgeDocumentQuery.
        :rtype: str
        """
        return self._sort_by

    @sort_by.setter
    def sort_by(self, sort_by: str) -> None:
        """
        Sets the sort_by of this KnowledgeDocumentQuery.
        The field in the documents that you want to sort the results by.

        :param sort_by: The sort_by of this KnowledgeDocumentQuery.
        :type: str
        """
        if isinstance(sort_by, int):
            sort_by = str(sort_by)
        allowed_values = ["DateCreated", "DateModified", "CategoryName", "LabelName", "ViewCount"]
        if sort_by.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for sort_by -> " + sort_by)
            self._sort_by = "outdated_sdk_version"
        else:
            self._sort_by = sort_by

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

