# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class KnowledgeDocumentFeedbackUpdateRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        KnowledgeDocumentFeedbackUpdateRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'rating': 'str',
            'reason': 'str',
            'comment': 'str',
            'state': 'str'
        }

        self.attribute_map = {
            'rating': 'rating',
            'reason': 'reason',
            'comment': 'comment',
            'state': 'state'
        }

        self._rating = None
        self._reason = None
        self._comment = None
        self._state = None

    @property
    def rating(self) -> str:
        """
        Gets the rating of this KnowledgeDocumentFeedbackUpdateRequest.
        Feedback rating.

        :return: The rating of this KnowledgeDocumentFeedbackUpdateRequest.
        :rtype: str
        """
        return self._rating

    @rating.setter
    def rating(self, rating: str) -> None:
        """
        Sets the rating of this KnowledgeDocumentFeedbackUpdateRequest.
        Feedback rating.

        :param rating: The rating of this KnowledgeDocumentFeedbackUpdateRequest.
        :type: str
        """
        if isinstance(rating, int):
            rating = str(rating)
        allowed_values = ["Negative", "Positive"]
        if rating.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for rating -> " + rating)
            self._rating = "outdated_sdk_version"
        else:
            self._rating = rating

    @property
    def reason(self) -> str:
        """
        Gets the reason of this KnowledgeDocumentFeedbackUpdateRequest.
        Feedback reason

        :return: The reason of this KnowledgeDocumentFeedbackUpdateRequest.
        :rtype: str
        """
        return self._reason

    @reason.setter
    def reason(self, reason: str) -> None:
        """
        Sets the reason of this KnowledgeDocumentFeedbackUpdateRequest.
        Feedback reason

        :param reason: The reason of this KnowledgeDocumentFeedbackUpdateRequest.
        :type: str
        """
        if isinstance(reason, int):
            reason = str(reason)
        allowed_values = ["DocumentContent", "SearchResults"]
        if reason.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for reason -> " + reason)
            self._reason = "outdated_sdk_version"
        else:
            self._reason = reason

    @property
    def comment(self) -> str:
        """
        Gets the comment of this KnowledgeDocumentFeedbackUpdateRequest.
        Feedback comment

        :return: The comment of this KnowledgeDocumentFeedbackUpdateRequest.
        :rtype: str
        """
        return self._comment

    @comment.setter
    def comment(self, comment: str) -> None:
        """
        Sets the comment of this KnowledgeDocumentFeedbackUpdateRequest.
        Feedback comment

        :param comment: The comment of this KnowledgeDocumentFeedbackUpdateRequest.
        :type: str
        """
        

        self._comment = comment

    @property
    def state(self) -> str:
        """
        Gets the state of this KnowledgeDocumentFeedbackUpdateRequest.
        Feedback state

        :return: The state of this KnowledgeDocumentFeedbackUpdateRequest.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this KnowledgeDocumentFeedbackUpdateRequest.
        Feedback state

        :param state: The state of this KnowledgeDocumentFeedbackUpdateRequest.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["Draft", "Final"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

