# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import EntityReference
    from . import KnowledgeConversationContextResponse
    from . import KnowledgeDocumentVersionReference
    from . import KnowledgeSearchClientApplication

class KnowledgeDocumentFeedbackResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        KnowledgeDocumentFeedbackResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'document_variation': 'EntityReference',
            'rating': 'str',
            'reason': 'str',
            'comment': 'str',
            'search': 'EntityReference',
            'session_id': 'str',
            'date_created': 'datetime',
            'query_type': 'str',
            'surfacing_method': 'str',
            'state': 'str',
            'document': 'KnowledgeDocumentVersionReference',
            'application': 'KnowledgeSearchClientApplication',
            'conversation_context': 'KnowledgeConversationContextResponse',
            'user': 'AddressableEntityRef',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'document_variation': 'documentVariation',
            'rating': 'rating',
            'reason': 'reason',
            'comment': 'comment',
            'search': 'search',
            'session_id': 'sessionId',
            'date_created': 'dateCreated',
            'query_type': 'queryType',
            'surfacing_method': 'surfacingMethod',
            'state': 'state',
            'document': 'document',
            'application': 'application',
            'conversation_context': 'conversationContext',
            'user': 'user',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._document_variation = None
        self._rating = None
        self._reason = None
        self._comment = None
        self._search = None
        self._session_id = None
        self._date_created = None
        self._query_type = None
        self._surfacing_method = None
        self._state = None
        self._document = None
        self._application = None
        self._conversation_context = None
        self._user = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this KnowledgeDocumentFeedbackResponse.
        The globally unique identifier for the object.

        :return: The id of this KnowledgeDocumentFeedbackResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this KnowledgeDocumentFeedbackResponse.
        The globally unique identifier for the object.

        :param id: The id of this KnowledgeDocumentFeedbackResponse.
        :type: str
        """
        

        self._id = id

    @property
    def document_variation(self) -> 'EntityReference':
        """
        Gets the document_variation of this KnowledgeDocumentFeedbackResponse.
        The variation of the document on which feedback was given.

        :return: The document_variation of this KnowledgeDocumentFeedbackResponse.
        :rtype: EntityReference
        """
        return self._document_variation

    @document_variation.setter
    def document_variation(self, document_variation: 'EntityReference') -> None:
        """
        Sets the document_variation of this KnowledgeDocumentFeedbackResponse.
        The variation of the document on which feedback was given.

        :param document_variation: The document_variation of this KnowledgeDocumentFeedbackResponse.
        :type: EntityReference
        """
        

        self._document_variation = document_variation

    @property
    def rating(self) -> str:
        """
        Gets the rating of this KnowledgeDocumentFeedbackResponse.
        Feedback rating.

        :return: The rating of this KnowledgeDocumentFeedbackResponse.
        :rtype: str
        """
        return self._rating

    @rating.setter
    def rating(self, rating: str) -> None:
        """
        Sets the rating of this KnowledgeDocumentFeedbackResponse.
        Feedback rating.

        :param rating: The rating of this KnowledgeDocumentFeedbackResponse.
        :type: str
        """
        if isinstance(rating, int):
            rating = str(rating)
        allowed_values = ["Negative", "Positive"]
        if rating.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for rating -> " + rating)
            self._rating = "outdated_sdk_version"
        else:
            self._rating = rating

    @property
    def reason(self) -> str:
        """
        Gets the reason of this KnowledgeDocumentFeedbackResponse.
        Feedback reason.

        :return: The reason of this KnowledgeDocumentFeedbackResponse.
        :rtype: str
        """
        return self._reason

    @reason.setter
    def reason(self, reason: str) -> None:
        """
        Sets the reason of this KnowledgeDocumentFeedbackResponse.
        Feedback reason.

        :param reason: The reason of this KnowledgeDocumentFeedbackResponse.
        :type: str
        """
        if isinstance(reason, int):
            reason = str(reason)
        allowed_values = ["DocumentContent", "SearchResults"]
        if reason.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for reason -> " + reason)
            self._reason = "outdated_sdk_version"
        else:
            self._reason = reason

    @property
    def comment(self) -> str:
        """
        Gets the comment of this KnowledgeDocumentFeedbackResponse.
        Free-text comment of the feedback. Maximum length: 2000 characters.

        :return: The comment of this KnowledgeDocumentFeedbackResponse.
        :rtype: str
        """
        return self._comment

    @comment.setter
    def comment(self, comment: str) -> None:
        """
        Sets the comment of this KnowledgeDocumentFeedbackResponse.
        Free-text comment of the feedback. Maximum length: 2000 characters.

        :param comment: The comment of this KnowledgeDocumentFeedbackResponse.
        :type: str
        """
        
        if len(comment) > 2000:
            raise ValueError("Invalid value for `comment`, length must be less than `2000`")

        if len(comment) < 0:
            raise ValueError("Invalid value for `comment`, length must be greater than or equal to `0`")


        self._comment = comment

    @property
    def search(self) -> 'EntityReference':
        """
        Gets the search of this KnowledgeDocumentFeedbackResponse.
        The search that surfaced the document on which feedback was given.

        :return: The search of this KnowledgeDocumentFeedbackResponse.
        :rtype: EntityReference
        """
        return self._search

    @search.setter
    def search(self, search: 'EntityReference') -> None:
        """
        Sets the search of this KnowledgeDocumentFeedbackResponse.
        The search that surfaced the document on which feedback was given.

        :param search: The search of this KnowledgeDocumentFeedbackResponse.
        :type: EntityReference
        """
        

        self._search = search

    @property
    def session_id(self) -> str:
        """
        Gets the session_id of this KnowledgeDocumentFeedbackResponse.
        Knowledge guest session ID.

        :return: The session_id of this KnowledgeDocumentFeedbackResponse.
        :rtype: str
        """
        return self._session_id

    @session_id.setter
    def session_id(self, session_id: str) -> None:
        """
        Sets the session_id of this KnowledgeDocumentFeedbackResponse.
        Knowledge guest session ID.

        :param session_id: The session_id of this KnowledgeDocumentFeedbackResponse.
        :type: str
        """
        

        self._session_id = session_id

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this KnowledgeDocumentFeedbackResponse.
        The date and time of the feedback. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this KnowledgeDocumentFeedbackResponse.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this KnowledgeDocumentFeedbackResponse.
        The date and time of the feedback. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this KnowledgeDocumentFeedbackResponse.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def query_type(self) -> str:
        """
        Gets the query_type of this KnowledgeDocumentFeedbackResponse.
        The type of the query that surfaced the document on which the feedback was given.

        :return: The query_type of this KnowledgeDocumentFeedbackResponse.
        :rtype: str
        """
        return self._query_type

    @query_type.setter
    def query_type(self, query_type: str) -> None:
        """
        Sets the query_type of this KnowledgeDocumentFeedbackResponse.
        The type of the query that surfaced the document on which the feedback was given.

        :param query_type: The query_type of this KnowledgeDocumentFeedbackResponse.
        :type: str
        """
        if isinstance(query_type, int):
            query_type = str(query_type)
        allowed_values = ["Unknown", "Article", "AutoSearch", "Category", "ManualSearch", "Recommendation", "Suggestion"]
        if query_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for query_type -> " + query_type)
            self._query_type = "outdated_sdk_version"
        else:
            self._query_type = query_type

    @property
    def surfacing_method(self) -> str:
        """
        Gets the surfacing_method of this KnowledgeDocumentFeedbackResponse.
        The method how knowledge was surfaced. Article: Full article was shown. Snippet: A snippet from the article was shown. Highlight: A highlighted answer in a snippet was shown.

        :return: The surfacing_method of this KnowledgeDocumentFeedbackResponse.
        :rtype: str
        """
        return self._surfacing_method

    @surfacing_method.setter
    def surfacing_method(self, surfacing_method: str) -> None:
        """
        Sets the surfacing_method of this KnowledgeDocumentFeedbackResponse.
        The method how knowledge was surfaced. Article: Full article was shown. Snippet: A snippet from the article was shown. Highlight: A highlighted answer in a snippet was shown.

        :param surfacing_method: The surfacing_method of this KnowledgeDocumentFeedbackResponse.
        :type: str
        """
        if isinstance(surfacing_method, int):
            surfacing_method = str(surfacing_method)
        allowed_values = ["Unknown", "Article", "Snippet", "Highlight"]
        if surfacing_method.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for surfacing_method -> " + surfacing_method)
            self._surfacing_method = "outdated_sdk_version"
        else:
            self._surfacing_method = surfacing_method

    @property
    def state(self) -> str:
        """
        Gets the state of this KnowledgeDocumentFeedbackResponse.
        The state of the feedback.

        :return: The state of this KnowledgeDocumentFeedbackResponse.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this KnowledgeDocumentFeedbackResponse.
        The state of the feedback.

        :param state: The state of this KnowledgeDocumentFeedbackResponse.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["Draft", "Final"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def document(self) -> 'KnowledgeDocumentVersionReference':
        """
        Gets the document of this KnowledgeDocumentFeedbackResponse.
        The document on which feedback was given.

        :return: The document of this KnowledgeDocumentFeedbackResponse.
        :rtype: KnowledgeDocumentVersionReference
        """
        return self._document

    @document.setter
    def document(self, document: 'KnowledgeDocumentVersionReference') -> None:
        """
        Sets the document of this KnowledgeDocumentFeedbackResponse.
        The document on which feedback was given.

        :param document: The document of this KnowledgeDocumentFeedbackResponse.
        :type: KnowledgeDocumentVersionReference
        """
        

        self._document = document

    @property
    def application(self) -> 'KnowledgeSearchClientApplication':
        """
        Gets the application of this KnowledgeDocumentFeedbackResponse.
        The client application from which feedback was given.

        :return: The application of this KnowledgeDocumentFeedbackResponse.
        :rtype: KnowledgeSearchClientApplication
        """
        return self._application

    @application.setter
    def application(self, application: 'KnowledgeSearchClientApplication') -> None:
        """
        Sets the application of this KnowledgeDocumentFeedbackResponse.
        The client application from which feedback was given.

        :param application: The application of this KnowledgeDocumentFeedbackResponse.
        :type: KnowledgeSearchClientApplication
        """
        

        self._application = application

    @property
    def conversation_context(self) -> 'KnowledgeConversationContextResponse':
        """
        Gets the conversation_context of this KnowledgeDocumentFeedbackResponse.
        Conversation context information if the feedback is given in the context of a conversation.

        :return: The conversation_context of this KnowledgeDocumentFeedbackResponse.
        :rtype: KnowledgeConversationContextResponse
        """
        return self._conversation_context

    @conversation_context.setter
    def conversation_context(self, conversation_context: 'KnowledgeConversationContextResponse') -> None:
        """
        Sets the conversation_context of this KnowledgeDocumentFeedbackResponse.
        Conversation context information if the feedback is given in the context of a conversation.

        :param conversation_context: The conversation_context of this KnowledgeDocumentFeedbackResponse.
        :type: KnowledgeConversationContextResponse
        """
        

        self._conversation_context = conversation_context

    @property
    def user(self) -> 'AddressableEntityRef':
        """
        Gets the user of this KnowledgeDocumentFeedbackResponse.
        The user who created the feedback.

        :return: The user of this KnowledgeDocumentFeedbackResponse.
        :rtype: AddressableEntityRef
        """
        return self._user

    @user.setter
    def user(self, user: 'AddressableEntityRef') -> None:
        """
        Sets the user of this KnowledgeDocumentFeedbackResponse.
        The user who created the feedback.

        :param user: The user of this KnowledgeDocumentFeedbackResponse.
        :type: AddressableEntityRef
        """
        

        self._user = user

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this KnowledgeDocumentFeedbackResponse.
        The URI for this object

        :return: The self_uri of this KnowledgeDocumentFeedbackResponse.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this KnowledgeDocumentFeedbackResponse.
        The URI for this object

        :param self_uri: The self_uri of this KnowledgeDocumentFeedbackResponse.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

