# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import KnowledgeDocumentAlternative

class KnowledgeDocumentCreateRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        KnowledgeDocumentCreateRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'title': 'str',
            'visible': 'bool',
            'alternatives': 'list[KnowledgeDocumentAlternative]',
            'category_id': 'str',
            'label_ids': 'list[str]',
            'external_id': 'str',
            'external_url': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'title': 'title',
            'visible': 'visible',
            'alternatives': 'alternatives',
            'category_id': 'categoryId',
            'label_ids': 'labelIds',
            'external_id': 'externalId',
            'external_url': 'externalUrl',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._title = None
        self._visible = None
        self._alternatives = None
        self._category_id = None
        self._label_ids = None
        self._external_id = None
        self._external_url = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this KnowledgeDocumentCreateRequest.
        The globally unique identifier for the object.

        :return: The id of this KnowledgeDocumentCreateRequest.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this KnowledgeDocumentCreateRequest.
        The globally unique identifier for the object.

        :param id: The id of this KnowledgeDocumentCreateRequest.
        :type: str
        """
        

        self._id = id

    @property
    def title(self) -> str:
        """
        Gets the title of this KnowledgeDocumentCreateRequest.
        Document title.

        :return: The title of this KnowledgeDocumentCreateRequest.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title: str) -> None:
        """
        Sets the title of this KnowledgeDocumentCreateRequest.
        Document title.

        :param title: The title of this KnowledgeDocumentCreateRequest.
        :type: str
        """
        

        self._title = title

    @property
    def visible(self) -> bool:
        """
        Gets the visible of this KnowledgeDocumentCreateRequest.
        Indicates if the knowledge document should be included in search results.

        :return: The visible of this KnowledgeDocumentCreateRequest.
        :rtype: bool
        """
        return self._visible

    @visible.setter
    def visible(self, visible: bool) -> None:
        """
        Sets the visible of this KnowledgeDocumentCreateRequest.
        Indicates if the knowledge document should be included in search results.

        :param visible: The visible of this KnowledgeDocumentCreateRequest.
        :type: bool
        """
        

        self._visible = visible

    @property
    def alternatives(self) -> List['KnowledgeDocumentAlternative']:
        """
        Gets the alternatives of this KnowledgeDocumentCreateRequest.
        List of alternate phrases related to the title which improves search results.

        :return: The alternatives of this KnowledgeDocumentCreateRequest.
        :rtype: list[KnowledgeDocumentAlternative]
        """
        return self._alternatives

    @alternatives.setter
    def alternatives(self, alternatives: List['KnowledgeDocumentAlternative']) -> None:
        """
        Sets the alternatives of this KnowledgeDocumentCreateRequest.
        List of alternate phrases related to the title which improves search results.

        :param alternatives: The alternatives of this KnowledgeDocumentCreateRequest.
        :type: list[KnowledgeDocumentAlternative]
        """
        

        self._alternatives = alternatives

    @property
    def category_id(self) -> str:
        """
        Gets the category_id of this KnowledgeDocumentCreateRequest.
        The category associated with the document.

        :return: The category_id of this KnowledgeDocumentCreateRequest.
        :rtype: str
        """
        return self._category_id

    @category_id.setter
    def category_id(self, category_id: str) -> None:
        """
        Sets the category_id of this KnowledgeDocumentCreateRequest.
        The category associated with the document.

        :param category_id: The category_id of this KnowledgeDocumentCreateRequest.
        :type: str
        """
        

        self._category_id = category_id

    @property
    def label_ids(self) -> List[str]:
        """
        Gets the label_ids of this KnowledgeDocumentCreateRequest.
        The ids of labels associated with the document.

        :return: The label_ids of this KnowledgeDocumentCreateRequest.
        :rtype: list[str]
        """
        return self._label_ids

    @label_ids.setter
    def label_ids(self, label_ids: List[str]) -> None:
        """
        Sets the label_ids of this KnowledgeDocumentCreateRequest.
        The ids of labels associated with the document.

        :param label_ids: The label_ids of this KnowledgeDocumentCreateRequest.
        :type: list[str]
        """
        

        self._label_ids = label_ids

    @property
    def external_id(self) -> str:
        """
        Gets the external_id of this KnowledgeDocumentCreateRequest.
        The external id associated with the document.

        :return: The external_id of this KnowledgeDocumentCreateRequest.
        :rtype: str
        """
        return self._external_id

    @external_id.setter
    def external_id(self, external_id: str) -> None:
        """
        Sets the external_id of this KnowledgeDocumentCreateRequest.
        The external id associated with the document.

        :param external_id: The external_id of this KnowledgeDocumentCreateRequest.
        :type: str
        """
        

        self._external_id = external_id

    @property
    def external_url(self) -> str:
        """
        Gets the external_url of this KnowledgeDocumentCreateRequest.
        The URL to external document.

        :return: The external_url of this KnowledgeDocumentCreateRequest.
        :rtype: str
        """
        return self._external_url

    @external_url.setter
    def external_url(self, external_url: str) -> None:
        """
        Sets the external_url of this KnowledgeDocumentCreateRequest.
        The URL to external document.

        :param external_url: The external_url of this KnowledgeDocumentCreateRequest.
        :type: str
        """
        

        self._external_url = external_url

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this KnowledgeDocumentCreateRequest.
        The URI for this object

        :return: The self_uri of this KnowledgeDocumentCreateRequest.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this KnowledgeDocumentCreateRequest.
        The URI for this object

        :param self_uri: The self_uri of this KnowledgeDocumentCreateRequest.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

