# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import JourneyViewElementFilterRangeData

class JourneyViewElementFilterRange(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        JourneyViewElementFilterRange - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'lt': 'JourneyViewElementFilterRangeData',
            'lte': 'JourneyViewElementFilterRangeData',
            'gt': 'JourneyViewElementFilterRangeData',
            'gte': 'JourneyViewElementFilterRangeData',
            'eq': 'JourneyViewElementFilterRangeData',
            'neq': 'JourneyViewElementFilterRangeData'
        }

        self.attribute_map = {
            'lt': 'lt',
            'lte': 'lte',
            'gt': 'gt',
            'gte': 'gte',
            'eq': 'eq',
            'neq': 'neq'
        }

        self._lt = None
        self._lte = None
        self._gt = None
        self._gte = None
        self._eq = None
        self._neq = None

    @property
    def lt(self) -> 'JourneyViewElementFilterRangeData':
        """
        Gets the lt of this JourneyViewElementFilterRange.
        comparator: less than

        :return: The lt of this JourneyViewElementFilterRange.
        :rtype: JourneyViewElementFilterRangeData
        """
        return self._lt

    @lt.setter
    def lt(self, lt: 'JourneyViewElementFilterRangeData') -> None:
        """
        Sets the lt of this JourneyViewElementFilterRange.
        comparator: less than

        :param lt: The lt of this JourneyViewElementFilterRange.
        :type: JourneyViewElementFilterRangeData
        """
        

        self._lt = lt

    @property
    def lte(self) -> 'JourneyViewElementFilterRangeData':
        """
        Gets the lte of this JourneyViewElementFilterRange.
        comparator: less than or equal

        :return: The lte of this JourneyViewElementFilterRange.
        :rtype: JourneyViewElementFilterRangeData
        """
        return self._lte

    @lte.setter
    def lte(self, lte: 'JourneyViewElementFilterRangeData') -> None:
        """
        Sets the lte of this JourneyViewElementFilterRange.
        comparator: less than or equal

        :param lte: The lte of this JourneyViewElementFilterRange.
        :type: JourneyViewElementFilterRangeData
        """
        

        self._lte = lte

    @property
    def gt(self) -> 'JourneyViewElementFilterRangeData':
        """
        Gets the gt of this JourneyViewElementFilterRange.
        comparator: greater than

        :return: The gt of this JourneyViewElementFilterRange.
        :rtype: JourneyViewElementFilterRangeData
        """
        return self._gt

    @gt.setter
    def gt(self, gt: 'JourneyViewElementFilterRangeData') -> None:
        """
        Sets the gt of this JourneyViewElementFilterRange.
        comparator: greater than

        :param gt: The gt of this JourneyViewElementFilterRange.
        :type: JourneyViewElementFilterRangeData
        """
        

        self._gt = gt

    @property
    def gte(self) -> 'JourneyViewElementFilterRangeData':
        """
        Gets the gte of this JourneyViewElementFilterRange.
        comparator: greater than or equal

        :return: The gte of this JourneyViewElementFilterRange.
        :rtype: JourneyViewElementFilterRangeData
        """
        return self._gte

    @gte.setter
    def gte(self, gte: 'JourneyViewElementFilterRangeData') -> None:
        """
        Sets the gte of this JourneyViewElementFilterRange.
        comparator: greater than or equal

        :param gte: The gte of this JourneyViewElementFilterRange.
        :type: JourneyViewElementFilterRangeData
        """
        

        self._gte = gte

    @property
    def eq(self) -> 'JourneyViewElementFilterRangeData':
        """
        Gets the eq of this JourneyViewElementFilterRange.
        comparator: is equal to

        :return: The eq of this JourneyViewElementFilterRange.
        :rtype: JourneyViewElementFilterRangeData
        """
        return self._eq

    @eq.setter
    def eq(self, eq: 'JourneyViewElementFilterRangeData') -> None:
        """
        Sets the eq of this JourneyViewElementFilterRange.
        comparator: is equal to

        :param eq: The eq of this JourneyViewElementFilterRange.
        :type: JourneyViewElementFilterRangeData
        """
        

        self._eq = eq

    @property
    def neq(self) -> 'JourneyViewElementFilterRangeData':
        """
        Gets the neq of this JourneyViewElementFilterRange.
        comparator: is not equal to

        :return: The neq of this JourneyViewElementFilterRange.
        :rtype: JourneyViewElementFilterRangeData
        """
        return self._neq

    @neq.setter
    def neq(self, neq: 'JourneyViewElementFilterRangeData') -> None:
        """
        Sets the neq of this JourneyViewElementFilterRange.
        comparator: is not equal to

        :param neq: The neq of this JourneyViewElementFilterRange.
        :type: JourneyViewElementFilterRangeData
        """
        

        self._neq = neq

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

