# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class JourneyViewChartMetric(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        JourneyViewChartMetric - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'element_id': 'str',
            'aggregate': 'str',
            'display_label': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'element_id': 'elementId',
            'aggregate': 'aggregate',
            'display_label': 'displayLabel'
        }

        self._id = None
        self._element_id = None
        self._aggregate = None
        self._display_label = None

    @property
    def id(self) -> str:
        """
        Gets the id of this JourneyViewChartMetric.
        The unique identifier of the metric within the chart

        :return: The id of this JourneyViewChartMetric.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this JourneyViewChartMetric.
        The unique identifier of the metric within the chart

        :param id: The id of this JourneyViewChartMetric.
        :type: str
        """
        

        self._id = id

    @property
    def element_id(self) -> str:
        """
        Gets the element_id of this JourneyViewChartMetric.
        The element in the list of elements which the metric is measuring

        :return: The element_id of this JourneyViewChartMetric.
        :rtype: str
        """
        return self._element_id

    @element_id.setter
    def element_id(self, element_id: str) -> None:
        """
        Sets the element_id of this JourneyViewChartMetric.
        The element in the list of elements which the metric is measuring

        :param element_id: The element_id of this JourneyViewChartMetric.
        :type: str
        """
        

        self._element_id = element_id

    @property
    def aggregate(self) -> str:
        """
        Gets the aggregate of this JourneyViewChartMetric.
        How to aggregate the given element, defaults to CustomerCount

        :return: The aggregate of this JourneyViewChartMetric.
        :rtype: str
        """
        return self._aggregate

    @aggregate.setter
    def aggregate(self, aggregate: str) -> None:
        """
        Sets the aggregate of this JourneyViewChartMetric.
        How to aggregate the given element, defaults to CustomerCount

        :param aggregate: The aggregate of this JourneyViewChartMetric.
        :type: str
        """
        if isinstance(aggregate, int):
            aggregate = str(aggregate)
        allowed_values = ["EventCount", "CustomerCount"]
        if aggregate.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for aggregate -> " + aggregate)
            self._aggregate = "outdated_sdk_version"
        else:
            self._aggregate = aggregate

    @property
    def display_label(self) -> str:
        """
        Gets the display_label of this JourneyViewChartMetric.
        A display label for the metric

        :return: The display_label of this JourneyViewChartMetric.
        :rtype: str
        """
        return self._display_label

    @display_label.setter
    def display_label(self, display_label: str) -> None:
        """
        Sets the display_label of this JourneyViewChartMetric.
        A display label for the metric

        :param display_label: The display_label of this JourneyViewChartMetric.
        :type: str
        """
        

        self._display_label = display_label

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

