# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import JourneyAppEventsNotificationActionMap
    from . import JourneyAppEventsNotificationActionTarget
    from . import JourneyAppEventsNotificationBrowser
    from . import JourneyAppEventsNotificationDevice
    from . import JourneyAppEventsNotificationEventAction
    from . import JourneyAppEventsNotificationGeoLocation
    from . import JourneyAppEventsNotificationMktCampaign
    from . import JourneyAppEventsNotificationReferrer

class JourneyAppEventsNotificationWebActionMessage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        JourneyAppEventsNotificationWebActionMessage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'action': 'JourneyAppEventsNotificationEventAction',
            'action_target': 'JourneyAppEventsNotificationActionTarget',
            'action_map': 'JourneyAppEventsNotificationActionMap',
            'error_code': 'str',
            'error_message': 'str',
            'user_agent_string': 'str',
            'ip_address': 'str',
            'ip_organization': 'str',
            'browser': 'JourneyAppEventsNotificationBrowser',
            'device': 'JourneyAppEventsNotificationDevice',
            'geolocation': 'JourneyAppEventsNotificationGeoLocation',
            'mkt_campaign': 'JourneyAppEventsNotificationMktCampaign',
            'visit_referrer': 'JourneyAppEventsNotificationReferrer',
            'time_to_disposition': 'int'
        }

        self.attribute_map = {
            'action': 'action',
            'action_target': 'actionTarget',
            'action_map': 'actionMap',
            'error_code': 'errorCode',
            'error_message': 'errorMessage',
            'user_agent_string': 'userAgentString',
            'ip_address': 'ipAddress',
            'ip_organization': 'ipOrganization',
            'browser': 'browser',
            'device': 'device',
            'geolocation': 'geolocation',
            'mkt_campaign': 'mktCampaign',
            'visit_referrer': 'visitReferrer',
            'time_to_disposition': 'timeToDisposition'
        }

        self._action = None
        self._action_target = None
        self._action_map = None
        self._error_code = None
        self._error_message = None
        self._user_agent_string = None
        self._ip_address = None
        self._ip_organization = None
        self._browser = None
        self._device = None
        self._geolocation = None
        self._mkt_campaign = None
        self._visit_referrer = None
        self._time_to_disposition = None

    @property
    def action(self) -> 'JourneyAppEventsNotificationEventAction':
        """
        Gets the action of this JourneyAppEventsNotificationWebActionMessage.


        :return: The action of this JourneyAppEventsNotificationWebActionMessage.
        :rtype: JourneyAppEventsNotificationEventAction
        """
        return self._action

    @action.setter
    def action(self, action: 'JourneyAppEventsNotificationEventAction') -> None:
        """
        Sets the action of this JourneyAppEventsNotificationWebActionMessage.


        :param action: The action of this JourneyAppEventsNotificationWebActionMessage.
        :type: JourneyAppEventsNotificationEventAction
        """
        

        self._action = action

    @property
    def action_target(self) -> 'JourneyAppEventsNotificationActionTarget':
        """
        Gets the action_target of this JourneyAppEventsNotificationWebActionMessage.


        :return: The action_target of this JourneyAppEventsNotificationWebActionMessage.
        :rtype: JourneyAppEventsNotificationActionTarget
        """
        return self._action_target

    @action_target.setter
    def action_target(self, action_target: 'JourneyAppEventsNotificationActionTarget') -> None:
        """
        Sets the action_target of this JourneyAppEventsNotificationWebActionMessage.


        :param action_target: The action_target of this JourneyAppEventsNotificationWebActionMessage.
        :type: JourneyAppEventsNotificationActionTarget
        """
        

        self._action_target = action_target

    @property
    def action_map(self) -> 'JourneyAppEventsNotificationActionMap':
        """
        Gets the action_map of this JourneyAppEventsNotificationWebActionMessage.


        :return: The action_map of this JourneyAppEventsNotificationWebActionMessage.
        :rtype: JourneyAppEventsNotificationActionMap
        """
        return self._action_map

    @action_map.setter
    def action_map(self, action_map: 'JourneyAppEventsNotificationActionMap') -> None:
        """
        Sets the action_map of this JourneyAppEventsNotificationWebActionMessage.


        :param action_map: The action_map of this JourneyAppEventsNotificationWebActionMessage.
        :type: JourneyAppEventsNotificationActionMap
        """
        

        self._action_map = action_map

    @property
    def error_code(self) -> str:
        """
        Gets the error_code of this JourneyAppEventsNotificationWebActionMessage.


        :return: The error_code of this JourneyAppEventsNotificationWebActionMessage.
        :rtype: str
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code: str) -> None:
        """
        Sets the error_code of this JourneyAppEventsNotificationWebActionMessage.


        :param error_code: The error_code of this JourneyAppEventsNotificationWebActionMessage.
        :type: str
        """
        

        self._error_code = error_code

    @property
    def error_message(self) -> str:
        """
        Gets the error_message of this JourneyAppEventsNotificationWebActionMessage.


        :return: The error_message of this JourneyAppEventsNotificationWebActionMessage.
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message: str) -> None:
        """
        Sets the error_message of this JourneyAppEventsNotificationWebActionMessage.


        :param error_message: The error_message of this JourneyAppEventsNotificationWebActionMessage.
        :type: str
        """
        

        self._error_message = error_message

    @property
    def user_agent_string(self) -> str:
        """
        Gets the user_agent_string of this JourneyAppEventsNotificationWebActionMessage.


        :return: The user_agent_string of this JourneyAppEventsNotificationWebActionMessage.
        :rtype: str
        """
        return self._user_agent_string

    @user_agent_string.setter
    def user_agent_string(self, user_agent_string: str) -> None:
        """
        Sets the user_agent_string of this JourneyAppEventsNotificationWebActionMessage.


        :param user_agent_string: The user_agent_string of this JourneyAppEventsNotificationWebActionMessage.
        :type: str
        """
        

        self._user_agent_string = user_agent_string

    @property
    def ip_address(self) -> str:
        """
        Gets the ip_address of this JourneyAppEventsNotificationWebActionMessage.


        :return: The ip_address of this JourneyAppEventsNotificationWebActionMessage.
        :rtype: str
        """
        return self._ip_address

    @ip_address.setter
    def ip_address(self, ip_address: str) -> None:
        """
        Sets the ip_address of this JourneyAppEventsNotificationWebActionMessage.


        :param ip_address: The ip_address of this JourneyAppEventsNotificationWebActionMessage.
        :type: str
        """
        

        self._ip_address = ip_address

    @property
    def ip_organization(self) -> str:
        """
        Gets the ip_organization of this JourneyAppEventsNotificationWebActionMessage.


        :return: The ip_organization of this JourneyAppEventsNotificationWebActionMessage.
        :rtype: str
        """
        return self._ip_organization

    @ip_organization.setter
    def ip_organization(self, ip_organization: str) -> None:
        """
        Sets the ip_organization of this JourneyAppEventsNotificationWebActionMessage.


        :param ip_organization: The ip_organization of this JourneyAppEventsNotificationWebActionMessage.
        :type: str
        """
        

        self._ip_organization = ip_organization

    @property
    def browser(self) -> 'JourneyAppEventsNotificationBrowser':
        """
        Gets the browser of this JourneyAppEventsNotificationWebActionMessage.


        :return: The browser of this JourneyAppEventsNotificationWebActionMessage.
        :rtype: JourneyAppEventsNotificationBrowser
        """
        return self._browser

    @browser.setter
    def browser(self, browser: 'JourneyAppEventsNotificationBrowser') -> None:
        """
        Sets the browser of this JourneyAppEventsNotificationWebActionMessage.


        :param browser: The browser of this JourneyAppEventsNotificationWebActionMessage.
        :type: JourneyAppEventsNotificationBrowser
        """
        

        self._browser = browser

    @property
    def device(self) -> 'JourneyAppEventsNotificationDevice':
        """
        Gets the device of this JourneyAppEventsNotificationWebActionMessage.


        :return: The device of this JourneyAppEventsNotificationWebActionMessage.
        :rtype: JourneyAppEventsNotificationDevice
        """
        return self._device

    @device.setter
    def device(self, device: 'JourneyAppEventsNotificationDevice') -> None:
        """
        Sets the device of this JourneyAppEventsNotificationWebActionMessage.


        :param device: The device of this JourneyAppEventsNotificationWebActionMessage.
        :type: JourneyAppEventsNotificationDevice
        """
        

        self._device = device

    @property
    def geolocation(self) -> 'JourneyAppEventsNotificationGeoLocation':
        """
        Gets the geolocation of this JourneyAppEventsNotificationWebActionMessage.


        :return: The geolocation of this JourneyAppEventsNotificationWebActionMessage.
        :rtype: JourneyAppEventsNotificationGeoLocation
        """
        return self._geolocation

    @geolocation.setter
    def geolocation(self, geolocation: 'JourneyAppEventsNotificationGeoLocation') -> None:
        """
        Sets the geolocation of this JourneyAppEventsNotificationWebActionMessage.


        :param geolocation: The geolocation of this JourneyAppEventsNotificationWebActionMessage.
        :type: JourneyAppEventsNotificationGeoLocation
        """
        

        self._geolocation = geolocation

    @property
    def mkt_campaign(self) -> 'JourneyAppEventsNotificationMktCampaign':
        """
        Gets the mkt_campaign of this JourneyAppEventsNotificationWebActionMessage.


        :return: The mkt_campaign of this JourneyAppEventsNotificationWebActionMessage.
        :rtype: JourneyAppEventsNotificationMktCampaign
        """
        return self._mkt_campaign

    @mkt_campaign.setter
    def mkt_campaign(self, mkt_campaign: 'JourneyAppEventsNotificationMktCampaign') -> None:
        """
        Sets the mkt_campaign of this JourneyAppEventsNotificationWebActionMessage.


        :param mkt_campaign: The mkt_campaign of this JourneyAppEventsNotificationWebActionMessage.
        :type: JourneyAppEventsNotificationMktCampaign
        """
        

        self._mkt_campaign = mkt_campaign

    @property
    def visit_referrer(self) -> 'JourneyAppEventsNotificationReferrer':
        """
        Gets the visit_referrer of this JourneyAppEventsNotificationWebActionMessage.


        :return: The visit_referrer of this JourneyAppEventsNotificationWebActionMessage.
        :rtype: JourneyAppEventsNotificationReferrer
        """
        return self._visit_referrer

    @visit_referrer.setter
    def visit_referrer(self, visit_referrer: 'JourneyAppEventsNotificationReferrer') -> None:
        """
        Sets the visit_referrer of this JourneyAppEventsNotificationWebActionMessage.


        :param visit_referrer: The visit_referrer of this JourneyAppEventsNotificationWebActionMessage.
        :type: JourneyAppEventsNotificationReferrer
        """
        

        self._visit_referrer = visit_referrer

    @property
    def time_to_disposition(self) -> int:
        """
        Gets the time_to_disposition of this JourneyAppEventsNotificationWebActionMessage.


        :return: The time_to_disposition of this JourneyAppEventsNotificationWebActionMessage.
        :rtype: int
        """
        return self._time_to_disposition

    @time_to_disposition.setter
    def time_to_disposition(self, time_to_disposition: int) -> None:
        """
        Sets the time_to_disposition of this JourneyAppEventsNotificationWebActionMessage.


        :param time_to_disposition: The time_to_disposition of this JourneyAppEventsNotificationWebActionMessage.
        :type: int
        """
        

        self._time_to_disposition = time_to_disposition

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

