# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import DivisionReference
    from . import InsightsSummaryUserItem
    from . import WorkdayPeriod

class InsightsSummary(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        InsightsSummary - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'entities': 'list[InsightsSummaryUserItem]',
            'page_size': 'int',
            'page_number': 'int',
            'total': 'int',
            'performance_profile': 'AddressableEntityRef',
            'division': 'DivisionReference',
            'granularity': 'str',
            'comparative_period': 'WorkdayPeriod',
            'primary_period': 'WorkdayPeriod',
            'page_count': 'int'
        }

        self.attribute_map = {
            'entities': 'entities',
            'page_size': 'pageSize',
            'page_number': 'pageNumber',
            'total': 'total',
            'performance_profile': 'performanceProfile',
            'division': 'division',
            'granularity': 'granularity',
            'comparative_period': 'comparativePeriod',
            'primary_period': 'primaryPeriod',
            'page_count': 'pageCount'
        }

        self._entities = None
        self._page_size = None
        self._page_number = None
        self._total = None
        self._performance_profile = None
        self._division = None
        self._granularity = None
        self._comparative_period = None
        self._primary_period = None
        self._page_count = None

    @property
    def entities(self) -> List['InsightsSummaryUserItem']:
        """
        Gets the entities of this InsightsSummary.


        :return: The entities of this InsightsSummary.
        :rtype: list[InsightsSummaryUserItem]
        """
        return self._entities

    @entities.setter
    def entities(self, entities: List['InsightsSummaryUserItem']) -> None:
        """
        Sets the entities of this InsightsSummary.


        :param entities: The entities of this InsightsSummary.
        :type: list[InsightsSummaryUserItem]
        """
        

        self._entities = entities

    @property
    def page_size(self) -> int:
        """
        Gets the page_size of this InsightsSummary.


        :return: The page_size of this InsightsSummary.
        :rtype: int
        """
        return self._page_size

    @page_size.setter
    def page_size(self, page_size: int) -> None:
        """
        Sets the page_size of this InsightsSummary.


        :param page_size: The page_size of this InsightsSummary.
        :type: int
        """
        

        self._page_size = page_size

    @property
    def page_number(self) -> int:
        """
        Gets the page_number of this InsightsSummary.


        :return: The page_number of this InsightsSummary.
        :rtype: int
        """
        return self._page_number

    @page_number.setter
    def page_number(self, page_number: int) -> None:
        """
        Sets the page_number of this InsightsSummary.


        :param page_number: The page_number of this InsightsSummary.
        :type: int
        """
        

        self._page_number = page_number

    @property
    def total(self) -> int:
        """
        Gets the total of this InsightsSummary.


        :return: The total of this InsightsSummary.
        :rtype: int
        """
        return self._total

    @total.setter
    def total(self, total: int) -> None:
        """
        Sets the total of this InsightsSummary.


        :param total: The total of this InsightsSummary.
        :type: int
        """
        

        self._total = total

    @property
    def performance_profile(self) -> 'AddressableEntityRef':
        """
        Gets the performance_profile of this InsightsSummary.
        The performance profile

        :return: The performance_profile of this InsightsSummary.
        :rtype: AddressableEntityRef
        """
        return self._performance_profile

    @performance_profile.setter
    def performance_profile(self, performance_profile: 'AddressableEntityRef') -> None:
        """
        Sets the performance_profile of this InsightsSummary.
        The performance profile

        :param performance_profile: The performance_profile of this InsightsSummary.
        :type: AddressableEntityRef
        """
        

        self._performance_profile = performance_profile

    @property
    def division(self) -> 'DivisionReference':
        """
        Gets the division of this InsightsSummary.
        The division

        :return: The division of this InsightsSummary.
        :rtype: DivisionReference
        """
        return self._division

    @division.setter
    def division(self, division: 'DivisionReference') -> None:
        """
        Sets the division of this InsightsSummary.
        The division

        :param division: The division of this InsightsSummary.
        :type: DivisionReference
        """
        

        self._division = division

    @property
    def granularity(self) -> str:
        """
        Gets the granularity of this InsightsSummary.
        Granularity

        :return: The granularity of this InsightsSummary.
        :rtype: str
        """
        return self._granularity

    @granularity.setter
    def granularity(self, granularity: str) -> None:
        """
        Sets the granularity of this InsightsSummary.
        Granularity

        :param granularity: The granularity of this InsightsSummary.
        :type: str
        """
        if isinstance(granularity, int):
            granularity = str(granularity)
        allowed_values = ["Daily", "Weekly", "Monthly"]
        if granularity.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for granularity -> " + granularity)
            self._granularity = "outdated_sdk_version"
        else:
            self._granularity = granularity

    @property
    def comparative_period(self) -> 'WorkdayPeriod':
        """
        Gets the comparative_period of this InsightsSummary.
        The comparative period work day date range

        :return: The comparative_period of this InsightsSummary.
        :rtype: WorkdayPeriod
        """
        return self._comparative_period

    @comparative_period.setter
    def comparative_period(self, comparative_period: 'WorkdayPeriod') -> None:
        """
        Sets the comparative_period of this InsightsSummary.
        The comparative period work day date range

        :param comparative_period: The comparative_period of this InsightsSummary.
        :type: WorkdayPeriod
        """
        

        self._comparative_period = comparative_period

    @property
    def primary_period(self) -> 'WorkdayPeriod':
        """
        Gets the primary_period of this InsightsSummary.
        The primary period work day date range

        :return: The primary_period of this InsightsSummary.
        :rtype: WorkdayPeriod
        """
        return self._primary_period

    @primary_period.setter
    def primary_period(self, primary_period: 'WorkdayPeriod') -> None:
        """
        Sets the primary_period of this InsightsSummary.
        The primary period work day date range

        :param primary_period: The primary_period of this InsightsSummary.
        :type: WorkdayPeriod
        """
        

        self._primary_period = primary_period

    @property
    def page_count(self) -> int:
        """
        Gets the page_count of this InsightsSummary.


        :return: The page_count of this InsightsSummary.
        :rtype: int
        """
        return self._page_count

    @page_count.setter
    def page_count(self, page_count: int) -> None:
        """
        Sets the page_count of this InsightsSummary.


        :param page_count: The page_count of this InsightsSummary.
        :type: int
        """
        

        self._page_count = page_count

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

