# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import DivisionReference
    from . import InsightsAgentItem

class InsightsAgents(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        InsightsAgents - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'performance_profile': 'AddressableEntityRef',
            'division': 'DivisionReference',
            'granularity': 'str',
            'date_start_workday': 'date',
            'date_end_workday': 'date',
            'entities': 'list[InsightsAgentItem]'
        }

        self.attribute_map = {
            'performance_profile': 'performanceProfile',
            'division': 'division',
            'granularity': 'granularity',
            'date_start_workday': 'dateStartWorkday',
            'date_end_workday': 'dateEndWorkday',
            'entities': 'entities'
        }

        self._performance_profile = None
        self._division = None
        self._granularity = None
        self._date_start_workday = None
        self._date_end_workday = None
        self._entities = None

    @property
    def performance_profile(self) -> 'AddressableEntityRef':
        """
        Gets the performance_profile of this InsightsAgents.
        The performance profile

        :return: The performance_profile of this InsightsAgents.
        :rtype: AddressableEntityRef
        """
        return self._performance_profile

    @performance_profile.setter
    def performance_profile(self, performance_profile: 'AddressableEntityRef') -> None:
        """
        Sets the performance_profile of this InsightsAgents.
        The performance profile

        :param performance_profile: The performance_profile of this InsightsAgents.
        :type: AddressableEntityRef
        """
        

        self._performance_profile = performance_profile

    @property
    def division(self) -> 'DivisionReference':
        """
        Gets the division of this InsightsAgents.
        The division

        :return: The division of this InsightsAgents.
        :rtype: DivisionReference
        """
        return self._division

    @division.setter
    def division(self, division: 'DivisionReference') -> None:
        """
        Sets the division of this InsightsAgents.
        The division

        :param division: The division of this InsightsAgents.
        :type: DivisionReference
        """
        

        self._division = division

    @property
    def granularity(self) -> str:
        """
        Gets the granularity of this InsightsAgents.
        Granularity

        :return: The granularity of this InsightsAgents.
        :rtype: str
        """
        return self._granularity

    @granularity.setter
    def granularity(self, granularity: str) -> None:
        """
        Sets the granularity of this InsightsAgents.
        Granularity

        :param granularity: The granularity of this InsightsAgents.
        :type: str
        """
        if isinstance(granularity, int):
            granularity = str(granularity)
        allowed_values = ["Daily", "Weekly", "Monthly"]
        if granularity.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for granularity -> " + granularity)
            self._granularity = "outdated_sdk_version"
        else:
            self._granularity = granularity

    @property
    def date_start_workday(self) -> date:
        """
        Gets the date_start_workday of this InsightsAgents.
        Start workday used as the date range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_start_workday of this InsightsAgents.
        :rtype: date
        """
        return self._date_start_workday

    @date_start_workday.setter
    def date_start_workday(self, date_start_workday: date) -> None:
        """
        Sets the date_start_workday of this InsightsAgents.
        Start workday used as the date range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_start_workday: The date_start_workday of this InsightsAgents.
        :type: date
        """
        

        self._date_start_workday = date_start_workday

    @property
    def date_end_workday(self) -> date:
        """
        Gets the date_end_workday of this InsightsAgents.
        End workday used as the date range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_end_workday of this InsightsAgents.
        :rtype: date
        """
        return self._date_end_workday

    @date_end_workday.setter
    def date_end_workday(self, date_end_workday: date) -> None:
        """
        Sets the date_end_workday of this InsightsAgents.
        End workday used as the date range. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_end_workday: The date_end_workday of this InsightsAgents.
        :type: date
        """
        

        self._date_end_workday = date_end_workday

    @property
    def entities(self) -> List['InsightsAgentItem']:
        """
        Gets the entities of this InsightsAgents.
        The list of insights agents

        :return: The entities of this InsightsAgents.
        :rtype: list[InsightsAgentItem]
        """
        return self._entities

    @entities.setter
    def entities(self, entities: List['InsightsAgentItem']) -> None:
        """
        Sets the entities of this InsightsAgents.
        The list of insights agents

        :param entities: The entities of this InsightsAgents.
        :type: list[InsightsAgentItem]
        """
        

        self._entities = entities

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

