# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import OperatorPosition

class InfixOperator(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        InfixOperator - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'operator_type': 'str',
            'operator_position': 'OperatorPosition'
        }

        self.attribute_map = {
            'operator_type': 'operatorType',
            'operator_position': 'operatorPosition'
        }

        self._operator_type = None
        self._operator_position = None

    @property
    def operator_type(self) -> str:
        """
        Gets the operator_type of this InfixOperator.
        The logical operation that is applied on the operand against the following operand

        :return: The operator_type of this InfixOperator.
        :rtype: str
        """
        return self._operator_type

    @operator_type.setter
    def operator_type(self, operator_type: str) -> None:
        """
        Sets the operator_type of this InfixOperator.
        The logical operation that is applied on the operand against the following operand

        :param operator_type: The operator_type of this InfixOperator.
        :type: str
        """
        if isinstance(operator_type, int):
            operator_type = str(operator_type)
        allowed_values = ["Or", "And", "Near"]
        if operator_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for operator_type -> " + operator_type)
            self._operator_type = "outdated_sdk_version"
        else:
            self._operator_type = operator_type

    @property
    def operator_position(self) -> 'OperatorPosition':
        """
        Gets the operator_position of this InfixOperator.
        Dictates when the following operand should occur relative to current operand

        :return: The operator_position of this InfixOperator.
        :rtype: OperatorPosition
        """
        return self._operator_position

    @operator_position.setter
    def operator_position(self, operator_position: 'OperatorPosition') -> None:
        """
        Sets the operator_position of this InfixOperator.
        Dictates when the following operand should occur relative to current operand

        :param operator_position: The operator_position of this InfixOperator.
        :type: OperatorPosition
        """
        

        self._operator_position = operator_position

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

