# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class IdentityNow(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        IdentityNow - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'disabled': 'bool',
            'issuer_uri': 'str',
            'sso_target_uri': 'str',
            'slo_uri': 'str',
            'slo_binding': 'str',
            'relying_party_identifier': 'str',
            'certificate': 'str',
            'certificates': 'list[str]',
            'logo_image_data': 'str',
            'name_identifier_format': 'str',
            'sso_binding': 'str',
            'sign_authn_requests': 'bool',
            'provider_name': 'str',
            'display_on_login': 'bool',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'disabled': 'disabled',
            'issuer_uri': 'issuerURI',
            'sso_target_uri': 'ssoTargetURI',
            'slo_uri': 'sloURI',
            'slo_binding': 'sloBinding',
            'relying_party_identifier': 'relyingPartyIdentifier',
            'certificate': 'certificate',
            'certificates': 'certificates',
            'logo_image_data': 'logoImageData',
            'name_identifier_format': 'nameIdentifierFormat',
            'sso_binding': 'ssoBinding',
            'sign_authn_requests': 'signAuthnRequests',
            'provider_name': 'providerName',
            'display_on_login': 'displayOnLogin',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._disabled = None
        self._issuer_uri = None
        self._sso_target_uri = None
        self._slo_uri = None
        self._slo_binding = None
        self._relying_party_identifier = None
        self._certificate = None
        self._certificates = None
        self._logo_image_data = None
        self._name_identifier_format = None
        self._sso_binding = None
        self._sign_authn_requests = None
        self._provider_name = None
        self._display_on_login = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this IdentityNow.
        The globally unique identifier for the object.

        :return: The id of this IdentityNow.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this IdentityNow.
        The globally unique identifier for the object.

        :param id: The id of this IdentityNow.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this IdentityNow.


        :return: The name of this IdentityNow.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this IdentityNow.


        :param name: The name of this IdentityNow.
        :type: str
        """
        

        self._name = name

    @property
    def disabled(self) -> bool:
        """
        Gets the disabled of this IdentityNow.


        :return: The disabled of this IdentityNow.
        :rtype: bool
        """
        return self._disabled

    @disabled.setter
    def disabled(self, disabled: bool) -> None:
        """
        Sets the disabled of this IdentityNow.


        :param disabled: The disabled of this IdentityNow.
        :type: bool
        """
        

        self._disabled = disabled

    @property
    def issuer_uri(self) -> str:
        """
        Gets the issuer_uri of this IdentityNow.


        :return: The issuer_uri of this IdentityNow.
        :rtype: str
        """
        return self._issuer_uri

    @issuer_uri.setter
    def issuer_uri(self, issuer_uri: str) -> None:
        """
        Sets the issuer_uri of this IdentityNow.


        :param issuer_uri: The issuer_uri of this IdentityNow.
        :type: str
        """
        

        self._issuer_uri = issuer_uri

    @property
    def sso_target_uri(self) -> str:
        """
        Gets the sso_target_uri of this IdentityNow.


        :return: The sso_target_uri of this IdentityNow.
        :rtype: str
        """
        return self._sso_target_uri

    @sso_target_uri.setter
    def sso_target_uri(self, sso_target_uri: str) -> None:
        """
        Sets the sso_target_uri of this IdentityNow.


        :param sso_target_uri: The sso_target_uri of this IdentityNow.
        :type: str
        """
        

        self._sso_target_uri = sso_target_uri

    @property
    def slo_uri(self) -> str:
        """
        Gets the slo_uri of this IdentityNow.


        :return: The slo_uri of this IdentityNow.
        :rtype: str
        """
        return self._slo_uri

    @slo_uri.setter
    def slo_uri(self, slo_uri: str) -> None:
        """
        Sets the slo_uri of this IdentityNow.


        :param slo_uri: The slo_uri of this IdentityNow.
        :type: str
        """
        

        self._slo_uri = slo_uri

    @property
    def slo_binding(self) -> str:
        """
        Gets the slo_binding of this IdentityNow.


        :return: The slo_binding of this IdentityNow.
        :rtype: str
        """
        return self._slo_binding

    @slo_binding.setter
    def slo_binding(self, slo_binding: str) -> None:
        """
        Sets the slo_binding of this IdentityNow.


        :param slo_binding: The slo_binding of this IdentityNow.
        :type: str
        """
        

        self._slo_binding = slo_binding

    @property
    def relying_party_identifier(self) -> str:
        """
        Gets the relying_party_identifier of this IdentityNow.


        :return: The relying_party_identifier of this IdentityNow.
        :rtype: str
        """
        return self._relying_party_identifier

    @relying_party_identifier.setter
    def relying_party_identifier(self, relying_party_identifier: str) -> None:
        """
        Sets the relying_party_identifier of this IdentityNow.


        :param relying_party_identifier: The relying_party_identifier of this IdentityNow.
        :type: str
        """
        

        self._relying_party_identifier = relying_party_identifier

    @property
    def certificate(self) -> str:
        """
        Gets the certificate of this IdentityNow.


        :return: The certificate of this IdentityNow.
        :rtype: str
        """
        return self._certificate

    @certificate.setter
    def certificate(self, certificate: str) -> None:
        """
        Sets the certificate of this IdentityNow.


        :param certificate: The certificate of this IdentityNow.
        :type: str
        """
        

        self._certificate = certificate

    @property
    def certificates(self) -> List[str]:
        """
        Gets the certificates of this IdentityNow.


        :return: The certificates of this IdentityNow.
        :rtype: list[str]
        """
        return self._certificates

    @certificates.setter
    def certificates(self, certificates: List[str]) -> None:
        """
        Sets the certificates of this IdentityNow.


        :param certificates: The certificates of this IdentityNow.
        :type: list[str]
        """
        

        self._certificates = certificates

    @property
    def logo_image_data(self) -> str:
        """
        Gets the logo_image_data of this IdentityNow.


        :return: The logo_image_data of this IdentityNow.
        :rtype: str
        """
        return self._logo_image_data

    @logo_image_data.setter
    def logo_image_data(self, logo_image_data: str) -> None:
        """
        Sets the logo_image_data of this IdentityNow.


        :param logo_image_data: The logo_image_data of this IdentityNow.
        :type: str
        """
        

        self._logo_image_data = logo_image_data

    @property
    def name_identifier_format(self) -> str:
        """
        Gets the name_identifier_format of this IdentityNow.


        :return: The name_identifier_format of this IdentityNow.
        :rtype: str
        """
        return self._name_identifier_format

    @name_identifier_format.setter
    def name_identifier_format(self, name_identifier_format: str) -> None:
        """
        Sets the name_identifier_format of this IdentityNow.


        :param name_identifier_format: The name_identifier_format of this IdentityNow.
        :type: str
        """
        if isinstance(name_identifier_format, int):
            name_identifier_format = str(name_identifier_format)
        allowed_values = ["urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName", "urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName", "urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos", "urn:oasis:names:tc:SAML:2.0:nameid-format:entity", "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent", "urn:oasis:names:tc:SAML:2.0:nameid-format:transient"]
        if name_identifier_format.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for name_identifier_format -> " + name_identifier_format)
            self._name_identifier_format = "outdated_sdk_version"
        else:
            self._name_identifier_format = name_identifier_format

    @property
    def sso_binding(self) -> str:
        """
        Gets the sso_binding of this IdentityNow.


        :return: The sso_binding of this IdentityNow.
        :rtype: str
        """
        return self._sso_binding

    @sso_binding.setter
    def sso_binding(self, sso_binding: str) -> None:
        """
        Sets the sso_binding of this IdentityNow.


        :param sso_binding: The sso_binding of this IdentityNow.
        :type: str
        """
        if isinstance(sso_binding, int):
            sso_binding = str(sso_binding)
        allowed_values = ["urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect"]
        if sso_binding.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for sso_binding -> " + sso_binding)
            self._sso_binding = "outdated_sdk_version"
        else:
            self._sso_binding = sso_binding

    @property
    def sign_authn_requests(self) -> bool:
        """
        Gets the sign_authn_requests of this IdentityNow.


        :return: The sign_authn_requests of this IdentityNow.
        :rtype: bool
        """
        return self._sign_authn_requests

    @sign_authn_requests.setter
    def sign_authn_requests(self, sign_authn_requests: bool) -> None:
        """
        Sets the sign_authn_requests of this IdentityNow.


        :param sign_authn_requests: The sign_authn_requests of this IdentityNow.
        :type: bool
        """
        

        self._sign_authn_requests = sign_authn_requests

    @property
    def provider_name(self) -> str:
        """
        Gets the provider_name of this IdentityNow.


        :return: The provider_name of this IdentityNow.
        :rtype: str
        """
        return self._provider_name

    @provider_name.setter
    def provider_name(self, provider_name: str) -> None:
        """
        Sets the provider_name of this IdentityNow.


        :param provider_name: The provider_name of this IdentityNow.
        :type: str
        """
        

        self._provider_name = provider_name

    @property
    def display_on_login(self) -> bool:
        """
        Gets the display_on_login of this IdentityNow.


        :return: The display_on_login of this IdentityNow.
        :rtype: bool
        """
        return self._display_on_login

    @display_on_login.setter
    def display_on_login(self, display_on_login: bool) -> None:
        """
        Sets the display_on_login of this IdentityNow.


        :param display_on_login: The display_on_login of this IdentityNow.
        :type: bool
        """
        

        self._display_on_login = display_on_login

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this IdentityNow.
        The URI for this object

        :return: The self_uri of this IdentityNow.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this IdentityNow.
        The URI for this object

        :param self_uri: The self_uri of this IdentityNow.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

