# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class GroupSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        GroupSettings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'minimum_group_size': 'int',
            'maximum_group_size': 'int',
            'maximum_total_sessions': 'int',
            'maximum_concurrent_sessions': 'int'
        }

        self.attribute_map = {
            'minimum_group_size': 'minimumGroupSize',
            'maximum_group_size': 'maximumGroupSize',
            'maximum_total_sessions': 'maximumTotalSessions',
            'maximum_concurrent_sessions': 'maximumConcurrentSessions'
        }

        self._minimum_group_size = None
        self._maximum_group_size = None
        self._maximum_total_sessions = None
        self._maximum_concurrent_sessions = None

    @property
    def minimum_group_size(self) -> int:
        """
        Gets the minimum_group_size of this GroupSettings.
        The minimum size of a group for a session

        :return: The minimum_group_size of this GroupSettings.
        :rtype: int
        """
        return self._minimum_group_size

    @minimum_group_size.setter
    def minimum_group_size(self, minimum_group_size: int) -> None:
        """
        Sets the minimum_group_size of this GroupSettings.
        The minimum size of a group for a session

        :param minimum_group_size: The minimum_group_size of this GroupSettings.
        :type: int
        """
        

        self._minimum_group_size = minimum_group_size

    @property
    def maximum_group_size(self) -> int:
        """
        Gets the maximum_group_size of this GroupSettings.
        The maximum size of a group for a session

        :return: The maximum_group_size of this GroupSettings.
        :rtype: int
        """
        return self._maximum_group_size

    @maximum_group_size.setter
    def maximum_group_size(self, maximum_group_size: int) -> None:
        """
        Sets the maximum_group_size of this GroupSettings.
        The maximum size of a group for a session

        :param maximum_group_size: The maximum_group_size of this GroupSettings.
        :type: int
        """
        

        self._maximum_group_size = maximum_group_size

    @property
    def maximum_total_sessions(self) -> int:
        """
        Gets the maximum_total_sessions of this GroupSettings.
        The maximum total number of sessions

        :return: The maximum_total_sessions of this GroupSettings.
        :rtype: int
        """
        return self._maximum_total_sessions

    @maximum_total_sessions.setter
    def maximum_total_sessions(self, maximum_total_sessions: int) -> None:
        """
        Sets the maximum_total_sessions of this GroupSettings.
        The maximum total number of sessions

        :param maximum_total_sessions: The maximum_total_sessions of this GroupSettings.
        :type: int
        """
        

        self._maximum_total_sessions = maximum_total_sessions

    @property
    def maximum_concurrent_sessions(self) -> int:
        """
        Gets the maximum_concurrent_sessions of this GroupSettings.
        The maximum number of sessions that can be scheduled concurrently

        :return: The maximum_concurrent_sessions of this GroupSettings.
        :rtype: int
        """
        return self._maximum_concurrent_sessions

    @maximum_concurrent_sessions.setter
    def maximum_concurrent_sessions(self, maximum_concurrent_sessions: int) -> None:
        """
        Sets the maximum_concurrent_sessions of this GroupSettings.
        The maximum number of sessions that can be scheduled concurrently

        :param maximum_concurrent_sessions: The maximum_concurrent_sessions of this GroupSettings.
        :type: int
        """
        

        self._maximum_concurrent_sessions = maximum_concurrent_sessions

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

