# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import GrammarLanguageFileMetadata

class GrammarLanguageUpdate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        GrammarLanguageUpdate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'voice_file_metadata': 'GrammarLanguageFileMetadata',
            'dtmf_file_metadata': 'GrammarLanguageFileMetadata'
        }

        self.attribute_map = {
            'voice_file_metadata': 'voiceFileMetadata',
            'dtmf_file_metadata': 'dtmfFileMetadata'
        }

        self._voice_file_metadata = None
        self._dtmf_file_metadata = None

    @property
    def voice_file_metadata(self) -> 'GrammarLanguageFileMetadata':
        """
        Gets the voice_file_metadata of this GrammarLanguageUpdate.
        Additional information about the associated voice file

        :return: The voice_file_metadata of this GrammarLanguageUpdate.
        :rtype: GrammarLanguageFileMetadata
        """
        return self._voice_file_metadata

    @voice_file_metadata.setter
    def voice_file_metadata(self, voice_file_metadata: 'GrammarLanguageFileMetadata') -> None:
        """
        Sets the voice_file_metadata of this GrammarLanguageUpdate.
        Additional information about the associated voice file

        :param voice_file_metadata: The voice_file_metadata of this GrammarLanguageUpdate.
        :type: GrammarLanguageFileMetadata
        """
        

        self._voice_file_metadata = voice_file_metadata

    @property
    def dtmf_file_metadata(self) -> 'GrammarLanguageFileMetadata':
        """
        Gets the dtmf_file_metadata of this GrammarLanguageUpdate.
        Additional information about the associated dtmf file

        :return: The dtmf_file_metadata of this GrammarLanguageUpdate.
        :rtype: GrammarLanguageFileMetadata
        """
        return self._dtmf_file_metadata

    @dtmf_file_metadata.setter
    def dtmf_file_metadata(self, dtmf_file_metadata: 'GrammarLanguageFileMetadata') -> None:
        """
        Sets the dtmf_file_metadata of this GrammarLanguageUpdate.
        Additional information about the associated dtmf file

        :param dtmf_file_metadata: The dtmf_file_metadata of this GrammarLanguageUpdate.
        :type: GrammarLanguageFileMetadata
        """
        

        self._dtmf_file_metadata = dtmf_file_metadata

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

