# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class GetAgentsWorkPlansRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        GetAgentsWorkPlansRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'agent_ids': 'list[str]',
            'start_date': 'date',
            'week_count': 'int'
        }

        self.attribute_map = {
            'agent_ids': 'agentIds',
            'start_date': 'startDate',
            'week_count': 'weekCount'
        }

        self._agent_ids = None
        self._start_date = None
        self._week_count = None

    @property
    def agent_ids(self) -> List[str]:
        """
        Gets the agent_ids of this GetAgentsWorkPlansRequest.
        The list of agent IDs

        :return: The agent_ids of this GetAgentsWorkPlansRequest.
        :rtype: list[str]
        """
        return self._agent_ids

    @agent_ids.setter
    def agent_ids(self, agent_ids: List[str]) -> None:
        """
        Sets the agent_ids of this GetAgentsWorkPlansRequest.
        The list of agent IDs

        :param agent_ids: The agent_ids of this GetAgentsWorkPlansRequest.
        :type: list[str]
        """
        

        self._agent_ids = agent_ids

    @property
    def start_date(self) -> date:
        """
        Gets the start_date of this GetAgentsWorkPlansRequest.
        The start of a date in yyyy-MM-dd format. Response contains values rolled back to nearest BU start day of week. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The start_date of this GetAgentsWorkPlansRequest.
        :rtype: date
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date: date) -> None:
        """
        Sets the start_date of this GetAgentsWorkPlansRequest.
        The start of a date in yyyy-MM-dd format. Response contains values rolled back to nearest BU start day of week. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param start_date: The start_date of this GetAgentsWorkPlansRequest.
        :type: date
        """
        

        self._start_date = start_date

    @property
    def week_count(self) -> int:
        """
        Gets the week_count of this GetAgentsWorkPlansRequest.
        The number of weeks to query

        :return: The week_count of this GetAgentsWorkPlansRequest.
        :rtype: int
        """
        return self._week_count

    @week_count.setter
    def week_count(self, week_count: int) -> None:
        """
        Sets the week_count of this GetAgentsWorkPlansRequest.
        The number of weeks to query

        :param week_count: The week_count of this GetAgentsWorkPlansRequest.
        :type: int
        """
        

        self._week_count = week_count

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

