# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class GenerateBuForecastRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        GenerateBuForecastRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'description': 'str',
            'week_count': 'int',
            'can_use_for_scheduling': 'bool'
        }

        self.attribute_map = {
            'description': 'description',
            'week_count': 'weekCount',
            'can_use_for_scheduling': 'canUseForScheduling'
        }

        self._description = None
        self._week_count = None
        self._can_use_for_scheduling = None

    @property
    def description(self) -> str:
        """
        Gets the description of this GenerateBuForecastRequest.
        The description for the forecast

        :return: The description of this GenerateBuForecastRequest.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this GenerateBuForecastRequest.
        The description for the forecast

        :param description: The description of this GenerateBuForecastRequest.
        :type: str
        """
        

        self._description = description

    @property
    def week_count(self) -> int:
        """
        Gets the week_count of this GenerateBuForecastRequest.
        The number of weeks this forecast covers

        :return: The week_count of this GenerateBuForecastRequest.
        :rtype: int
        """
        return self._week_count

    @week_count.setter
    def week_count(self, week_count: int) -> None:
        """
        Sets the week_count of this GenerateBuForecastRequest.
        The number of weeks this forecast covers

        :param week_count: The week_count of this GenerateBuForecastRequest.
        :type: int
        """
        

        self._week_count = week_count

    @property
    def can_use_for_scheduling(self) -> bool:
        """
        Gets the can_use_for_scheduling of this GenerateBuForecastRequest.
        Whether this forecast can be used for scheduling

        :return: The can_use_for_scheduling of this GenerateBuForecastRequest.
        :rtype: bool
        """
        return self._can_use_for_scheduling

    @can_use_for_scheduling.setter
    def can_use_for_scheduling(self, can_use_for_scheduling: bool) -> None:
        """
        Sets the can_use_for_scheduling of this GenerateBuForecastRequest.
        Whether this forecast can be used for scheduling

        :param can_use_for_scheduling: The can_use_for_scheduling of this GenerateBuForecastRequest.
        :type: bool
        """
        

        self._can_use_for_scheduling = can_use_for_scheduling

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

