# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class Function(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        Function - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'date_created': 'datetime',
            'zip_id': 'str',
            'handler': 'str',
            'runtime': 'str',
            'timeout_seconds': 'int'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'date_created': 'dateCreated',
            'zip_id': 'zipId',
            'handler': 'handler',
            'runtime': 'runtime',
            'timeout_seconds': 'timeoutSeconds'
        }

        self._id = None
        self._name = None
        self._description = None
        self._date_created = None
        self._zip_id = None
        self._handler = None
        self._runtime = None
        self._timeout_seconds = None

    @property
    def id(self) -> str:
        """
        Gets the id of this Function.
        Function identifier.

        :return: The id of this Function.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this Function.
        Function identifier.

        :param id: The id of this Function.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this Function.
        Function name. This is automatically created based on the Action Id.

        :return: The name of this Function.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this Function.
        Function name. This is automatically created based on the Action Id.

        :param name: The name of this Function.
        :type: str
        """
        

        self._name = name

    @property
    def description(self) -> str:
        """
        Gets the description of this Function.
        Description of the function. Limit 255 characters.

        :return: The description of this Function.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this Function.
        Description of the function. Limit 255 characters.

        :param description: The description of this Function.
        :type: str
        """
        

        self._description = description

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this Function.
        Date and time function was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this Function.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this Function.
        Date and time function was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this Function.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def zip_id(self) -> str:
        """
        Gets the zip_id of this Function.
        Zip file identifier.

        :return: The zip_id of this Function.
        :rtype: str
        """
        return self._zip_id

    @zip_id.setter
    def zip_id(self, zip_id: str) -> None:
        """
        Sets the zip_id of this Function.
        Zip file identifier.

        :param zip_id: The zip_id of this Function.
        :type: str
        """
        

        self._zip_id = zip_id

    @property
    def handler(self) -> str:
        """
        Gets the handler of this Function.
        Handler entry point into zip file to execute function. Should be path within upload function package to the invocation module without language extension, followed by a period and then exported invocation method name. e.g. 'src/index.handler'

        :return: The handler of this Function.
        :rtype: str
        """
        return self._handler

    @handler.setter
    def handler(self, handler: str) -> None:
        """
        Sets the handler of this Function.
        Handler entry point into zip file to execute function. Should be path within upload function package to the invocation module without language extension, followed by a period and then exported invocation method name. e.g. 'src/index.handler'

        :param handler: The handler of this Function.
        :type: str
        """
        

        self._handler = handler

    @property
    def runtime(self) -> str:
        """
        Gets the runtime of this Function.
        Runtime required for execution. Valid runtimes change over time as versions are deprecated. Use /api/v2/integrations/actions/functions/runtimes for current list.

        :return: The runtime of this Function.
        :rtype: str
        """
        return self._runtime

    @runtime.setter
    def runtime(self, runtime: str) -> None:
        """
        Sets the runtime of this Function.
        Runtime required for execution. Valid runtimes change over time as versions are deprecated. Use /api/v2/integrations/actions/functions/runtimes for current list.

        :param runtime: The runtime of this Function.
        :type: str
        """
        

        self._runtime = runtime

    @property
    def timeout_seconds(self) -> int:
        """
        Gets the timeout_seconds of this Function.
        Execution timeout to apply to function. Value is in seconds. Range allowed 1 to 15. Default value 15 seconds.

        :return: The timeout_seconds of this Function.
        :rtype: int
        """
        return self._timeout_seconds

    @timeout_seconds.setter
    def timeout_seconds(self, timeout_seconds: int) -> None:
        """
        Sets the timeout_seconds of this Function.
        Execution timeout to apply to function. Value is in seconds. Range allowed 1 to 15. Default value 15 seconds.

        :param timeout_seconds: The timeout_seconds of this Function.
        :type: int
        """
        
        if timeout_seconds > 15:
            raise ValueError("Invalid value for `timeout_seconds`, must be a value less than or equal to `15`")

        if timeout_seconds < 1:
            raise ValueError("Invalid value for `timeout_seconds`, must be a value greater than or equal to `1`")


        self._timeout_seconds = timeout_seconds

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

