# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import QueryCriteria

class FlowsQueryCriteriaResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        FlowsQueryCriteriaResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'criteria': 'list[QueryCriteria]',
            'flow_types': 'list[str]',
            'action_types': 'list[str]',
            'error_codes': 'list[str]',
            'warning_codes': 'list[str]'
        }

        self.attribute_map = {
            'criteria': 'criteria',
            'flow_types': 'flowTypes',
            'action_types': 'actionTypes',
            'error_codes': 'errorCodes',
            'warning_codes': 'warningCodes'
        }

        self._criteria = None
        self._flow_types = None
        self._action_types = None
        self._error_codes = None
        self._warning_codes = None

    @property
    def criteria(self) -> List['QueryCriteria']:
        """
        Gets the criteria of this FlowsQueryCriteriaResponse.
        The is a list of allowed criteria to query on.

        :return: The criteria of this FlowsQueryCriteriaResponse.
        :rtype: list[QueryCriteria]
        """
        return self._criteria

    @criteria.setter
    def criteria(self, criteria: List['QueryCriteria']) -> None:
        """
        Sets the criteria of this FlowsQueryCriteriaResponse.
        The is a list of allowed criteria to query on.

        :param criteria: The criteria of this FlowsQueryCriteriaResponse.
        :type: list[QueryCriteria]
        """
        

        self._criteria = criteria

    @property
    def flow_types(self) -> List[str]:
        """
        Gets the flow_types of this FlowsQueryCriteriaResponse.
        The is a list of flow types the organization has access to.

        :return: The flow_types of this FlowsQueryCriteriaResponse.
        :rtype: list[str]
        """
        return self._flow_types

    @flow_types.setter
    def flow_types(self, flow_types: List[str]) -> None:
        """
        Sets the flow_types of this FlowsQueryCriteriaResponse.
        The is a list of flow types the organization has access to.

        :param flow_types: The flow_types of this FlowsQueryCriteriaResponse.
        :type: list[str]
        """
        

        self._flow_types = flow_types

    @property
    def action_types(self) -> List[str]:
        """
        Gets the action_types of this FlowsQueryCriteriaResponse.
        The is a list of action types the organization has access to.

        :return: The action_types of this FlowsQueryCriteriaResponse.
        :rtype: list[str]
        """
        return self._action_types

    @action_types.setter
    def action_types(self, action_types: List[str]) -> None:
        """
        Sets the action_types of this FlowsQueryCriteriaResponse.
        The is a list of action types the organization has access to.

        :param action_types: The action_types of this FlowsQueryCriteriaResponse.
        :type: list[str]
        """
        

        self._action_types = action_types

    @property
    def error_codes(self) -> List[str]:
        """
        Gets the error_codes of this FlowsQueryCriteriaResponse.
        The is a list of potential error codes the organization may encounter.

        :return: The error_codes of this FlowsQueryCriteriaResponse.
        :rtype: list[str]
        """
        return self._error_codes

    @error_codes.setter
    def error_codes(self, error_codes: List[str]) -> None:
        """
        Sets the error_codes of this FlowsQueryCriteriaResponse.
        The is a list of potential error codes the organization may encounter.

        :param error_codes: The error_codes of this FlowsQueryCriteriaResponse.
        :type: list[str]
        """
        

        self._error_codes = error_codes

    @property
    def warning_codes(self) -> List[str]:
        """
        Gets the warning_codes of this FlowsQueryCriteriaResponse.
        The is a list of potential warning codes the organization may encounter.

        :return: The warning_codes of this FlowsQueryCriteriaResponse.
        :rtype: list[str]
        """
        return self._warning_codes

    @warning_codes.setter
    def warning_codes(self, warning_codes: List[str]) -> None:
        """
        Sets the warning_codes of this FlowsQueryCriteriaResponse.
        The is a list of potential warning codes the organization may encounter.

        :param warning_codes: The warning_codes of this FlowsQueryCriteriaResponse.
        :type: list[str]
        """
        

        self._warning_codes = warning_codes

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

