# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import FlowPathsFlowDetails

class FlowPathsElement(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        FlowPathsElement - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'parent_id': 'str',
            'type': 'str',
            'count': 'int',
            'flows': 'list[FlowPathsFlowDetails]',
            'flow_outcome_value': 'str',
            'flow_milestone': 'AddressableEntityRef',
            'flow_outcome': 'AddressableEntityRef'
        }

        self.attribute_map = {
            'parent_id': 'parentId',
            'type': 'type',
            'count': 'count',
            'flows': 'flows',
            'flow_outcome_value': 'flowOutcomeValue',
            'flow_milestone': 'flowMilestone',
            'flow_outcome': 'flowOutcome'
        }

        self._parent_id = None
        self._type = None
        self._count = None
        self._flows = None
        self._flow_outcome_value = None
        self._flow_milestone = None
        self._flow_outcome = None

    @property
    def parent_id(self) -> str:
        """
        Gets the parent_id of this FlowPathsElement.
        Unique identifier of the parent element. Will be null for the root element.

        :return: The parent_id of this FlowPathsElement.
        :rtype: str
        """
        return self._parent_id

    @parent_id.setter
    def parent_id(self, parent_id: str) -> None:
        """
        Sets the parent_id of this FlowPathsElement.
        Unique identifier of the parent element. Will be null for the root element.

        :param parent_id: The parent_id of this FlowPathsElement.
        :type: str
        """
        

        self._parent_id = parent_id

    @property
    def type(self) -> str:
        """
        Gets the type of this FlowPathsElement.
        Type of the element.

        :return: The type of this FlowPathsElement.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this FlowPathsElement.
        Type of the element.

        :param type: The type of this FlowPathsElement.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Abandoned", "AgentEscalation", "Disconnect", "Error", "Exit", "Milestone", "Outcome", "RecognitionFailure", "Root", "TransferReturnToAgent", "TransferToAcd", "TransferToAcdVoicemail", "TransferToFlow", "TransferToGroup", "TransferToGroupVoicemail", "TransferToNumber", "TransferToSecureFlow", "TransferToUser", "TransferToUserVoicemail"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def count(self) -> int:
        """
        Gets the count of this FlowPathsElement.
        Count of all journeys that include this element.

        :return: The count of this FlowPathsElement.
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count: int) -> None:
        """
        Sets the count of this FlowPathsElement.
        Count of all journeys that include this element.

        :param count: The count of this FlowPathsElement.
        :type: int
        """
        

        self._count = count

    @property
    def flows(self) -> List['FlowPathsFlowDetails']:
        """
        Gets the flows of this FlowPathsElement.
        Details of flows involved in journeys that include this element.

        :return: The flows of this FlowPathsElement.
        :rtype: list[FlowPathsFlowDetails]
        """
        return self._flows

    @flows.setter
    def flows(self, flows: List['FlowPathsFlowDetails']) -> None:
        """
        Sets the flows of this FlowPathsElement.
        Details of flows involved in journeys that include this element.

        :param flows: The flows of this FlowPathsElement.
        :type: list[FlowPathsFlowDetails]
        """
        

        self._flows = flows

    @property
    def flow_outcome_value(self) -> str:
        """
        Gets the flow_outcome_value of this FlowPathsElement.
        The value of the flow outcome, if the element type is Outcome.

        :return: The flow_outcome_value of this FlowPathsElement.
        :rtype: str
        """
        return self._flow_outcome_value

    @flow_outcome_value.setter
    def flow_outcome_value(self, flow_outcome_value: str) -> None:
        """
        Sets the flow_outcome_value of this FlowPathsElement.
        The value of the flow outcome, if the element type is Outcome.

        :param flow_outcome_value: The flow_outcome_value of this FlowPathsElement.
        :type: str
        """
        if isinstance(flow_outcome_value, int):
            flow_outcome_value = str(flow_outcome_value)
        allowed_values = ["FAILURE", "SUCCESS", "UNKNOWN"]
        if flow_outcome_value.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for flow_outcome_value -> " + flow_outcome_value)
            self._flow_outcome_value = "outdated_sdk_version"
        else:
            self._flow_outcome_value = flow_outcome_value

    @property
    def flow_milestone(self) -> 'AddressableEntityRef':
        """
        Gets the flow_milestone of this FlowPathsElement.
        The flow milestone, set if the element type is Milestone.

        :return: The flow_milestone of this FlowPathsElement.
        :rtype: AddressableEntityRef
        """
        return self._flow_milestone

    @flow_milestone.setter
    def flow_milestone(self, flow_milestone: 'AddressableEntityRef') -> None:
        """
        Sets the flow_milestone of this FlowPathsElement.
        The flow milestone, set if the element type is Milestone.

        :param flow_milestone: The flow_milestone of this FlowPathsElement.
        :type: AddressableEntityRef
        """
        

        self._flow_milestone = flow_milestone

    @property
    def flow_outcome(self) -> 'AddressableEntityRef':
        """
        Gets the flow_outcome of this FlowPathsElement.
        The flow outcome, set if the element type is Outcome or Milestone.

        :return: The flow_outcome of this FlowPathsElement.
        :rtype: AddressableEntityRef
        """
        return self._flow_outcome

    @flow_outcome.setter
    def flow_outcome(self, flow_outcome: 'AddressableEntityRef') -> None:
        """
        Sets the flow_outcome of this FlowPathsElement.
        The flow outcome, set if the element type is Outcome or Milestone.

        :param flow_outcome: The flow_outcome of this FlowPathsElement.
        :type: AddressableEntityRef
        """
        

        self._flow_outcome = flow_outcome

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

