# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import FlowHealthIntentVersionInfo
    from . import HealthInfo

class FlowHealthIntent(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        FlowHealthIntent - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'flow_version_info': 'FlowHealthIntentVersionInfo',
            'language': 'str',
            'health': 'HealthInfo',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'flow_version_info': 'flowVersionInfo',
            'language': 'language',
            'health': 'health',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._flow_version_info = None
        self._language = None
        self._health = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this FlowHealthIntent.
        The globally unique identifier for the object.

        :return: The id of this FlowHealthIntent.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this FlowHealthIntent.
        The globally unique identifier for the object.

        :param id: The id of this FlowHealthIntent.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this FlowHealthIntent.


        :return: The name of this FlowHealthIntent.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this FlowHealthIntent.


        :param name: The name of this FlowHealthIntent.
        :type: str
        """
        

        self._name = name

    @property
    def flow_version_info(self) -> 'FlowHealthIntentVersionInfo':
        """
        Gets the flow_version_info of this FlowHealthIntent.
        Info about given flow version.

        :return: The flow_version_info of this FlowHealthIntent.
        :rtype: FlowHealthIntentVersionInfo
        """
        return self._flow_version_info

    @flow_version_info.setter
    def flow_version_info(self, flow_version_info: 'FlowHealthIntentVersionInfo') -> None:
        """
        Sets the flow_version_info of this FlowHealthIntent.
        Info about given flow version.

        :param flow_version_info: The flow_version_info of this FlowHealthIntent.
        :type: FlowHealthIntentVersionInfo
        """
        

        self._flow_version_info = flow_version_info

    @property
    def language(self) -> str:
        """
        Gets the language of this FlowHealthIntent.
        Language provided for this intent's health.

        :return: The language of this FlowHealthIntent.
        :rtype: str
        """
        return self._language

    @language.setter
    def language(self, language: str) -> None:
        """
        Sets the language of this FlowHealthIntent.
        Language provided for this intent's health.

        :param language: The language of this FlowHealthIntent.
        :type: str
        """
        if isinstance(language, int):
            language = str(language)
        allowed_values = ["en-us", "en-gb", "en-au", "en-za", "en-nz", "en-ie", "fr-ca", "fr-fr", "es-us", "es-es", "es-mx", "de-de", "it-it", "pt-br", "pt-pt", "nl-nl"]
        if language.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for language -> " + language)
            self._language = "outdated_sdk_version"
        else:
            self._language = language

    @property
    def health(self) -> 'HealthInfo':
        """
        Gets the health of this FlowHealthIntent.
        Health computation details for given language.

        :return: The health of this FlowHealthIntent.
        :rtype: HealthInfo
        """
        return self._health

    @health.setter
    def health(self, health: 'HealthInfo') -> None:
        """
        Sets the health of this FlowHealthIntent.
        Health computation details for given language.

        :param health: The health of this FlowHealthIntent.
        :type: HealthInfo
        """
        

        self._health = health

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this FlowHealthIntent.
        The URI for this object

        :return: The self_uri of this FlowHealthIntent.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this FlowHealthIntent.
        The URI for this object

        :param self_uri: The self_uri of this FlowHealthIntent.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

