# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class Faq(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        Faq - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'question': 'str',
            'answer': 'str',
            'source_uri': 'str',
            'document_url': 'str',
            'document_display_name': 'str',
            'confidence': 'float'
        }

        self.attribute_map = {
            'question': 'question',
            'answer': 'answer',
            'source_uri': 'sourceUri',
            'document_url': 'documentUrl',
            'document_display_name': 'documentDisplayName',
            'confidence': 'confidence'
        }

        self._question = None
        self._answer = None
        self._source_uri = None
        self._document_url = None
        self._document_display_name = None
        self._confidence = None

    @property
    def question(self) -> str:
        """
        Gets the question of this Faq.
        Question from the knowledge base that was matched to user request.

        :return: The question of this Faq.
        :rtype: str
        """
        return self._question

    @question.setter
    def question(self, question: str) -> None:
        """
        Sets the question of this Faq.
        Question from the knowledge base that was matched to user request.

        :param question: The question of this Faq.
        :type: str
        """
        

        self._question = question

    @property
    def answer(self) -> str:
        """
        Gets the answer of this Faq.
        Answer from the knowledge base corresponding to the identified question.

        :return: The answer of this Faq.
        :rtype: str
        """
        return self._answer

    @answer.setter
    def answer(self, answer: str) -> None:
        """
        Sets the answer of this Faq.
        Answer from the knowledge base corresponding to the identified question.

        :param answer: The answer of this Faq.
        :type: str
        """
        

        self._answer = answer

    @property
    def source_uri(self) -> str:
        """
        Gets the source_uri of this Faq.
        A URI uniquely identifying the document, e.g. projects/acme-inc/knowledgeBases/MTAyNjgxNDU1Nzc3NTM1NzU0MjQ/documents/MTI5ODc3NzQzOTQ5MTc5NzgxMTI.

        :return: The source_uri of this Faq.
        :rtype: str
        """
        return self._source_uri

    @source_uri.setter
    def source_uri(self, source_uri: str) -> None:
        """
        Sets the source_uri of this Faq.
        A URI uniquely identifying the document, e.g. projects/acme-inc/knowledgeBases/MTAyNjgxNDU1Nzc3NTM1NzU0MjQ/documents/MTI5ODc3NzQzOTQ5MTc5NzgxMTI.

        :param source_uri: The source_uri of this Faq.
        :type: str
        """
        

        self._source_uri = source_uri

    @property
    def document_url(self) -> str:
        """
        Gets the document_url of this Faq.
        URL pointing to a web page if document was sourced from a URL.

        :return: The document_url of this Faq.
        :rtype: str
        """
        return self._document_url

    @document_url.setter
    def document_url(self, document_url: str) -> None:
        """
        Sets the document_url of this Faq.
        URL pointing to a web page if document was sourced from a URL.

        :param document_url: The document_url of this Faq.
        :type: str
        """
        

        self._document_url = document_url

    @property
    def document_display_name(self) -> str:
        """
        Gets the document_display_name of this Faq.
        A human-readable description of the document, e.g. 'Sample store FAQ'

        :return: The document_display_name of this Faq.
        :rtype: str
        """
        return self._document_display_name

    @document_display_name.setter
    def document_display_name(self, document_display_name: str) -> None:
        """
        Sets the document_display_name of this Faq.
        A human-readable description of the document, e.g. 'Sample store FAQ'

        :param document_display_name: The document_display_name of this Faq.
        :type: str
        """
        

        self._document_display_name = document_display_name

    @property
    def confidence(self) -> float:
        """
        Gets the confidence of this Faq.
        Value between 0 and 1. 1 corresponds to very confident, 0 to not confident at all

        :return: The confidence of this Faq.
        :rtype: float
        """
        return self._confidence

    @confidence.setter
    def confidence(self, confidence: float) -> None:
        """
        Sets the confidence of this Faq.
        Value between 0 and 1. 1 corresponds to very confident, 0 to not confident at all

        :param confidence: The confidence of this Faq.
        :type: float
        """
        

        self._confidence = confidence

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

