# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class FacebookDataIngestionRuleResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        FacebookDataIngestionRuleResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'status': 'str',
            'version': 'int',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'platform': 'str',
            'integration_id': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'status': 'status',
            'version': 'version',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'platform': 'platform',
            'integration_id': 'integrationId',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._description = None
        self._status = None
        self._version = None
        self._date_created = None
        self._date_modified = None
        self._platform = None
        self._integration_id = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this FacebookDataIngestionRuleResponse.
        ID of the Facebook data ingestion rule.

        :return: The id of this FacebookDataIngestionRuleResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this FacebookDataIngestionRuleResponse.
        ID of the Facebook data ingestion rule.

        :param id: The id of this FacebookDataIngestionRuleResponse.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this FacebookDataIngestionRuleResponse.
        The name of the data ingestion rule.

        :return: The name of this FacebookDataIngestionRuleResponse.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this FacebookDataIngestionRuleResponse.
        The name of the data ingestion rule.

        :param name: The name of this FacebookDataIngestionRuleResponse.
        :type: str
        """
        

        self._name = name

    @property
    def description(self) -> str:
        """
        Gets the description of this FacebookDataIngestionRuleResponse.
        A description of the data ingestion rule.

        :return: The description of this FacebookDataIngestionRuleResponse.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this FacebookDataIngestionRuleResponse.
        A description of the data ingestion rule.

        :param description: The description of this FacebookDataIngestionRuleResponse.
        :type: str
        """
        

        self._description = description

    @property
    def status(self) -> str:
        """
        Gets the status of this FacebookDataIngestionRuleResponse.
        The status of the data ingestion rule.

        :return: The status of this FacebookDataIngestionRuleResponse.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this FacebookDataIngestionRuleResponse.
        The status of the data ingestion rule.

        :param status: The status of this FacebookDataIngestionRuleResponse.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Active", "Deleted", "Error", "Paused", "Pending", "SystemPaused"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def version(self) -> int:
        """
        Gets the version of this FacebookDataIngestionRuleResponse.
        The version number of the data ingestion rule.

        :return: The version of this FacebookDataIngestionRuleResponse.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version: int) -> None:
        """
        Sets the version of this FacebookDataIngestionRuleResponse.
        The version number of the data ingestion rule.

        :param version: The version of this FacebookDataIngestionRuleResponse.
        :type: int
        """
        

        self._version = version

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this FacebookDataIngestionRuleResponse.
        Timestamp indicating when the data ingestion rule was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this FacebookDataIngestionRuleResponse.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this FacebookDataIngestionRuleResponse.
        Timestamp indicating when the data ingestion rule was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this FacebookDataIngestionRuleResponse.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this FacebookDataIngestionRuleResponse.
        Timestamp indicating when the data ingestion rule was last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this FacebookDataIngestionRuleResponse.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this FacebookDataIngestionRuleResponse.
        Timestamp indicating when the data ingestion rule was last updated. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this FacebookDataIngestionRuleResponse.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def platform(self) -> str:
        """
        Gets the platform of this FacebookDataIngestionRuleResponse.
        The platform of the data ingestion rule.

        :return: The platform of this FacebookDataIngestionRuleResponse.
        :rtype: str
        """
        return self._platform

    @platform.setter
    def platform(self, platform: str) -> None:
        """
        Sets the platform of this FacebookDataIngestionRuleResponse.
        The platform of the data ingestion rule.

        :param platform: The platform of this FacebookDataIngestionRuleResponse.
        :type: str
        """
        

        self._platform = platform

    @property
    def integration_id(self) -> str:
        """
        Gets the integration_id of this FacebookDataIngestionRuleResponse.
        The Integration Id from which public social posts are ingested. This entity is created using the /conversations/messaging/integrations/facebook resource

        :return: The integration_id of this FacebookDataIngestionRuleResponse.
        :rtype: str
        """
        return self._integration_id

    @integration_id.setter
    def integration_id(self, integration_id: str) -> None:
        """
        Sets the integration_id of this FacebookDataIngestionRuleResponse.
        The Integration Id from which public social posts are ingested. This entity is created using the /conversations/messaging/integrations/facebook resource

        :param integration_id: The integration_id of this FacebookDataIngestionRuleResponse.
        :type: str
        """
        

        self._integration_id = integration_id

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this FacebookDataIngestionRuleResponse.
        The URI for this object

        :return: The self_uri of this FacebookDataIngestionRuleResponse.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this FacebookDataIngestionRuleResponse.
        The URI for this object

        :param self_uri: The self_uri of this FacebookDataIngestionRuleResponse.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

