# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ExternalContactsUnresolvedContactChangedTopicContactAddress
    from . import ExternalContactsUnresolvedContactChangedTopicDataSchema
    from . import ExternalContactsUnresolvedContactChangedTopicDivision
    from . import ExternalContactsUnresolvedContactChangedTopicExternalId
    from . import ExternalContactsUnresolvedContactChangedTopicExternalOrganization
    from . import ExternalContactsUnresolvedContactChangedTopicFacebookId
    from . import ExternalContactsUnresolvedContactChangedTopicInstagramId
    from . import ExternalContactsUnresolvedContactChangedTopicLineId
    from . import ExternalContactsUnresolvedContactChangedTopicMergeOperation
    from . import ExternalContactsUnresolvedContactChangedTopicPhoneNumber
    from . import ExternalContactsUnresolvedContactChangedTopicTwitterId
    from . import ExternalContactsUnresolvedContactChangedTopicWhatsAppId

class ExternalContactsUnresolvedContactChangedTopicContact(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ExternalContactsUnresolvedContactChangedTopicContact - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'division': 'ExternalContactsUnresolvedContactChangedTopicDivision',
            'external_organization': 'ExternalContactsUnresolvedContactChangedTopicExternalOrganization',
            'type': 'str',
            'first_name': 'str',
            'middle_name': 'str',
            'last_name': 'str',
            'salutation': 'str',
            'title': 'str',
            'work_phone': 'ExternalContactsUnresolvedContactChangedTopicPhoneNumber',
            'cell_phone': 'ExternalContactsUnresolvedContactChangedTopicPhoneNumber',
            'home_phone': 'ExternalContactsUnresolvedContactChangedTopicPhoneNumber',
            'other_phone': 'ExternalContactsUnresolvedContactChangedTopicPhoneNumber',
            'work_email': 'str',
            'personal_email': 'str',
            'other_email': 'str',
            'address': 'ExternalContactsUnresolvedContactChangedTopicContactAddress',
            'survey_opt_out': 'bool',
            'external_system_url': 'str',
            'twitter_id': 'ExternalContactsUnresolvedContactChangedTopicTwitterId',
            'line_id': 'ExternalContactsUnresolvedContactChangedTopicLineId',
            'whats_app_id': 'ExternalContactsUnresolvedContactChangedTopicWhatsAppId',
            'facebook_id': 'ExternalContactsUnresolvedContactChangedTopicFacebookId',
            'instagram_id': 'ExternalContactsUnresolvedContactChangedTopicInstagramId',
            'external_ids': 'list[ExternalContactsUnresolvedContactChangedTopicExternalId]',
            'canonical_contact_id': 'str',
            'schema': 'ExternalContactsUnresolvedContactChangedTopicDataSchema',
            'custom_fields': 'dict(str, object)',
            'merge_set': 'list[str]',
            'merged_from': 'list[str]',
            'merged_to': 'str',
            'merge_operation': 'ExternalContactsUnresolvedContactChangedTopicMergeOperation',
            'create_date': 'datetime',
            'modify_date': 'datetime'
        }

        self.attribute_map = {
            'id': 'id',
            'division': 'division',
            'external_organization': 'externalOrganization',
            'type': 'type',
            'first_name': 'firstName',
            'middle_name': 'middleName',
            'last_name': 'lastName',
            'salutation': 'salutation',
            'title': 'title',
            'work_phone': 'workPhone',
            'cell_phone': 'cellPhone',
            'home_phone': 'homePhone',
            'other_phone': 'otherPhone',
            'work_email': 'workEmail',
            'personal_email': 'personalEmail',
            'other_email': 'otherEmail',
            'address': 'address',
            'survey_opt_out': 'surveyOptOut',
            'external_system_url': 'externalSystemUrl',
            'twitter_id': 'twitterId',
            'line_id': 'lineId',
            'whats_app_id': 'whatsAppId',
            'facebook_id': 'facebookId',
            'instagram_id': 'instagramId',
            'external_ids': 'externalIds',
            'canonical_contact_id': 'canonicalContactId',
            'schema': 'schema',
            'custom_fields': 'customFields',
            'merge_set': 'mergeSet',
            'merged_from': 'mergedFrom',
            'merged_to': 'mergedTo',
            'merge_operation': 'mergeOperation',
            'create_date': 'createDate',
            'modify_date': 'modifyDate'
        }

        self._id = None
        self._division = None
        self._external_organization = None
        self._type = None
        self._first_name = None
        self._middle_name = None
        self._last_name = None
        self._salutation = None
        self._title = None
        self._work_phone = None
        self._cell_phone = None
        self._home_phone = None
        self._other_phone = None
        self._work_email = None
        self._personal_email = None
        self._other_email = None
        self._address = None
        self._survey_opt_out = None
        self._external_system_url = None
        self._twitter_id = None
        self._line_id = None
        self._whats_app_id = None
        self._facebook_id = None
        self._instagram_id = None
        self._external_ids = None
        self._canonical_contact_id = None
        self._schema = None
        self._custom_fields = None
        self._merge_set = None
        self._merged_from = None
        self._merged_to = None
        self._merge_operation = None
        self._create_date = None
        self._modify_date = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The id of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param id: The id of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: str
        """
        

        self._id = id

    @property
    def division(self) -> 'ExternalContactsUnresolvedContactChangedTopicDivision':
        """
        Gets the division of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The division of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: ExternalContactsUnresolvedContactChangedTopicDivision
        """
        return self._division

    @division.setter
    def division(self, division: 'ExternalContactsUnresolvedContactChangedTopicDivision') -> None:
        """
        Sets the division of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param division: The division of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: ExternalContactsUnresolvedContactChangedTopicDivision
        """
        

        self._division = division

    @property
    def external_organization(self) -> 'ExternalContactsUnresolvedContactChangedTopicExternalOrganization':
        """
        Gets the external_organization of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The external_organization of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: ExternalContactsUnresolvedContactChangedTopicExternalOrganization
        """
        return self._external_organization

    @external_organization.setter
    def external_organization(self, external_organization: 'ExternalContactsUnresolvedContactChangedTopicExternalOrganization') -> None:
        """
        Sets the external_organization of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param external_organization: The external_organization of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: ExternalContactsUnresolvedContactChangedTopicExternalOrganization
        """
        

        self._external_organization = external_organization

    @property
    def type(self) -> str:
        """
        Gets the type of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The type of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param type: The type of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Ephemeral", "Identified", "Curated"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def first_name(self) -> str:
        """
        Gets the first_name of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The first_name of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name: str) -> None:
        """
        Sets the first_name of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param first_name: The first_name of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: str
        """
        

        self._first_name = first_name

    @property
    def middle_name(self) -> str:
        """
        Gets the middle_name of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The middle_name of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: str
        """
        return self._middle_name

    @middle_name.setter
    def middle_name(self, middle_name: str) -> None:
        """
        Sets the middle_name of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param middle_name: The middle_name of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: str
        """
        

        self._middle_name = middle_name

    @property
    def last_name(self) -> str:
        """
        Gets the last_name of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The last_name of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name: str) -> None:
        """
        Sets the last_name of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param last_name: The last_name of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: str
        """
        

        self._last_name = last_name

    @property
    def salutation(self) -> str:
        """
        Gets the salutation of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The salutation of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: str
        """
        return self._salutation

    @salutation.setter
    def salutation(self, salutation: str) -> None:
        """
        Sets the salutation of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param salutation: The salutation of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: str
        """
        

        self._salutation = salutation

    @property
    def title(self) -> str:
        """
        Gets the title of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The title of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title: str) -> None:
        """
        Sets the title of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param title: The title of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: str
        """
        

        self._title = title

    @property
    def work_phone(self) -> 'ExternalContactsUnresolvedContactChangedTopicPhoneNumber':
        """
        Gets the work_phone of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The work_phone of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: ExternalContactsUnresolvedContactChangedTopicPhoneNumber
        """
        return self._work_phone

    @work_phone.setter
    def work_phone(self, work_phone: 'ExternalContactsUnresolvedContactChangedTopicPhoneNumber') -> None:
        """
        Sets the work_phone of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param work_phone: The work_phone of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: ExternalContactsUnresolvedContactChangedTopicPhoneNumber
        """
        

        self._work_phone = work_phone

    @property
    def cell_phone(self) -> 'ExternalContactsUnresolvedContactChangedTopicPhoneNumber':
        """
        Gets the cell_phone of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The cell_phone of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: ExternalContactsUnresolvedContactChangedTopicPhoneNumber
        """
        return self._cell_phone

    @cell_phone.setter
    def cell_phone(self, cell_phone: 'ExternalContactsUnresolvedContactChangedTopicPhoneNumber') -> None:
        """
        Sets the cell_phone of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param cell_phone: The cell_phone of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: ExternalContactsUnresolvedContactChangedTopicPhoneNumber
        """
        

        self._cell_phone = cell_phone

    @property
    def home_phone(self) -> 'ExternalContactsUnresolvedContactChangedTopicPhoneNumber':
        """
        Gets the home_phone of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The home_phone of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: ExternalContactsUnresolvedContactChangedTopicPhoneNumber
        """
        return self._home_phone

    @home_phone.setter
    def home_phone(self, home_phone: 'ExternalContactsUnresolvedContactChangedTopicPhoneNumber') -> None:
        """
        Sets the home_phone of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param home_phone: The home_phone of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: ExternalContactsUnresolvedContactChangedTopicPhoneNumber
        """
        

        self._home_phone = home_phone

    @property
    def other_phone(self) -> 'ExternalContactsUnresolvedContactChangedTopicPhoneNumber':
        """
        Gets the other_phone of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The other_phone of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: ExternalContactsUnresolvedContactChangedTopicPhoneNumber
        """
        return self._other_phone

    @other_phone.setter
    def other_phone(self, other_phone: 'ExternalContactsUnresolvedContactChangedTopicPhoneNumber') -> None:
        """
        Sets the other_phone of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param other_phone: The other_phone of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: ExternalContactsUnresolvedContactChangedTopicPhoneNumber
        """
        

        self._other_phone = other_phone

    @property
    def work_email(self) -> str:
        """
        Gets the work_email of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The work_email of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: str
        """
        return self._work_email

    @work_email.setter
    def work_email(self, work_email: str) -> None:
        """
        Sets the work_email of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param work_email: The work_email of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: str
        """
        

        self._work_email = work_email

    @property
    def personal_email(self) -> str:
        """
        Gets the personal_email of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The personal_email of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: str
        """
        return self._personal_email

    @personal_email.setter
    def personal_email(self, personal_email: str) -> None:
        """
        Sets the personal_email of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param personal_email: The personal_email of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: str
        """
        

        self._personal_email = personal_email

    @property
    def other_email(self) -> str:
        """
        Gets the other_email of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The other_email of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: str
        """
        return self._other_email

    @other_email.setter
    def other_email(self, other_email: str) -> None:
        """
        Sets the other_email of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param other_email: The other_email of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: str
        """
        

        self._other_email = other_email

    @property
    def address(self) -> 'ExternalContactsUnresolvedContactChangedTopicContactAddress':
        """
        Gets the address of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The address of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: ExternalContactsUnresolvedContactChangedTopicContactAddress
        """
        return self._address

    @address.setter
    def address(self, address: 'ExternalContactsUnresolvedContactChangedTopicContactAddress') -> None:
        """
        Sets the address of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param address: The address of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: ExternalContactsUnresolvedContactChangedTopicContactAddress
        """
        

        self._address = address

    @property
    def survey_opt_out(self) -> bool:
        """
        Gets the survey_opt_out of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The survey_opt_out of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: bool
        """
        return self._survey_opt_out

    @survey_opt_out.setter
    def survey_opt_out(self, survey_opt_out: bool) -> None:
        """
        Sets the survey_opt_out of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param survey_opt_out: The survey_opt_out of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: bool
        """
        

        self._survey_opt_out = survey_opt_out

    @property
    def external_system_url(self) -> str:
        """
        Gets the external_system_url of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The external_system_url of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: str
        """
        return self._external_system_url

    @external_system_url.setter
    def external_system_url(self, external_system_url: str) -> None:
        """
        Sets the external_system_url of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param external_system_url: The external_system_url of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: str
        """
        

        self._external_system_url = external_system_url

    @property
    def twitter_id(self) -> 'ExternalContactsUnresolvedContactChangedTopicTwitterId':
        """
        Gets the twitter_id of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The twitter_id of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: ExternalContactsUnresolvedContactChangedTopicTwitterId
        """
        return self._twitter_id

    @twitter_id.setter
    def twitter_id(self, twitter_id: 'ExternalContactsUnresolvedContactChangedTopicTwitterId') -> None:
        """
        Sets the twitter_id of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param twitter_id: The twitter_id of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: ExternalContactsUnresolvedContactChangedTopicTwitterId
        """
        

        self._twitter_id = twitter_id

    @property
    def line_id(self) -> 'ExternalContactsUnresolvedContactChangedTopicLineId':
        """
        Gets the line_id of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The line_id of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: ExternalContactsUnresolvedContactChangedTopicLineId
        """
        return self._line_id

    @line_id.setter
    def line_id(self, line_id: 'ExternalContactsUnresolvedContactChangedTopicLineId') -> None:
        """
        Sets the line_id of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param line_id: The line_id of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: ExternalContactsUnresolvedContactChangedTopicLineId
        """
        

        self._line_id = line_id

    @property
    def whats_app_id(self) -> 'ExternalContactsUnresolvedContactChangedTopicWhatsAppId':
        """
        Gets the whats_app_id of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The whats_app_id of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: ExternalContactsUnresolvedContactChangedTopicWhatsAppId
        """
        return self._whats_app_id

    @whats_app_id.setter
    def whats_app_id(self, whats_app_id: 'ExternalContactsUnresolvedContactChangedTopicWhatsAppId') -> None:
        """
        Sets the whats_app_id of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param whats_app_id: The whats_app_id of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: ExternalContactsUnresolvedContactChangedTopicWhatsAppId
        """
        

        self._whats_app_id = whats_app_id

    @property
    def facebook_id(self) -> 'ExternalContactsUnresolvedContactChangedTopicFacebookId':
        """
        Gets the facebook_id of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The facebook_id of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: ExternalContactsUnresolvedContactChangedTopicFacebookId
        """
        return self._facebook_id

    @facebook_id.setter
    def facebook_id(self, facebook_id: 'ExternalContactsUnresolvedContactChangedTopicFacebookId') -> None:
        """
        Sets the facebook_id of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param facebook_id: The facebook_id of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: ExternalContactsUnresolvedContactChangedTopicFacebookId
        """
        

        self._facebook_id = facebook_id

    @property
    def instagram_id(self) -> 'ExternalContactsUnresolvedContactChangedTopicInstagramId':
        """
        Gets the instagram_id of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The instagram_id of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: ExternalContactsUnresolvedContactChangedTopicInstagramId
        """
        return self._instagram_id

    @instagram_id.setter
    def instagram_id(self, instagram_id: 'ExternalContactsUnresolvedContactChangedTopicInstagramId') -> None:
        """
        Sets the instagram_id of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param instagram_id: The instagram_id of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: ExternalContactsUnresolvedContactChangedTopicInstagramId
        """
        

        self._instagram_id = instagram_id

    @property
    def external_ids(self) -> List['ExternalContactsUnresolvedContactChangedTopicExternalId']:
        """
        Gets the external_ids of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The external_ids of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: list[ExternalContactsUnresolvedContactChangedTopicExternalId]
        """
        return self._external_ids

    @external_ids.setter
    def external_ids(self, external_ids: List['ExternalContactsUnresolvedContactChangedTopicExternalId']) -> None:
        """
        Sets the external_ids of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param external_ids: The external_ids of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: list[ExternalContactsUnresolvedContactChangedTopicExternalId]
        """
        

        self._external_ids = external_ids

    @property
    def canonical_contact_id(self) -> str:
        """
        Gets the canonical_contact_id of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The canonical_contact_id of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: str
        """
        return self._canonical_contact_id

    @canonical_contact_id.setter
    def canonical_contact_id(self, canonical_contact_id: str) -> None:
        """
        Sets the canonical_contact_id of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param canonical_contact_id: The canonical_contact_id of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: str
        """
        

        self._canonical_contact_id = canonical_contact_id

    @property
    def schema(self) -> 'ExternalContactsUnresolvedContactChangedTopicDataSchema':
        """
        Gets the schema of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The schema of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: ExternalContactsUnresolvedContactChangedTopicDataSchema
        """
        return self._schema

    @schema.setter
    def schema(self, schema: 'ExternalContactsUnresolvedContactChangedTopicDataSchema') -> None:
        """
        Sets the schema of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param schema: The schema of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: ExternalContactsUnresolvedContactChangedTopicDataSchema
        """
        

        self._schema = schema

    @property
    def custom_fields(self) -> Dict[str, object]:
        """
        Gets the custom_fields of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The custom_fields of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: dict(str, object)
        """
        return self._custom_fields

    @custom_fields.setter
    def custom_fields(self, custom_fields: Dict[str, object]) -> None:
        """
        Sets the custom_fields of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param custom_fields: The custom_fields of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: dict(str, object)
        """
        

        self._custom_fields = custom_fields

    @property
    def merge_set(self) -> List[str]:
        """
        Gets the merge_set of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The merge_set of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: list[str]
        """
        return self._merge_set

    @merge_set.setter
    def merge_set(self, merge_set: List[str]) -> None:
        """
        Sets the merge_set of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param merge_set: The merge_set of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: list[str]
        """
        

        self._merge_set = merge_set

    @property
    def merged_from(self) -> List[str]:
        """
        Gets the merged_from of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The merged_from of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: list[str]
        """
        return self._merged_from

    @merged_from.setter
    def merged_from(self, merged_from: List[str]) -> None:
        """
        Sets the merged_from of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param merged_from: The merged_from of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: list[str]
        """
        

        self._merged_from = merged_from

    @property
    def merged_to(self) -> str:
        """
        Gets the merged_to of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The merged_to of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: str
        """
        return self._merged_to

    @merged_to.setter
    def merged_to(self, merged_to: str) -> None:
        """
        Sets the merged_to of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param merged_to: The merged_to of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: str
        """
        

        self._merged_to = merged_to

    @property
    def merge_operation(self) -> 'ExternalContactsUnresolvedContactChangedTopicMergeOperation':
        """
        Gets the merge_operation of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The merge_operation of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: ExternalContactsUnresolvedContactChangedTopicMergeOperation
        """
        return self._merge_operation

    @merge_operation.setter
    def merge_operation(self, merge_operation: 'ExternalContactsUnresolvedContactChangedTopicMergeOperation') -> None:
        """
        Sets the merge_operation of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param merge_operation: The merge_operation of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: ExternalContactsUnresolvedContactChangedTopicMergeOperation
        """
        

        self._merge_operation = merge_operation

    @property
    def create_date(self) -> datetime:
        """
        Gets the create_date of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The create_date of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: datetime
        """
        return self._create_date

    @create_date.setter
    def create_date(self, create_date: datetime) -> None:
        """
        Sets the create_date of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param create_date: The create_date of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: datetime
        """
        

        self._create_date = create_date

    @property
    def modify_date(self) -> datetime:
        """
        Gets the modify_date of this ExternalContactsUnresolvedContactChangedTopicContact.


        :return: The modify_date of this ExternalContactsUnresolvedContactChangedTopicContact.
        :rtype: datetime
        """
        return self._modify_date

    @modify_date.setter
    def modify_date(self, modify_date: datetime) -> None:
        """
        Sets the modify_date of this ExternalContactsUnresolvedContactChangedTopicContact.


        :param modify_date: The modify_date of this ExternalContactsUnresolvedContactChangedTopicContact.
        :type: datetime
        """
        

        self._modify_date = modify_date

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

