# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ExternalContactsRelationshipChangedTopicDivision
    from . import ExternalContactsRelationshipChangedTopicExternalOrganization
    from . import ExternalContactsRelationshipChangedTopicUser

class ExternalContactsRelationshipChangedTopicRelationship(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ExternalContactsRelationshipChangedTopicRelationship - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'division': 'ExternalContactsRelationshipChangedTopicDivision',
            'user': 'ExternalContactsRelationshipChangedTopicUser',
            'external_organization': 'ExternalContactsRelationshipChangedTopicExternalOrganization',
            'relationship': 'str',
            'create_date': 'datetime',
            'modify_date': 'datetime'
        }

        self.attribute_map = {
            'id': 'id',
            'division': 'division',
            'user': 'user',
            'external_organization': 'externalOrganization',
            'relationship': 'relationship',
            'create_date': 'createDate',
            'modify_date': 'modifyDate'
        }

        self._id = None
        self._division = None
        self._user = None
        self._external_organization = None
        self._relationship = None
        self._create_date = None
        self._modify_date = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ExternalContactsRelationshipChangedTopicRelationship.


        :return: The id of this ExternalContactsRelationshipChangedTopicRelationship.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ExternalContactsRelationshipChangedTopicRelationship.


        :param id: The id of this ExternalContactsRelationshipChangedTopicRelationship.
        :type: str
        """
        

        self._id = id

    @property
    def division(self) -> 'ExternalContactsRelationshipChangedTopicDivision':
        """
        Gets the division of this ExternalContactsRelationshipChangedTopicRelationship.


        :return: The division of this ExternalContactsRelationshipChangedTopicRelationship.
        :rtype: ExternalContactsRelationshipChangedTopicDivision
        """
        return self._division

    @division.setter
    def division(self, division: 'ExternalContactsRelationshipChangedTopicDivision') -> None:
        """
        Sets the division of this ExternalContactsRelationshipChangedTopicRelationship.


        :param division: The division of this ExternalContactsRelationshipChangedTopicRelationship.
        :type: ExternalContactsRelationshipChangedTopicDivision
        """
        

        self._division = division

    @property
    def user(self) -> 'ExternalContactsRelationshipChangedTopicUser':
        """
        Gets the user of this ExternalContactsRelationshipChangedTopicRelationship.


        :return: The user of this ExternalContactsRelationshipChangedTopicRelationship.
        :rtype: ExternalContactsRelationshipChangedTopicUser
        """
        return self._user

    @user.setter
    def user(self, user: 'ExternalContactsRelationshipChangedTopicUser') -> None:
        """
        Sets the user of this ExternalContactsRelationshipChangedTopicRelationship.


        :param user: The user of this ExternalContactsRelationshipChangedTopicRelationship.
        :type: ExternalContactsRelationshipChangedTopicUser
        """
        

        self._user = user

    @property
    def external_organization(self) -> 'ExternalContactsRelationshipChangedTopicExternalOrganization':
        """
        Gets the external_organization of this ExternalContactsRelationshipChangedTopicRelationship.


        :return: The external_organization of this ExternalContactsRelationshipChangedTopicRelationship.
        :rtype: ExternalContactsRelationshipChangedTopicExternalOrganization
        """
        return self._external_organization

    @external_organization.setter
    def external_organization(self, external_organization: 'ExternalContactsRelationshipChangedTopicExternalOrganization') -> None:
        """
        Sets the external_organization of this ExternalContactsRelationshipChangedTopicRelationship.


        :param external_organization: The external_organization of this ExternalContactsRelationshipChangedTopicRelationship.
        :type: ExternalContactsRelationshipChangedTopicExternalOrganization
        """
        

        self._external_organization = external_organization

    @property
    def relationship(self) -> str:
        """
        Gets the relationship of this ExternalContactsRelationshipChangedTopicRelationship.


        :return: The relationship of this ExternalContactsRelationshipChangedTopicRelationship.
        :rtype: str
        """
        return self._relationship

    @relationship.setter
    def relationship(self, relationship: str) -> None:
        """
        Sets the relationship of this ExternalContactsRelationshipChangedTopicRelationship.


        :param relationship: The relationship of this ExternalContactsRelationshipChangedTopicRelationship.
        :type: str
        """
        

        self._relationship = relationship

    @property
    def create_date(self) -> datetime:
        """
        Gets the create_date of this ExternalContactsRelationshipChangedTopicRelationship.


        :return: The create_date of this ExternalContactsRelationshipChangedTopicRelationship.
        :rtype: datetime
        """
        return self._create_date

    @create_date.setter
    def create_date(self, create_date: datetime) -> None:
        """
        Sets the create_date of this ExternalContactsRelationshipChangedTopicRelationship.


        :param create_date: The create_date of this ExternalContactsRelationshipChangedTopicRelationship.
        :type: datetime
        """
        

        self._create_date = create_date

    @property
    def modify_date(self) -> datetime:
        """
        Gets the modify_date of this ExternalContactsRelationshipChangedTopicRelationship.


        :return: The modify_date of this ExternalContactsRelationshipChangedTopicRelationship.
        :rtype: datetime
        """
        return self._modify_date

    @modify_date.setter
    def modify_date(self, modify_date: datetime) -> None:
        """
        Sets the modify_date of this ExternalContactsRelationshipChangedTopicRelationship.


        :param modify_date: The modify_date of this ExternalContactsRelationshipChangedTopicRelationship.
        :type: datetime
        """
        

        self._modify_date = modify_date

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

