# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import SupportedContentReference
    from . import WebDeploymentConfigurationVersionResponse
    from . import WebDeploymentFlowEntityRef

class ExpandableWebDeployment(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ExpandableWebDeployment - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'allow_all_domains': 'bool',
            'allowed_domains': 'list[str]',
            'supported_content': 'SupportedContentReference',
            'snippet': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'last_modified_user': 'AddressableEntityRef',
            'flow': 'WebDeploymentFlowEntityRef',
            'status': 'str',
            'configuration': 'WebDeploymentConfigurationVersionResponse',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'allow_all_domains': 'allowAllDomains',
            'allowed_domains': 'allowedDomains',
            'supported_content': 'supportedContent',
            'snippet': 'snippet',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'last_modified_user': 'lastModifiedUser',
            'flow': 'flow',
            'status': 'status',
            'configuration': 'configuration',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._description = None
        self._allow_all_domains = None
        self._allowed_domains = None
        self._supported_content = None
        self._snippet = None
        self._date_created = None
        self._date_modified = None
        self._last_modified_user = None
        self._flow = None
        self._status = None
        self._configuration = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ExpandableWebDeployment.
        The deployment ID

        :return: The id of this ExpandableWebDeployment.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ExpandableWebDeployment.
        The deployment ID

        :param id: The id of this ExpandableWebDeployment.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this ExpandableWebDeployment.
        The deployment name

        :return: The name of this ExpandableWebDeployment.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this ExpandableWebDeployment.
        The deployment name

        :param name: The name of this ExpandableWebDeployment.
        :type: str
        """
        

        self._name = name

    @property
    def description(self) -> str:
        """
        Gets the description of this ExpandableWebDeployment.
        The description of the config

        :return: The description of this ExpandableWebDeployment.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this ExpandableWebDeployment.
        The description of the config

        :param description: The description of this ExpandableWebDeployment.
        :type: str
        """
        

        self._description = description

    @property
    def allow_all_domains(self) -> bool:
        """
        Gets the allow_all_domains of this ExpandableWebDeployment.
        Property indicates whether all domains are allowed or not. allowedDomains must be empty when this is set as true.

        :return: The allow_all_domains of this ExpandableWebDeployment.
        :rtype: bool
        """
        return self._allow_all_domains

    @allow_all_domains.setter
    def allow_all_domains(self, allow_all_domains: bool) -> None:
        """
        Sets the allow_all_domains of this ExpandableWebDeployment.
        Property indicates whether all domains are allowed or not. allowedDomains must be empty when this is set as true.

        :param allow_all_domains: The allow_all_domains of this ExpandableWebDeployment.
        :type: bool
        """
        

        self._allow_all_domains = allow_all_domains

    @property
    def allowed_domains(self) -> List[str]:
        """
        Gets the allowed_domains of this ExpandableWebDeployment.
        The list of domains that are approved to use this deployment; the list will be added to CORS headers for ease of web use.

        :return: The allowed_domains of this ExpandableWebDeployment.
        :rtype: list[str]
        """
        return self._allowed_domains

    @allowed_domains.setter
    def allowed_domains(self, allowed_domains: List[str]) -> None:
        """
        Sets the allowed_domains of this ExpandableWebDeployment.
        The list of domains that are approved to use this deployment; the list will be added to CORS headers for ease of web use.

        :param allowed_domains: The allowed_domains of this ExpandableWebDeployment.
        :type: list[str]
        """
        

        self._allowed_domains = allowed_domains

    @property
    def supported_content(self) -> 'SupportedContentReference':
        """
        Gets the supported_content of this ExpandableWebDeployment.
        The supported content profile for a deployment

        :return: The supported_content of this ExpandableWebDeployment.
        :rtype: SupportedContentReference
        """
        return self._supported_content

    @supported_content.setter
    def supported_content(self, supported_content: 'SupportedContentReference') -> None:
        """
        Sets the supported_content of this ExpandableWebDeployment.
        The supported content profile for a deployment

        :param supported_content: The supported_content of this ExpandableWebDeployment.
        :type: SupportedContentReference
        """
        

        self._supported_content = supported_content

    @property
    def snippet(self) -> str:
        """
        Gets the snippet of this ExpandableWebDeployment.
        Javascript snippet used to load the config

        :return: The snippet of this ExpandableWebDeployment.
        :rtype: str
        """
        return self._snippet

    @snippet.setter
    def snippet(self, snippet: str) -> None:
        """
        Sets the snippet of this ExpandableWebDeployment.
        Javascript snippet used to load the config

        :param snippet: The snippet of this ExpandableWebDeployment.
        :type: str
        """
        

        self._snippet = snippet

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this ExpandableWebDeployment.
        The date the deployment was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this ExpandableWebDeployment.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this ExpandableWebDeployment.
        The date the deployment was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this ExpandableWebDeployment.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this ExpandableWebDeployment.
        The date the deployment was most recently modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this ExpandableWebDeployment.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this ExpandableWebDeployment.
        The date the deployment was most recently modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this ExpandableWebDeployment.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def last_modified_user(self) -> 'AddressableEntityRef':
        """
        Gets the last_modified_user of this ExpandableWebDeployment.
        A reference to the user who most recently modified the deployment

        :return: The last_modified_user of this ExpandableWebDeployment.
        :rtype: AddressableEntityRef
        """
        return self._last_modified_user

    @last_modified_user.setter
    def last_modified_user(self, last_modified_user: 'AddressableEntityRef') -> None:
        """
        Sets the last_modified_user of this ExpandableWebDeployment.
        A reference to the user who most recently modified the deployment

        :param last_modified_user: The last_modified_user of this ExpandableWebDeployment.
        :type: AddressableEntityRef
        """
        

        self._last_modified_user = last_modified_user

    @property
    def flow(self) -> 'WebDeploymentFlowEntityRef':
        """
        Gets the flow of this ExpandableWebDeployment.
        A reference to the inboundshortmessage flow used by this deployment

        :return: The flow of this ExpandableWebDeployment.
        :rtype: WebDeploymentFlowEntityRef
        """
        return self._flow

    @flow.setter
    def flow(self, flow: 'WebDeploymentFlowEntityRef') -> None:
        """
        Sets the flow of this ExpandableWebDeployment.
        A reference to the inboundshortmessage flow used by this deployment

        :param flow: The flow of this ExpandableWebDeployment.
        :type: WebDeploymentFlowEntityRef
        """
        

        self._flow = flow

    @property
    def status(self) -> str:
        """
        Gets the status of this ExpandableWebDeployment.
        The current status of the deployment

        :return: The status of this ExpandableWebDeployment.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this ExpandableWebDeployment.
        The current status of the deployment

        :param status: The status of this ExpandableWebDeployment.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Pending", "Active", "Inactive", "Error", "Deleting"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def configuration(self) -> 'WebDeploymentConfigurationVersionResponse':
        """
        Gets the configuration of this ExpandableWebDeployment.
        The config version this deployment uses

        :return: The configuration of this ExpandableWebDeployment.
        :rtype: WebDeploymentConfigurationVersionResponse
        """
        return self._configuration

    @configuration.setter
    def configuration(self, configuration: 'WebDeploymentConfigurationVersionResponse') -> None:
        """
        Sets the configuration of this ExpandableWebDeployment.
        The config version this deployment uses

        :param configuration: The configuration of this ExpandableWebDeployment.
        :type: WebDeploymentConfigurationVersionResponse
        """
        

        self._configuration = configuration

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this ExpandableWebDeployment.
        The URI for this object

        :return: The self_uri of this ExpandableWebDeployment.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this ExpandableWebDeployment.
        The URI for this object

        :param self_uri: The self_uri of this ExpandableWebDeployment.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

