# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import DomainEntityRef
    from . import UserReference

class ExecutionDataGlobalSettingsResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ExecutionDataGlobalSettingsResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'enabled': 'bool',
            'modified_by': 'UserReference',
            'modified_by_client': 'DomainEntityRef',
            'date_modified': 'datetime',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'enabled': 'enabled',
            'modified_by': 'modifiedBy',
            'modified_by_client': 'modifiedByClient',
            'date_modified': 'dateModified',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._enabled = None
        self._modified_by = None
        self._modified_by_client = None
        self._date_modified = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ExecutionDataGlobalSettingsResponse.
        The globally unique identifier for the object.

        :return: The id of this ExecutionDataGlobalSettingsResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ExecutionDataGlobalSettingsResponse.
        The globally unique identifier for the object.

        :param id: The id of this ExecutionDataGlobalSettingsResponse.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this ExecutionDataGlobalSettingsResponse.


        :return: The name of this ExecutionDataGlobalSettingsResponse.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this ExecutionDataGlobalSettingsResponse.


        :param name: The name of this ExecutionDataGlobalSettingsResponse.
        :type: str
        """
        

        self._name = name

    @property
    def enabled(self) -> bool:
        """
        Gets the enabled of this ExecutionDataGlobalSettingsResponse.
        whether or not the setting is enabled.

        :return: The enabled of this ExecutionDataGlobalSettingsResponse.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled: bool) -> None:
        """
        Sets the enabled of this ExecutionDataGlobalSettingsResponse.
        whether or not the setting is enabled.

        :param enabled: The enabled of this ExecutionDataGlobalSettingsResponse.
        :type: bool
        """
        

        self._enabled = enabled

    @property
    def modified_by(self) -> 'UserReference':
        """
        Gets the modified_by of this ExecutionDataGlobalSettingsResponse.
        User that last changed the setting.

        :return: The modified_by of this ExecutionDataGlobalSettingsResponse.
        :rtype: UserReference
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by: 'UserReference') -> None:
        """
        Sets the modified_by of this ExecutionDataGlobalSettingsResponse.
        User that last changed the setting.

        :param modified_by: The modified_by of this ExecutionDataGlobalSettingsResponse.
        :type: UserReference
        """
        

        self._modified_by = modified_by

    @property
    def modified_by_client(self) -> 'DomainEntityRef':
        """
        Gets the modified_by_client of this ExecutionDataGlobalSettingsResponse.
        OAuth client that last changed the setting.

        :return: The modified_by_client of this ExecutionDataGlobalSettingsResponse.
        :rtype: DomainEntityRef
        """
        return self._modified_by_client

    @modified_by_client.setter
    def modified_by_client(self, modified_by_client: 'DomainEntityRef') -> None:
        """
        Sets the modified_by_client of this ExecutionDataGlobalSettingsResponse.
        OAuth client that last changed the setting.

        :param modified_by_client: The modified_by_client of this ExecutionDataGlobalSettingsResponse.
        :type: DomainEntityRef
        """
        

        self._modified_by_client = modified_by_client

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this ExecutionDataGlobalSettingsResponse.
        The time this setting was set. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this ExecutionDataGlobalSettingsResponse.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this ExecutionDataGlobalSettingsResponse.
        The time this setting was set. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this ExecutionDataGlobalSettingsResponse.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this ExecutionDataGlobalSettingsResponse.
        The URI for this object

        :return: The self_uri of this ExecutionDataGlobalSettingsResponse.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this ExecutionDataGlobalSettingsResponse.
        The URI for this object

        :param self_uri: The self_uri of this ExecutionDataGlobalSettingsResponse.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

