# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class ExecutionDataEntity(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ExecutionDataEntity - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'download_uri': 'str',
            'failed': 'bool',
            'status_code': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'download_uri': 'downloadUri',
            'failed': 'failed',
            'status_code': 'statusCode'
        }

        self._id = None
        self._download_uri = None
        self._failed = None
        self._status_code = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ExecutionDataEntity.
        The id of the execution requested

        :return: The id of this ExecutionDataEntity.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ExecutionDataEntity.
        The id of the execution requested

        :param id: The id of this ExecutionDataEntity.
        :type: str
        """
        

        self._id = id

    @property
    def download_uri(self) -> str:
        """
        Gets the download_uri of this ExecutionDataEntity.
        A downloadable link to the execution data file.

        :return: The download_uri of this ExecutionDataEntity.
        :rtype: str
        """
        return self._download_uri

    @download_uri.setter
    def download_uri(self, download_uri: str) -> None:
        """
        Sets the download_uri of this ExecutionDataEntity.
        A downloadable link to the execution data file.

        :param download_uri: The download_uri of this ExecutionDataEntity.
        :type: str
        """
        

        self._download_uri = download_uri

    @property
    def failed(self) -> bool:
        """
        Gets the failed of this ExecutionDataEntity.
        If the retrieval failed (not found, no permission, etc;), this will be set true.

        :return: The failed of this ExecutionDataEntity.
        :rtype: bool
        """
        return self._failed

    @failed.setter
    def failed(self, failed: bool) -> None:
        """
        Sets the failed of this ExecutionDataEntity.
        If the retrieval failed (not found, no permission, etc;), this will be set true.

        :param failed: The failed of this ExecutionDataEntity.
        :type: bool
        """
        

        self._failed = failed

    @property
    def status_code(self) -> str:
        """
        Gets the status_code of this ExecutionDataEntity.
        This will contain the http status code for the failure

        :return: The status_code of this ExecutionDataEntity.
        :rtype: str
        """
        return self._status_code

    @status_code.setter
    def status_code(self, status_code: str) -> None:
        """
        Sets the status_code of this ExecutionDataEntity.
        This will contain the http status code for the failure

        :param status_code: The status_code of this ExecutionDataEntity.
        :type: str
        """
        

        self._status_code = status_code

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

