# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AppEvent
    from . import EventSession
    from . import OutcomeAchievedEvent
    from . import SegmentAssignmentEvent
    from . import WebActionEvent
    from . import WebEvent

class Event(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        Event - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'correlation_id': 'str',
            'customer_id': 'str',
            'customer_id_type': 'str',
            'session': 'EventSession',
            'event_type': 'str',
            'outcome_achieved_event': 'OutcomeAchievedEvent',
            'segment_assignment_event': 'SegmentAssignmentEvent',
            'web_action_event': 'WebActionEvent',
            'web_event': 'WebEvent',
            'app_event': 'AppEvent',
            'created_date': 'datetime'
        }

        self.attribute_map = {
            'id': 'id',
            'correlation_id': 'correlationId',
            'customer_id': 'customerId',
            'customer_id_type': 'customerIdType',
            'session': 'session',
            'event_type': 'eventType',
            'outcome_achieved_event': 'outcomeAchievedEvent',
            'segment_assignment_event': 'segmentAssignmentEvent',
            'web_action_event': 'webActionEvent',
            'web_event': 'webEvent',
            'app_event': 'appEvent',
            'created_date': 'createdDate'
        }

        self._id = None
        self._correlation_id = None
        self._customer_id = None
        self._customer_id_type = None
        self._session = None
        self._event_type = None
        self._outcome_achieved_event = None
        self._segment_assignment_event = None
        self._web_action_event = None
        self._web_event = None
        self._app_event = None
        self._created_date = None

    @property
    def id(self) -> str:
        """
        Gets the id of this Event.
        System-generated UUID for the event.

        :return: The id of this Event.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this Event.
        System-generated UUID for the event.

        :param id: The id of this Event.
        :type: str
        """
        

        self._id = id

    @property
    def correlation_id(self) -> str:
        """
        Gets the correlation_id of this Event.
        UUID corresponding to triggering action that caused this event (e.g. HTTP POST, SIP invite, another event).

        :return: The correlation_id of this Event.
        :rtype: str
        """
        return self._correlation_id

    @correlation_id.setter
    def correlation_id(self, correlation_id: str) -> None:
        """
        Sets the correlation_id of this Event.
        UUID corresponding to triggering action that caused this event (e.g. HTTP POST, SIP invite, another event).

        :param correlation_id: The correlation_id of this Event.
        :type: str
        """
        

        self._correlation_id = correlation_id

    @property
    def customer_id(self) -> str:
        """
        Gets the customer_id of this Event.
        Primary identifier of the customer in the source of the events.

        :return: The customer_id of this Event.
        :rtype: str
        """
        return self._customer_id

    @customer_id.setter
    def customer_id(self, customer_id: str) -> None:
        """
        Sets the customer_id of this Event.
        Primary identifier of the customer in the source of the events.

        :param customer_id: The customer_id of this Event.
        :type: str
        """
        

        self._customer_id = customer_id

    @property
    def customer_id_type(self) -> str:
        """
        Gets the customer_id_type of this Event.
        Type of primary identifier (e.g. cookie, email, phone).

        :return: The customer_id_type of this Event.
        :rtype: str
        """
        return self._customer_id_type

    @customer_id_type.setter
    def customer_id_type(self, customer_id_type: str) -> None:
        """
        Sets the customer_id_type of this Event.
        Type of primary identifier (e.g. cookie, email, phone).

        :param customer_id_type: The customer_id_type of this Event.
        :type: str
        """
        

        self._customer_id_type = customer_id_type

    @property
    def session(self) -> 'EventSession':
        """
        Gets the session of this Event.
        The session that the event belongs to.

        :return: The session of this Event.
        :rtype: EventSession
        """
        return self._session

    @session.setter
    def session(self, session: 'EventSession') -> None:
        """
        Sets the session of this Event.
        The session that the event belongs to.

        :param session: The session of this Event.
        :type: EventSession
        """
        

        self._session = session

    @property
    def event_type(self) -> str:
        """
        Gets the event_type of this Event.
        The name representing the type of event.

        :return: The event_type of this Event.
        :rtype: str
        """
        return self._event_type

    @event_type.setter
    def event_type(self, event_type: str) -> None:
        """
        Sets the event_type of this Event.
        The name representing the type of event.

        :param event_type: The event_type of this Event.
        :type: str
        """
        

        self._event_type = event_type

    @property
    def outcome_achieved_event(self) -> 'OutcomeAchievedEvent':
        """
        Gets the outcome_achieved_event of this Event.
        Event where a customer has achieved a specific outcome or goal.

        :return: The outcome_achieved_event of this Event.
        :rtype: OutcomeAchievedEvent
        """
        return self._outcome_achieved_event

    @outcome_achieved_event.setter
    def outcome_achieved_event(self, outcome_achieved_event: 'OutcomeAchievedEvent') -> None:
        """
        Sets the outcome_achieved_event of this Event.
        Event where a customer has achieved a specific outcome or goal.

        :param outcome_achieved_event: The outcome_achieved_event of this Event.
        :type: OutcomeAchievedEvent
        """
        

        self._outcome_achieved_event = outcome_achieved_event

    @property
    def segment_assignment_event(self) -> 'SegmentAssignmentEvent':
        """
        Gets the segment_assignment_event of this Event.
        Event that represents a segment being assigned.

        :return: The segment_assignment_event of this Event.
        :rtype: SegmentAssignmentEvent
        """
        return self._segment_assignment_event

    @segment_assignment_event.setter
    def segment_assignment_event(self, segment_assignment_event: 'SegmentAssignmentEvent') -> None:
        """
        Sets the segment_assignment_event of this Event.
        Event that represents a segment being assigned.

        :param segment_assignment_event: The segment_assignment_event of this Event.
        :type: SegmentAssignmentEvent
        """
        

        self._segment_assignment_event = segment_assignment_event

    @property
    def web_action_event(self) -> 'WebActionEvent':
        """
        Gets the web_action_event of this Event.
        Event triggered by web actions.

        :return: The web_action_event of this Event.
        :rtype: WebActionEvent
        """
        return self._web_action_event

    @web_action_event.setter
    def web_action_event(self, web_action_event: 'WebActionEvent') -> None:
        """
        Sets the web_action_event of this Event.
        Event triggered by web actions.

        :param web_action_event: The web_action_event of this Event.
        :type: WebActionEvent
        """
        

        self._web_action_event = web_action_event

    @property
    def web_event(self) -> 'WebEvent':
        """
        Gets the web_event of this Event.
        Event that tracks user interactions with content in a browser such as pageviews, downloads, mobile ad clicks, etc.

        :return: The web_event of this Event.
        :rtype: WebEvent
        """
        return self._web_event

    @web_event.setter
    def web_event(self, web_event: 'WebEvent') -> None:
        """
        Sets the web_event of this Event.
        Event that tracks user interactions with content in a browser such as pageviews, downloads, mobile ad clicks, etc.

        :param web_event: The web_event of this Event.
        :type: WebEvent
        """
        

        self._web_event = web_event

    @property
    def app_event(self) -> 'AppEvent':
        """
        Gets the app_event of this Event.
        Event that tracks user interactions with content in an application such as screen views, searches, etc.

        :return: The app_event of this Event.
        :rtype: AppEvent
        """
        return self._app_event

    @app_event.setter
    def app_event(self, app_event: 'AppEvent') -> None:
        """
        Sets the app_event of this Event.
        Event that tracks user interactions with content in an application such as screen views, searches, etc.

        :param app_event: The app_event of this Event.
        :type: AppEvent
        """
        

        self._app_event = app_event

    @property
    def created_date(self) -> datetime:
        """
        Gets the created_date of this Event.
        Timestamp indicating when the event actually took place. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The created_date of this Event.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date: datetime) -> None:
        """
        Sets the created_date of this Event.
        Timestamp indicating when the event actually took place. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param created_date: The created_date of this Event.
        :type: datetime
        """
        

        self._created_date = created_date

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

