# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import EvaluationSettingsAssignee

class EvaluationSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        EvaluationSettings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'revisions_enabled': 'bool',
            'disputes_enabled': 'bool',
            'disputes_allowed_per_evaluation': 'int',
            'disputes_assignees': 'list[EvaluationSettingsAssignee]'
        }

        self.attribute_map = {
            'revisions_enabled': 'revisionsEnabled',
            'disputes_enabled': 'disputesEnabled',
            'disputes_allowed_per_evaluation': 'disputesAllowedPerEvaluation',
            'disputes_assignees': 'disputesAssignees'
        }

        self._revisions_enabled = None
        self._disputes_enabled = None
        self._disputes_allowed_per_evaluation = None
        self._disputes_assignees = None

    @property
    def revisions_enabled(self) -> bool:
        """
        Gets the revisions_enabled of this EvaluationSettings.
        Whether revisions are allowed for evaluations. When enabled, rescoring creates a new version of the evaluation and retracts the existing evaluation version. Does not apply for calibration evaluations.

        :return: The revisions_enabled of this EvaluationSettings.
        :rtype: bool
        """
        return self._revisions_enabled

    @revisions_enabled.setter
    def revisions_enabled(self, revisions_enabled: bool) -> None:
        """
        Sets the revisions_enabled of this EvaluationSettings.
        Whether revisions are allowed for evaluations. When enabled, rescoring creates a new version of the evaluation and retracts the existing evaluation version. Does not apply for calibration evaluations.

        :param revisions_enabled: The revisions_enabled of this EvaluationSettings.
        :type: bool
        """
        

        self._revisions_enabled = revisions_enabled

    @property
    def disputes_enabled(self) -> bool:
        """
        Gets the disputes_enabled of this EvaluationSettings.
        Whether disputes are allowed for evaluations. Does not apply for calibration evaluations.

        :return: The disputes_enabled of this EvaluationSettings.
        :rtype: bool
        """
        return self._disputes_enabled

    @disputes_enabled.setter
    def disputes_enabled(self, disputes_enabled: bool) -> None:
        """
        Sets the disputes_enabled of this EvaluationSettings.
        Whether disputes are allowed for evaluations. Does not apply for calibration evaluations.

        :param disputes_enabled: The disputes_enabled of this EvaluationSettings.
        :type: bool
        """
        

        self._disputes_enabled = disputes_enabled

    @property
    def disputes_allowed_per_evaluation(self) -> int:
        """
        Gets the disputes_allowed_per_evaluation of this EvaluationSettings.
        The maximum number of disputes allowed for an evaluation.

        :return: The disputes_allowed_per_evaluation of this EvaluationSettings.
        :rtype: int
        """
        return self._disputes_allowed_per_evaluation

    @disputes_allowed_per_evaluation.setter
    def disputes_allowed_per_evaluation(self, disputes_allowed_per_evaluation: int) -> None:
        """
        Sets the disputes_allowed_per_evaluation of this EvaluationSettings.
        The maximum number of disputes allowed for an evaluation.

        :param disputes_allowed_per_evaluation: The disputes_allowed_per_evaluation of this EvaluationSettings.
        :type: int
        """
        

        self._disputes_allowed_per_evaluation = disputes_allowed_per_evaluation

    @property
    def disputes_assignees(self) -> List['EvaluationSettingsAssignee']:
        """
        Gets the disputes_assignees of this EvaluationSettings.
        A list of assignees responsible for handling each dispute. This list size needs to be equal to disputesAllowedPerEvaluation.

        :return: The disputes_assignees of this EvaluationSettings.
        :rtype: list[EvaluationSettingsAssignee]
        """
        return self._disputes_assignees

    @disputes_assignees.setter
    def disputes_assignees(self, disputes_assignees: List['EvaluationSettingsAssignee']) -> None:
        """
        Sets the disputes_assignees of this EvaluationSettings.
        A list of assignees responsible for handling each dispute. This list size needs to be equal to disputesAllowedPerEvaluation.

        :param disputes_assignees: The disputes_assignees of this EvaluationSettings.
        :type: list[EvaluationSettingsAssignee]
        """
        

        self._disputes_assignees = disputes_assignees

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

