# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import EvaluationQuestionScore

class EvaluationQuestionGroupScore(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        EvaluationQuestionGroupScore - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'question_group_id': 'str',
            'total_score': 'float',
            'max_total_score': 'float',
            'marked_na': 'bool',
            'system_marked_na': 'bool',
            'total_critical_score': 'float',
            'max_total_critical_score': 'float',
            'total_non_critical_score': 'float',
            'max_total_non_critical_score': 'float',
            'total_score_unweighted': 'float',
            'max_total_score_unweighted': 'float',
            'total_critical_score_unweighted': 'float',
            'max_total_critical_score_unweighted': 'float',
            'total_non_critical_score_unweighted': 'float',
            'max_total_non_critical_score_unweighted': 'float',
            'question_scores': 'list[EvaluationQuestionScore]'
        }

        self.attribute_map = {
            'question_group_id': 'questionGroupId',
            'total_score': 'totalScore',
            'max_total_score': 'maxTotalScore',
            'marked_na': 'markedNA',
            'system_marked_na': 'systemMarkedNA',
            'total_critical_score': 'totalCriticalScore',
            'max_total_critical_score': 'maxTotalCriticalScore',
            'total_non_critical_score': 'totalNonCriticalScore',
            'max_total_non_critical_score': 'maxTotalNonCriticalScore',
            'total_score_unweighted': 'totalScoreUnweighted',
            'max_total_score_unweighted': 'maxTotalScoreUnweighted',
            'total_critical_score_unweighted': 'totalCriticalScoreUnweighted',
            'max_total_critical_score_unweighted': 'maxTotalCriticalScoreUnweighted',
            'total_non_critical_score_unweighted': 'totalNonCriticalScoreUnweighted',
            'max_total_non_critical_score_unweighted': 'maxTotalNonCriticalScoreUnweighted',
            'question_scores': 'questionScores'
        }

        self._question_group_id = None
        self._total_score = None
        self._max_total_score = None
        self._marked_na = None
        self._system_marked_na = None
        self._total_critical_score = None
        self._max_total_critical_score = None
        self._total_non_critical_score = None
        self._max_total_non_critical_score = None
        self._total_score_unweighted = None
        self._max_total_score_unweighted = None
        self._total_critical_score_unweighted = None
        self._max_total_critical_score_unweighted = None
        self._total_non_critical_score_unweighted = None
        self._max_total_non_critical_score_unweighted = None
        self._question_scores = None

    @property
    def question_group_id(self) -> str:
        """
        Gets the question_group_id of this EvaluationQuestionGroupScore.


        :return: The question_group_id of this EvaluationQuestionGroupScore.
        :rtype: str
        """
        return self._question_group_id

    @question_group_id.setter
    def question_group_id(self, question_group_id: str) -> None:
        """
        Sets the question_group_id of this EvaluationQuestionGroupScore.


        :param question_group_id: The question_group_id of this EvaluationQuestionGroupScore.
        :type: str
        """
        

        self._question_group_id = question_group_id

    @property
    def total_score(self) -> float:
        """
        Gets the total_score of this EvaluationQuestionGroupScore.
        Score of all questions in the group

        :return: The total_score of this EvaluationQuestionGroupScore.
        :rtype: float
        """
        return self._total_score

    @total_score.setter
    def total_score(self, total_score: float) -> None:
        """
        Sets the total_score of this EvaluationQuestionGroupScore.
        Score of all questions in the group

        :param total_score: The total_score of this EvaluationQuestionGroupScore.
        :type: float
        """
        

        self._total_score = total_score

    @property
    def max_total_score(self) -> float:
        """
        Gets the max_total_score of this EvaluationQuestionGroupScore.
        Maximum possible score of all questions in the group

        :return: The max_total_score of this EvaluationQuestionGroupScore.
        :rtype: float
        """
        return self._max_total_score

    @max_total_score.setter
    def max_total_score(self, max_total_score: float) -> None:
        """
        Sets the max_total_score of this EvaluationQuestionGroupScore.
        Maximum possible score of all questions in the group

        :param max_total_score: The max_total_score of this EvaluationQuestionGroupScore.
        :type: float
        """
        

        self._max_total_score = max_total_score

    @property
    def marked_na(self) -> bool:
        """
        Gets the marked_na of this EvaluationQuestionGroupScore.
        True when the evaluation is submitted with a question group that does not have any answers. Only allowed when naEnabled is true or if set by the system

        :return: The marked_na of this EvaluationQuestionGroupScore.
        :rtype: bool
        """
        return self._marked_na

    @marked_na.setter
    def marked_na(self, marked_na: bool) -> None:
        """
        Sets the marked_na of this EvaluationQuestionGroupScore.
        True when the evaluation is submitted with a question group that does not have any answers. Only allowed when naEnabled is true or if set by the system

        :param marked_na: The marked_na of this EvaluationQuestionGroupScore.
        :type: bool
        """
        

        self._marked_na = marked_na

    @property
    def system_marked_na(self) -> bool:
        """
        Gets the system_marked_na of this EvaluationQuestionGroupScore.
        If markedNA is true, systemMarkedNA indicates whether it was marked by a user or by the system due to visibility conditions. Always false if markedNA is false.

        :return: The system_marked_na of this EvaluationQuestionGroupScore.
        :rtype: bool
        """
        return self._system_marked_na

    @system_marked_na.setter
    def system_marked_na(self, system_marked_na: bool) -> None:
        """
        Sets the system_marked_na of this EvaluationQuestionGroupScore.
        If markedNA is true, systemMarkedNA indicates whether it was marked by a user or by the system due to visibility conditions. Always false if markedNA is false.

        :param system_marked_na: The system_marked_na of this EvaluationQuestionGroupScore.
        :type: bool
        """
        

        self._system_marked_na = system_marked_na

    @property
    def total_critical_score(self) -> float:
        """
        Gets the total_critical_score of this EvaluationQuestionGroupScore.
        Score of only the critical questions in the group

        :return: The total_critical_score of this EvaluationQuestionGroupScore.
        :rtype: float
        """
        return self._total_critical_score

    @total_critical_score.setter
    def total_critical_score(self, total_critical_score: float) -> None:
        """
        Sets the total_critical_score of this EvaluationQuestionGroupScore.
        Score of only the critical questions in the group

        :param total_critical_score: The total_critical_score of this EvaluationQuestionGroupScore.
        :type: float
        """
        

        self._total_critical_score = total_critical_score

    @property
    def max_total_critical_score(self) -> float:
        """
        Gets the max_total_critical_score of this EvaluationQuestionGroupScore.
        Maximum possible score of only the critical questions in the group

        :return: The max_total_critical_score of this EvaluationQuestionGroupScore.
        :rtype: float
        """
        return self._max_total_critical_score

    @max_total_critical_score.setter
    def max_total_critical_score(self, max_total_critical_score: float) -> None:
        """
        Sets the max_total_critical_score of this EvaluationQuestionGroupScore.
        Maximum possible score of only the critical questions in the group

        :param max_total_critical_score: The max_total_critical_score of this EvaluationQuestionGroupScore.
        :type: float
        """
        

        self._max_total_critical_score = max_total_critical_score

    @property
    def total_non_critical_score(self) -> float:
        """
        Gets the total_non_critical_score of this EvaluationQuestionGroupScore.
        Score of only the non critical questions in the group

        :return: The total_non_critical_score of this EvaluationQuestionGroupScore.
        :rtype: float
        """
        return self._total_non_critical_score

    @total_non_critical_score.setter
    def total_non_critical_score(self, total_non_critical_score: float) -> None:
        """
        Sets the total_non_critical_score of this EvaluationQuestionGroupScore.
        Score of only the non critical questions in the group

        :param total_non_critical_score: The total_non_critical_score of this EvaluationQuestionGroupScore.
        :type: float
        """
        

        self._total_non_critical_score = total_non_critical_score

    @property
    def max_total_non_critical_score(self) -> float:
        """
        Gets the max_total_non_critical_score of this EvaluationQuestionGroupScore.
        Maximum possible score of only the non critical questions in the group

        :return: The max_total_non_critical_score of this EvaluationQuestionGroupScore.
        :rtype: float
        """
        return self._max_total_non_critical_score

    @max_total_non_critical_score.setter
    def max_total_non_critical_score(self, max_total_non_critical_score: float) -> None:
        """
        Sets the max_total_non_critical_score of this EvaluationQuestionGroupScore.
        Maximum possible score of only the non critical questions in the group

        :param max_total_non_critical_score: The max_total_non_critical_score of this EvaluationQuestionGroupScore.
        :type: float
        """
        

        self._max_total_non_critical_score = max_total_non_critical_score

    @property
    def total_score_unweighted(self) -> float:
        """
        Gets the total_score_unweighted of this EvaluationQuestionGroupScore.
        Unweighted score of all questions in the group

        :return: The total_score_unweighted of this EvaluationQuestionGroupScore.
        :rtype: float
        """
        return self._total_score_unweighted

    @total_score_unweighted.setter
    def total_score_unweighted(self, total_score_unweighted: float) -> None:
        """
        Sets the total_score_unweighted of this EvaluationQuestionGroupScore.
        Unweighted score of all questions in the group

        :param total_score_unweighted: The total_score_unweighted of this EvaluationQuestionGroupScore.
        :type: float
        """
        

        self._total_score_unweighted = total_score_unweighted

    @property
    def max_total_score_unweighted(self) -> float:
        """
        Gets the max_total_score_unweighted of this EvaluationQuestionGroupScore.
        Maximum possible unweighted score of all questions in the group

        :return: The max_total_score_unweighted of this EvaluationQuestionGroupScore.
        :rtype: float
        """
        return self._max_total_score_unweighted

    @max_total_score_unweighted.setter
    def max_total_score_unweighted(self, max_total_score_unweighted: float) -> None:
        """
        Sets the max_total_score_unweighted of this EvaluationQuestionGroupScore.
        Maximum possible unweighted score of all questions in the group

        :param max_total_score_unweighted: The max_total_score_unweighted of this EvaluationQuestionGroupScore.
        :type: float
        """
        

        self._max_total_score_unweighted = max_total_score_unweighted

    @property
    def total_critical_score_unweighted(self) -> float:
        """
        Gets the total_critical_score_unweighted of this EvaluationQuestionGroupScore.
        Unweighted score of only the critical questions in the group

        :return: The total_critical_score_unweighted of this EvaluationQuestionGroupScore.
        :rtype: float
        """
        return self._total_critical_score_unweighted

    @total_critical_score_unweighted.setter
    def total_critical_score_unweighted(self, total_critical_score_unweighted: float) -> None:
        """
        Sets the total_critical_score_unweighted of this EvaluationQuestionGroupScore.
        Unweighted score of only the critical questions in the group

        :param total_critical_score_unweighted: The total_critical_score_unweighted of this EvaluationQuestionGroupScore.
        :type: float
        """
        

        self._total_critical_score_unweighted = total_critical_score_unweighted

    @property
    def max_total_critical_score_unweighted(self) -> float:
        """
        Gets the max_total_critical_score_unweighted of this EvaluationQuestionGroupScore.
        Maximum possible unweighted score of only the critical questions in the group

        :return: The max_total_critical_score_unweighted of this EvaluationQuestionGroupScore.
        :rtype: float
        """
        return self._max_total_critical_score_unweighted

    @max_total_critical_score_unweighted.setter
    def max_total_critical_score_unweighted(self, max_total_critical_score_unweighted: float) -> None:
        """
        Sets the max_total_critical_score_unweighted of this EvaluationQuestionGroupScore.
        Maximum possible unweighted score of only the critical questions in the group

        :param max_total_critical_score_unweighted: The max_total_critical_score_unweighted of this EvaluationQuestionGroupScore.
        :type: float
        """
        

        self._max_total_critical_score_unweighted = max_total_critical_score_unweighted

    @property
    def total_non_critical_score_unweighted(self) -> float:
        """
        Gets the total_non_critical_score_unweighted of this EvaluationQuestionGroupScore.
        Unweighted score of only the non critical questions in the group

        :return: The total_non_critical_score_unweighted of this EvaluationQuestionGroupScore.
        :rtype: float
        """
        return self._total_non_critical_score_unweighted

    @total_non_critical_score_unweighted.setter
    def total_non_critical_score_unweighted(self, total_non_critical_score_unweighted: float) -> None:
        """
        Sets the total_non_critical_score_unweighted of this EvaluationQuestionGroupScore.
        Unweighted score of only the non critical questions in the group

        :param total_non_critical_score_unweighted: The total_non_critical_score_unweighted of this EvaluationQuestionGroupScore.
        :type: float
        """
        

        self._total_non_critical_score_unweighted = total_non_critical_score_unweighted

    @property
    def max_total_non_critical_score_unweighted(self) -> float:
        """
        Gets the max_total_non_critical_score_unweighted of this EvaluationQuestionGroupScore.
        Maximum possible unweighted score of only the non critical questions in the group

        :return: The max_total_non_critical_score_unweighted of this EvaluationQuestionGroupScore.
        :rtype: float
        """
        return self._max_total_non_critical_score_unweighted

    @max_total_non_critical_score_unweighted.setter
    def max_total_non_critical_score_unweighted(self, max_total_non_critical_score_unweighted: float) -> None:
        """
        Sets the max_total_non_critical_score_unweighted of this EvaluationQuestionGroupScore.
        Maximum possible unweighted score of only the non critical questions in the group

        :param max_total_non_critical_score_unweighted: The max_total_non_critical_score_unweighted of this EvaluationQuestionGroupScore.
        :type: float
        """
        

        self._max_total_non_critical_score_unweighted = max_total_non_critical_score_unweighted

    @property
    def question_scores(self) -> List['EvaluationQuestionScore']:
        """
        Gets the question_scores of this EvaluationQuestionGroupScore.


        :return: The question_scores of this EvaluationQuestionGroupScore.
        :rtype: list[EvaluationQuestionScore]
        """
        return self._question_scores

    @question_scores.setter
    def question_scores(self, question_scores: List['EvaluationQuestionScore']) -> None:
        """
        Sets the question_scores of this EvaluationQuestionGroupScore.


        :param question_scores: The question_scores of this EvaluationQuestionGroupScore.
        :type: list[EvaluationQuestionScore]
        """
        

        self._question_scores = question_scores

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

