# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import EvaluationQualityV2TopicCalibration
    from . import EvaluationQualityV2TopicEvaluationReference
    from . import EvaluationQualityV2TopicEvaluationScoringSet
    from . import EvaluationQualityV2TopicEvaluationSource
    from . import EvaluationQualityV2TopicUser

class EvaluationQualityV2TopicEvaluationV2(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        EvaluationQualityV2TopicEvaluationV2 - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'conversation_id': 'str',
            'agent': 'EvaluationQualityV2TopicUser',
            'evaluator': 'EvaluationQualityV2TopicUser',
            'event_time': 'datetime',
            'evaluation_form_id': 'str',
            'form_name': 'str',
            'scoring_set': 'EvaluationQualityV2TopicEvaluationScoringSet',
            'context_id': 'str',
            'status': 'str',
            'agent_has_read': 'bool',
            'release_date': 'datetime',
            'assigned_date': 'datetime',
            'changed_date': 'datetime',
            'event_type': 'str',
            'resource_id': 'str',
            'resource_type': 'str',
            'division_ids': 'list[str]',
            'rescore': 'bool',
            'conversation_date': 'datetime',
            'media_type': 'list[str]',
            'calibration': 'EvaluationQualityV2TopicCalibration',
            'evaluation_source': 'EvaluationQualityV2TopicEvaluationSource',
            'assignee_user_id': 'str',
            'previous_assignee_user_id': 'str',
            'assignee_applicable': 'bool',
            'evaluation_context_id': 'str',
            'dispute_count': 'int',
            'version': 'int',
            'previous_status': 'str',
            'declined_review': 'bool',
            'retracted_evaluation': 'EvaluationQualityV2TopicEvaluationReference',
            'rescore_count': 'int',
            'evaluator_comment_has_updated': 'bool',
            'agent_comment_has_updated': 'bool',
            'previous_rescore_count': 'int',
            'previous_evaluator_user_id': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'conversation_id': 'conversationId',
            'agent': 'agent',
            'evaluator': 'evaluator',
            'event_time': 'eventTime',
            'evaluation_form_id': 'evaluationFormId',
            'form_name': 'formName',
            'scoring_set': 'scoringSet',
            'context_id': 'contextId',
            'status': 'status',
            'agent_has_read': 'agentHasRead',
            'release_date': 'releaseDate',
            'assigned_date': 'assignedDate',
            'changed_date': 'changedDate',
            'event_type': 'eventType',
            'resource_id': 'resourceId',
            'resource_type': 'resourceType',
            'division_ids': 'divisionIds',
            'rescore': 'rescore',
            'conversation_date': 'conversationDate',
            'media_type': 'mediaType',
            'calibration': 'calibration',
            'evaluation_source': 'evaluationSource',
            'assignee_user_id': 'assigneeUserId',
            'previous_assignee_user_id': 'previousAssigneeUserId',
            'assignee_applicable': 'assigneeApplicable',
            'evaluation_context_id': 'evaluationContextId',
            'dispute_count': 'disputeCount',
            'version': 'version',
            'previous_status': 'previousStatus',
            'declined_review': 'declinedReview',
            'retracted_evaluation': 'retractedEvaluation',
            'rescore_count': 'rescoreCount',
            'evaluator_comment_has_updated': 'evaluatorCommentHasUpdated',
            'agent_comment_has_updated': 'agentCommentHasUpdated',
            'previous_rescore_count': 'previousRescoreCount',
            'previous_evaluator_user_id': 'previousEvaluatorUserId'
        }

        self._id = None
        self._conversation_id = None
        self._agent = None
        self._evaluator = None
        self._event_time = None
        self._evaluation_form_id = None
        self._form_name = None
        self._scoring_set = None
        self._context_id = None
        self._status = None
        self._agent_has_read = None
        self._release_date = None
        self._assigned_date = None
        self._changed_date = None
        self._event_type = None
        self._resource_id = None
        self._resource_type = None
        self._division_ids = None
        self._rescore = None
        self._conversation_date = None
        self._media_type = None
        self._calibration = None
        self._evaluation_source = None
        self._assignee_user_id = None
        self._previous_assignee_user_id = None
        self._assignee_applicable = None
        self._evaluation_context_id = None
        self._dispute_count = None
        self._version = None
        self._previous_status = None
        self._declined_review = None
        self._retracted_evaluation = None
        self._rescore_count = None
        self._evaluator_comment_has_updated = None
        self._agent_comment_has_updated = None
        self._previous_rescore_count = None
        self._previous_evaluator_user_id = None

    @property
    def id(self) -> str:
        """
        Gets the id of this EvaluationQualityV2TopicEvaluationV2.


        :return: The id of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this EvaluationQualityV2TopicEvaluationV2.


        :param id: The id of this EvaluationQualityV2TopicEvaluationV2.
        :type: str
        """
        

        self._id = id

    @property
    def conversation_id(self) -> str:
        """
        Gets the conversation_id of this EvaluationQualityV2TopicEvaluationV2.


        :return: The conversation_id of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: str
        """
        return self._conversation_id

    @conversation_id.setter
    def conversation_id(self, conversation_id: str) -> None:
        """
        Sets the conversation_id of this EvaluationQualityV2TopicEvaluationV2.


        :param conversation_id: The conversation_id of this EvaluationQualityV2TopicEvaluationV2.
        :type: str
        """
        

        self._conversation_id = conversation_id

    @property
    def agent(self) -> 'EvaluationQualityV2TopicUser':
        """
        Gets the agent of this EvaluationQualityV2TopicEvaluationV2.


        :return: The agent of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: EvaluationQualityV2TopicUser
        """
        return self._agent

    @agent.setter
    def agent(self, agent: 'EvaluationQualityV2TopicUser') -> None:
        """
        Sets the agent of this EvaluationQualityV2TopicEvaluationV2.


        :param agent: The agent of this EvaluationQualityV2TopicEvaluationV2.
        :type: EvaluationQualityV2TopicUser
        """
        

        self._agent = agent

    @property
    def evaluator(self) -> 'EvaluationQualityV2TopicUser':
        """
        Gets the evaluator of this EvaluationQualityV2TopicEvaluationV2.


        :return: The evaluator of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: EvaluationQualityV2TopicUser
        """
        return self._evaluator

    @evaluator.setter
    def evaluator(self, evaluator: 'EvaluationQualityV2TopicUser') -> None:
        """
        Sets the evaluator of this EvaluationQualityV2TopicEvaluationV2.


        :param evaluator: The evaluator of this EvaluationQualityV2TopicEvaluationV2.
        :type: EvaluationQualityV2TopicUser
        """
        

        self._evaluator = evaluator

    @property
    def event_time(self) -> datetime:
        """
        Gets the event_time of this EvaluationQualityV2TopicEvaluationV2.


        :return: The event_time of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: datetime
        """
        return self._event_time

    @event_time.setter
    def event_time(self, event_time: datetime) -> None:
        """
        Sets the event_time of this EvaluationQualityV2TopicEvaluationV2.


        :param event_time: The event_time of this EvaluationQualityV2TopicEvaluationV2.
        :type: datetime
        """
        

        self._event_time = event_time

    @property
    def evaluation_form_id(self) -> str:
        """
        Gets the evaluation_form_id of this EvaluationQualityV2TopicEvaluationV2.


        :return: The evaluation_form_id of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: str
        """
        return self._evaluation_form_id

    @evaluation_form_id.setter
    def evaluation_form_id(self, evaluation_form_id: str) -> None:
        """
        Sets the evaluation_form_id of this EvaluationQualityV2TopicEvaluationV2.


        :param evaluation_form_id: The evaluation_form_id of this EvaluationQualityV2TopicEvaluationV2.
        :type: str
        """
        

        self._evaluation_form_id = evaluation_form_id

    @property
    def form_name(self) -> str:
        """
        Gets the form_name of this EvaluationQualityV2TopicEvaluationV2.


        :return: The form_name of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: str
        """
        return self._form_name

    @form_name.setter
    def form_name(self, form_name: str) -> None:
        """
        Sets the form_name of this EvaluationQualityV2TopicEvaluationV2.


        :param form_name: The form_name of this EvaluationQualityV2TopicEvaluationV2.
        :type: str
        """
        

        self._form_name = form_name

    @property
    def scoring_set(self) -> 'EvaluationQualityV2TopicEvaluationScoringSet':
        """
        Gets the scoring_set of this EvaluationQualityV2TopicEvaluationV2.


        :return: The scoring_set of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: EvaluationQualityV2TopicEvaluationScoringSet
        """
        return self._scoring_set

    @scoring_set.setter
    def scoring_set(self, scoring_set: 'EvaluationQualityV2TopicEvaluationScoringSet') -> None:
        """
        Sets the scoring_set of this EvaluationQualityV2TopicEvaluationV2.


        :param scoring_set: The scoring_set of this EvaluationQualityV2TopicEvaluationV2.
        :type: EvaluationQualityV2TopicEvaluationScoringSet
        """
        

        self._scoring_set = scoring_set

    @property
    def context_id(self) -> str:
        """
        Gets the context_id of this EvaluationQualityV2TopicEvaluationV2.


        :return: The context_id of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: str
        """
        return self._context_id

    @context_id.setter
    def context_id(self, context_id: str) -> None:
        """
        Sets the context_id of this EvaluationQualityV2TopicEvaluationV2.


        :param context_id: The context_id of this EvaluationQualityV2TopicEvaluationV2.
        :type: str
        """
        

        self._context_id = context_id

    @property
    def status(self) -> str:
        """
        Gets the status of this EvaluationQualityV2TopicEvaluationV2.


        :return: The status of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this EvaluationQualityV2TopicEvaluationV2.


        :param status: The status of this EvaluationQualityV2TopicEvaluationV2.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Pending", "InProgress", "Finished", "InReview", "Retracted"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def agent_has_read(self) -> bool:
        """
        Gets the agent_has_read of this EvaluationQualityV2TopicEvaluationV2.


        :return: The agent_has_read of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: bool
        """
        return self._agent_has_read

    @agent_has_read.setter
    def agent_has_read(self, agent_has_read: bool) -> None:
        """
        Sets the agent_has_read of this EvaluationQualityV2TopicEvaluationV2.


        :param agent_has_read: The agent_has_read of this EvaluationQualityV2TopicEvaluationV2.
        :type: bool
        """
        

        self._agent_has_read = agent_has_read

    @property
    def release_date(self) -> datetime:
        """
        Gets the release_date of this EvaluationQualityV2TopicEvaluationV2.


        :return: The release_date of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: datetime
        """
        return self._release_date

    @release_date.setter
    def release_date(self, release_date: datetime) -> None:
        """
        Sets the release_date of this EvaluationQualityV2TopicEvaluationV2.


        :param release_date: The release_date of this EvaluationQualityV2TopicEvaluationV2.
        :type: datetime
        """
        

        self._release_date = release_date

    @property
    def assigned_date(self) -> datetime:
        """
        Gets the assigned_date of this EvaluationQualityV2TopicEvaluationV2.


        :return: The assigned_date of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: datetime
        """
        return self._assigned_date

    @assigned_date.setter
    def assigned_date(self, assigned_date: datetime) -> None:
        """
        Sets the assigned_date of this EvaluationQualityV2TopicEvaluationV2.


        :param assigned_date: The assigned_date of this EvaluationQualityV2TopicEvaluationV2.
        :type: datetime
        """
        

        self._assigned_date = assigned_date

    @property
    def changed_date(self) -> datetime:
        """
        Gets the changed_date of this EvaluationQualityV2TopicEvaluationV2.


        :return: The changed_date of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: datetime
        """
        return self._changed_date

    @changed_date.setter
    def changed_date(self, changed_date: datetime) -> None:
        """
        Sets the changed_date of this EvaluationQualityV2TopicEvaluationV2.


        :param changed_date: The changed_date of this EvaluationQualityV2TopicEvaluationV2.
        :type: datetime
        """
        

        self._changed_date = changed_date

    @property
    def event_type(self) -> str:
        """
        Gets the event_type of this EvaluationQualityV2TopicEvaluationV2.


        :return: The event_type of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: str
        """
        return self._event_type

    @event_type.setter
    def event_type(self, event_type: str) -> None:
        """
        Sets the event_type of this EvaluationQualityV2TopicEvaluationV2.


        :param event_type: The event_type of this EvaluationQualityV2TopicEvaluationV2.
        :type: str
        """
        

        self._event_type = event_type

    @property
    def resource_id(self) -> str:
        """
        Gets the resource_id of this EvaluationQualityV2TopicEvaluationV2.


        :return: The resource_id of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id: str) -> None:
        """
        Sets the resource_id of this EvaluationQualityV2TopicEvaluationV2.


        :param resource_id: The resource_id of this EvaluationQualityV2TopicEvaluationV2.
        :type: str
        """
        

        self._resource_id = resource_id

    @property
    def resource_type(self) -> str:
        """
        Gets the resource_type of this EvaluationQualityV2TopicEvaluationV2.


        :return: The resource_type of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type: str) -> None:
        """
        Sets the resource_type of this EvaluationQualityV2TopicEvaluationV2.


        :param resource_type: The resource_type of this EvaluationQualityV2TopicEvaluationV2.
        :type: str
        """
        

        self._resource_type = resource_type

    @property
    def division_ids(self) -> List[str]:
        """
        Gets the division_ids of this EvaluationQualityV2TopicEvaluationV2.


        :return: The division_ids of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: list[str]
        """
        return self._division_ids

    @division_ids.setter
    def division_ids(self, division_ids: List[str]) -> None:
        """
        Sets the division_ids of this EvaluationQualityV2TopicEvaluationV2.


        :param division_ids: The division_ids of this EvaluationQualityV2TopicEvaluationV2.
        :type: list[str]
        """
        

        self._division_ids = division_ids

    @property
    def rescore(self) -> bool:
        """
        Gets the rescore of this EvaluationQualityV2TopicEvaluationV2.


        :return: The rescore of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: bool
        """
        return self._rescore

    @rescore.setter
    def rescore(self, rescore: bool) -> None:
        """
        Sets the rescore of this EvaluationQualityV2TopicEvaluationV2.


        :param rescore: The rescore of this EvaluationQualityV2TopicEvaluationV2.
        :type: bool
        """
        

        self._rescore = rescore

    @property
    def conversation_date(self) -> datetime:
        """
        Gets the conversation_date of this EvaluationQualityV2TopicEvaluationV2.


        :return: The conversation_date of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: datetime
        """
        return self._conversation_date

    @conversation_date.setter
    def conversation_date(self, conversation_date: datetime) -> None:
        """
        Sets the conversation_date of this EvaluationQualityV2TopicEvaluationV2.


        :param conversation_date: The conversation_date of this EvaluationQualityV2TopicEvaluationV2.
        :type: datetime
        """
        

        self._conversation_date = conversation_date

    @property
    def media_type(self) -> List[str]:
        """
        Gets the media_type of this EvaluationQualityV2TopicEvaluationV2.


        :return: The media_type of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: list[str]
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type: List[str]) -> None:
        """
        Sets the media_type of this EvaluationQualityV2TopicEvaluationV2.


        :param media_type: The media_type of this EvaluationQualityV2TopicEvaluationV2.
        :type: list[str]
        """
        

        self._media_type = media_type

    @property
    def calibration(self) -> 'EvaluationQualityV2TopicCalibration':
        """
        Gets the calibration of this EvaluationQualityV2TopicEvaluationV2.


        :return: The calibration of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: EvaluationQualityV2TopicCalibration
        """
        return self._calibration

    @calibration.setter
    def calibration(self, calibration: 'EvaluationQualityV2TopicCalibration') -> None:
        """
        Sets the calibration of this EvaluationQualityV2TopicEvaluationV2.


        :param calibration: The calibration of this EvaluationQualityV2TopicEvaluationV2.
        :type: EvaluationQualityV2TopicCalibration
        """
        

        self._calibration = calibration

    @property
    def evaluation_source(self) -> 'EvaluationQualityV2TopicEvaluationSource':
        """
        Gets the evaluation_source of this EvaluationQualityV2TopicEvaluationV2.


        :return: The evaluation_source of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: EvaluationQualityV2TopicEvaluationSource
        """
        return self._evaluation_source

    @evaluation_source.setter
    def evaluation_source(self, evaluation_source: 'EvaluationQualityV2TopicEvaluationSource') -> None:
        """
        Sets the evaluation_source of this EvaluationQualityV2TopicEvaluationV2.


        :param evaluation_source: The evaluation_source of this EvaluationQualityV2TopicEvaluationV2.
        :type: EvaluationQualityV2TopicEvaluationSource
        """
        

        self._evaluation_source = evaluation_source

    @property
    def assignee_user_id(self) -> str:
        """
        Gets the assignee_user_id of this EvaluationQualityV2TopicEvaluationV2.


        :return: The assignee_user_id of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: str
        """
        return self._assignee_user_id

    @assignee_user_id.setter
    def assignee_user_id(self, assignee_user_id: str) -> None:
        """
        Sets the assignee_user_id of this EvaluationQualityV2TopicEvaluationV2.


        :param assignee_user_id: The assignee_user_id of this EvaluationQualityV2TopicEvaluationV2.
        :type: str
        """
        

        self._assignee_user_id = assignee_user_id

    @property
    def previous_assignee_user_id(self) -> str:
        """
        Gets the previous_assignee_user_id of this EvaluationQualityV2TopicEvaluationV2.


        :return: The previous_assignee_user_id of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: str
        """
        return self._previous_assignee_user_id

    @previous_assignee_user_id.setter
    def previous_assignee_user_id(self, previous_assignee_user_id: str) -> None:
        """
        Sets the previous_assignee_user_id of this EvaluationQualityV2TopicEvaluationV2.


        :param previous_assignee_user_id: The previous_assignee_user_id of this EvaluationQualityV2TopicEvaluationV2.
        :type: str
        """
        

        self._previous_assignee_user_id = previous_assignee_user_id

    @property
    def assignee_applicable(self) -> bool:
        """
        Gets the assignee_applicable of this EvaluationQualityV2TopicEvaluationV2.


        :return: The assignee_applicable of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: bool
        """
        return self._assignee_applicable

    @assignee_applicable.setter
    def assignee_applicable(self, assignee_applicable: bool) -> None:
        """
        Sets the assignee_applicable of this EvaluationQualityV2TopicEvaluationV2.


        :param assignee_applicable: The assignee_applicable of this EvaluationQualityV2TopicEvaluationV2.
        :type: bool
        """
        

        self._assignee_applicable = assignee_applicable

    @property
    def evaluation_context_id(self) -> str:
        """
        Gets the evaluation_context_id of this EvaluationQualityV2TopicEvaluationV2.


        :return: The evaluation_context_id of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: str
        """
        return self._evaluation_context_id

    @evaluation_context_id.setter
    def evaluation_context_id(self, evaluation_context_id: str) -> None:
        """
        Sets the evaluation_context_id of this EvaluationQualityV2TopicEvaluationV2.


        :param evaluation_context_id: The evaluation_context_id of this EvaluationQualityV2TopicEvaluationV2.
        :type: str
        """
        

        self._evaluation_context_id = evaluation_context_id

    @property
    def dispute_count(self) -> int:
        """
        Gets the dispute_count of this EvaluationQualityV2TopicEvaluationV2.


        :return: The dispute_count of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: int
        """
        return self._dispute_count

    @dispute_count.setter
    def dispute_count(self, dispute_count: int) -> None:
        """
        Sets the dispute_count of this EvaluationQualityV2TopicEvaluationV2.


        :param dispute_count: The dispute_count of this EvaluationQualityV2TopicEvaluationV2.
        :type: int
        """
        

        self._dispute_count = dispute_count

    @property
    def version(self) -> int:
        """
        Gets the version of this EvaluationQualityV2TopicEvaluationV2.


        :return: The version of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version: int) -> None:
        """
        Sets the version of this EvaluationQualityV2TopicEvaluationV2.


        :param version: The version of this EvaluationQualityV2TopicEvaluationV2.
        :type: int
        """
        

        self._version = version

    @property
    def previous_status(self) -> str:
        """
        Gets the previous_status of this EvaluationQualityV2TopicEvaluationV2.


        :return: The previous_status of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: str
        """
        return self._previous_status

    @previous_status.setter
    def previous_status(self, previous_status: str) -> None:
        """
        Sets the previous_status of this EvaluationQualityV2TopicEvaluationV2.


        :param previous_status: The previous_status of this EvaluationQualityV2TopicEvaluationV2.
        :type: str
        """
        if isinstance(previous_status, int):
            previous_status = str(previous_status)
        allowed_values = ["Pending", "InProgress", "Finished", "InReview", "Retracted"]
        if previous_status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for previous_status -> " + previous_status)
            self._previous_status = "outdated_sdk_version"
        else:
            self._previous_status = previous_status

    @property
    def declined_review(self) -> bool:
        """
        Gets the declined_review of this EvaluationQualityV2TopicEvaluationV2.


        :return: The declined_review of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: bool
        """
        return self._declined_review

    @declined_review.setter
    def declined_review(self, declined_review: bool) -> None:
        """
        Sets the declined_review of this EvaluationQualityV2TopicEvaluationV2.


        :param declined_review: The declined_review of this EvaluationQualityV2TopicEvaluationV2.
        :type: bool
        """
        

        self._declined_review = declined_review

    @property
    def retracted_evaluation(self) -> 'EvaluationQualityV2TopicEvaluationReference':
        """
        Gets the retracted_evaluation of this EvaluationQualityV2TopicEvaluationV2.


        :return: The retracted_evaluation of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: EvaluationQualityV2TopicEvaluationReference
        """
        return self._retracted_evaluation

    @retracted_evaluation.setter
    def retracted_evaluation(self, retracted_evaluation: 'EvaluationQualityV2TopicEvaluationReference') -> None:
        """
        Sets the retracted_evaluation of this EvaluationQualityV2TopicEvaluationV2.


        :param retracted_evaluation: The retracted_evaluation of this EvaluationQualityV2TopicEvaluationV2.
        :type: EvaluationQualityV2TopicEvaluationReference
        """
        

        self._retracted_evaluation = retracted_evaluation

    @property
    def rescore_count(self) -> int:
        """
        Gets the rescore_count of this EvaluationQualityV2TopicEvaluationV2.


        :return: The rescore_count of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: int
        """
        return self._rescore_count

    @rescore_count.setter
    def rescore_count(self, rescore_count: int) -> None:
        """
        Sets the rescore_count of this EvaluationQualityV2TopicEvaluationV2.


        :param rescore_count: The rescore_count of this EvaluationQualityV2TopicEvaluationV2.
        :type: int
        """
        

        self._rescore_count = rescore_count

    @property
    def evaluator_comment_has_updated(self) -> bool:
        """
        Gets the evaluator_comment_has_updated of this EvaluationQualityV2TopicEvaluationV2.


        :return: The evaluator_comment_has_updated of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: bool
        """
        return self._evaluator_comment_has_updated

    @evaluator_comment_has_updated.setter
    def evaluator_comment_has_updated(self, evaluator_comment_has_updated: bool) -> None:
        """
        Sets the evaluator_comment_has_updated of this EvaluationQualityV2TopicEvaluationV2.


        :param evaluator_comment_has_updated: The evaluator_comment_has_updated of this EvaluationQualityV2TopicEvaluationV2.
        :type: bool
        """
        

        self._evaluator_comment_has_updated = evaluator_comment_has_updated

    @property
    def agent_comment_has_updated(self) -> bool:
        """
        Gets the agent_comment_has_updated of this EvaluationQualityV2TopicEvaluationV2.


        :return: The agent_comment_has_updated of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: bool
        """
        return self._agent_comment_has_updated

    @agent_comment_has_updated.setter
    def agent_comment_has_updated(self, agent_comment_has_updated: bool) -> None:
        """
        Sets the agent_comment_has_updated of this EvaluationQualityV2TopicEvaluationV2.


        :param agent_comment_has_updated: The agent_comment_has_updated of this EvaluationQualityV2TopicEvaluationV2.
        :type: bool
        """
        

        self._agent_comment_has_updated = agent_comment_has_updated

    @property
    def previous_rescore_count(self) -> int:
        """
        Gets the previous_rescore_count of this EvaluationQualityV2TopicEvaluationV2.


        :return: The previous_rescore_count of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: int
        """
        return self._previous_rescore_count

    @previous_rescore_count.setter
    def previous_rescore_count(self, previous_rescore_count: int) -> None:
        """
        Sets the previous_rescore_count of this EvaluationQualityV2TopicEvaluationV2.


        :param previous_rescore_count: The previous_rescore_count of this EvaluationQualityV2TopicEvaluationV2.
        :type: int
        """
        

        self._previous_rescore_count = previous_rescore_count

    @property
    def previous_evaluator_user_id(self) -> str:
        """
        Gets the previous_evaluator_user_id of this EvaluationQualityV2TopicEvaluationV2.


        :return: The previous_evaluator_user_id of this EvaluationQualityV2TopicEvaluationV2.
        :rtype: str
        """
        return self._previous_evaluator_user_id

    @previous_evaluator_user_id.setter
    def previous_evaluator_user_id(self, previous_evaluator_user_id: str) -> None:
        """
        Sets the previous_evaluator_user_id of this EvaluationQualityV2TopicEvaluationV2.


        :param previous_evaluator_user_id: The previous_evaluator_user_id of this EvaluationQualityV2TopicEvaluationV2.
        :type: str
        """
        

        self._previous_evaluator_user_id = previous_evaluator_user_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

