# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import EvaluationCreateCalibration
    from . import EvaluationCreateConversation
    from . import EvaluationCreateEvalForm
    from . import EvaluationCreateQueue
    from . import EvaluationCreateUser
    from . import EvaluationScoringSet
    from . import EvaluationSource

class EvaluationCreateBody(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        EvaluationCreateBody - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'evaluation_form': 'EvaluationCreateEvalForm',
            'evaluator': 'EvaluationCreateUser',
            'agent': 'EvaluationCreateUser',
            'agent_has_read': 'bool',
            'answers': 'EvaluationScoringSet',
            'calibration': 'EvaluationCreateCalibration',
            'evaluation_context_id': 'str',
            'conversation': 'EvaluationCreateConversation',
            'resource_type': 'str',
            'evaluation_source': 'EvaluationSource',
            'rescore': 'bool',
            'queue': 'EvaluationCreateQueue',
            'release_date': 'datetime',
            'status': 'str',
            'never_release': 'bool',
            'date_assignee_changed': 'datetime',
            'assignee': 'EvaluationCreateUser',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'evaluation_form': 'evaluationForm',
            'evaluator': 'evaluator',
            'agent': 'agent',
            'agent_has_read': 'agentHasRead',
            'answers': 'answers',
            'calibration': 'calibration',
            'evaluation_context_id': 'evaluationContextId',
            'conversation': 'conversation',
            'resource_type': 'resourceType',
            'evaluation_source': 'evaluationSource',
            'rescore': 'rescore',
            'queue': 'queue',
            'release_date': 'releaseDate',
            'status': 'status',
            'never_release': 'neverRelease',
            'date_assignee_changed': 'dateAssigneeChanged',
            'assignee': 'assignee',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._evaluation_form = None
        self._evaluator = None
        self._agent = None
        self._agent_has_read = None
        self._answers = None
        self._calibration = None
        self._evaluation_context_id = None
        self._conversation = None
        self._resource_type = None
        self._evaluation_source = None
        self._rescore = None
        self._queue = None
        self._release_date = None
        self._status = None
        self._never_release = None
        self._date_assignee_changed = None
        self._assignee = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this EvaluationCreateBody.
        The globally unique identifier for the object.

        :return: The id of this EvaluationCreateBody.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this EvaluationCreateBody.
        The globally unique identifier for the object.

        :param id: The id of this EvaluationCreateBody.
        :type: str
        """
        

        self._id = id

    @property
    def evaluation_form(self) -> 'EvaluationCreateEvalForm':
        """
        Gets the evaluation_form of this EvaluationCreateBody.
        Evaluation form used for evaluation (must be included for a successful request)

        :return: The evaluation_form of this EvaluationCreateBody.
        :rtype: EvaluationCreateEvalForm
        """
        return self._evaluation_form

    @evaluation_form.setter
    def evaluation_form(self, evaluation_form: 'EvaluationCreateEvalForm') -> None:
        """
        Sets the evaluation_form of this EvaluationCreateBody.
        Evaluation form used for evaluation (must be included for a successful request)

        :param evaluation_form: The evaluation_form of this EvaluationCreateBody.
        :type: EvaluationCreateEvalForm
        """
        

        self._evaluation_form = evaluation_form

    @property
    def evaluator(self) -> 'EvaluationCreateUser':
        """
        Gets the evaluator of this EvaluationCreateBody.
        User ID of the evaluator (must be included for a successful request)

        :return: The evaluator of this EvaluationCreateBody.
        :rtype: EvaluationCreateUser
        """
        return self._evaluator

    @evaluator.setter
    def evaluator(self, evaluator: 'EvaluationCreateUser') -> None:
        """
        Sets the evaluator of this EvaluationCreateBody.
        User ID of the evaluator (must be included for a successful request)

        :param evaluator: The evaluator of this EvaluationCreateBody.
        :type: EvaluationCreateUser
        """
        

        self._evaluator = evaluator

    @property
    def agent(self) -> 'EvaluationCreateUser':
        """
        Gets the agent of this EvaluationCreateBody.
        User ID of the agent (must be included for a successful request)

        :return: The agent of this EvaluationCreateBody.
        :rtype: EvaluationCreateUser
        """
        return self._agent

    @agent.setter
    def agent(self, agent: 'EvaluationCreateUser') -> None:
        """
        Sets the agent of this EvaluationCreateBody.
        User ID of the agent (must be included for a successful request)

        :param agent: The agent of this EvaluationCreateBody.
        :type: EvaluationCreateUser
        """
        

        self._agent = agent

    @property
    def agent_has_read(self) -> bool:
        """
        Gets the agent_has_read of this EvaluationCreateBody.


        :return: The agent_has_read of this EvaluationCreateBody.
        :rtype: bool
        """
        return self._agent_has_read

    @agent_has_read.setter
    def agent_has_read(self, agent_has_read: bool) -> None:
        """
        Sets the agent_has_read of this EvaluationCreateBody.


        :param agent_has_read: The agent_has_read of this EvaluationCreateBody.
        :type: bool
        """
        

        self._agent_has_read = agent_has_read

    @property
    def answers(self) -> 'EvaluationScoringSet':
        """
        Gets the answers of this EvaluationCreateBody.


        :return: The answers of this EvaluationCreateBody.
        :rtype: EvaluationScoringSet
        """
        return self._answers

    @answers.setter
    def answers(self, answers: 'EvaluationScoringSet') -> None:
        """
        Sets the answers of this EvaluationCreateBody.


        :param answers: The answers of this EvaluationCreateBody.
        :type: EvaluationScoringSet
        """
        

        self._answers = answers

    @property
    def calibration(self) -> 'EvaluationCreateCalibration':
        """
        Gets the calibration of this EvaluationCreateBody.


        :return: The calibration of this EvaluationCreateBody.
        :rtype: EvaluationCreateCalibration
        """
        return self._calibration

    @calibration.setter
    def calibration(self, calibration: 'EvaluationCreateCalibration') -> None:
        """
        Sets the calibration of this EvaluationCreateBody.


        :param calibration: The calibration of this EvaluationCreateBody.
        :type: EvaluationCreateCalibration
        """
        

        self._calibration = calibration

    @property
    def evaluation_context_id(self) -> str:
        """
        Gets the evaluation_context_id of this EvaluationCreateBody.


        :return: The evaluation_context_id of this EvaluationCreateBody.
        :rtype: str
        """
        return self._evaluation_context_id

    @evaluation_context_id.setter
    def evaluation_context_id(self, evaluation_context_id: str) -> None:
        """
        Sets the evaluation_context_id of this EvaluationCreateBody.


        :param evaluation_context_id: The evaluation_context_id of this EvaluationCreateBody.
        :type: str
        """
        

        self._evaluation_context_id = evaluation_context_id

    @property
    def conversation(self) -> 'EvaluationCreateConversation':
        """
        Gets the conversation of this EvaluationCreateBody.


        :return: The conversation of this EvaluationCreateBody.
        :rtype: EvaluationCreateConversation
        """
        return self._conversation

    @conversation.setter
    def conversation(self, conversation: 'EvaluationCreateConversation') -> None:
        """
        Sets the conversation of this EvaluationCreateBody.


        :param conversation: The conversation of this EvaluationCreateBody.
        :type: EvaluationCreateConversation
        """
        

        self._conversation = conversation

    @property
    def resource_type(self) -> str:
        """
        Gets the resource_type of this EvaluationCreateBody.


        :return: The resource_type of this EvaluationCreateBody.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type: str) -> None:
        """
        Sets the resource_type of this EvaluationCreateBody.


        :param resource_type: The resource_type of this EvaluationCreateBody.
        :type: str
        """
        if isinstance(resource_type, int):
            resource_type = str(resource_type)
        allowed_values = ["EMAIL"]
        if resource_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for resource_type -> " + resource_type)
            self._resource_type = "outdated_sdk_version"
        else:
            self._resource_type = resource_type

    @property
    def evaluation_source(self) -> 'EvaluationSource':
        """
        Gets the evaluation_source of this EvaluationCreateBody.


        :return: The evaluation_source of this EvaluationCreateBody.
        :rtype: EvaluationSource
        """
        return self._evaluation_source

    @evaluation_source.setter
    def evaluation_source(self, evaluation_source: 'EvaluationSource') -> None:
        """
        Sets the evaluation_source of this EvaluationCreateBody.


        :param evaluation_source: The evaluation_source of this EvaluationCreateBody.
        :type: EvaluationSource
        """
        

        self._evaluation_source = evaluation_source

    @property
    def rescore(self) -> bool:
        """
        Gets the rescore of this EvaluationCreateBody.


        :return: The rescore of this EvaluationCreateBody.
        :rtype: bool
        """
        return self._rescore

    @rescore.setter
    def rescore(self, rescore: bool) -> None:
        """
        Sets the rescore of this EvaluationCreateBody.


        :param rescore: The rescore of this EvaluationCreateBody.
        :type: bool
        """
        

        self._rescore = rescore

    @property
    def queue(self) -> 'EvaluationCreateQueue':
        """
        Gets the queue of this EvaluationCreateBody.


        :return: The queue of this EvaluationCreateBody.
        :rtype: EvaluationCreateQueue
        """
        return self._queue

    @queue.setter
    def queue(self, queue: 'EvaluationCreateQueue') -> None:
        """
        Sets the queue of this EvaluationCreateBody.


        :param queue: The queue of this EvaluationCreateBody.
        :type: EvaluationCreateQueue
        """
        

        self._queue = queue

    @property
    def release_date(self) -> datetime:
        """
        Gets the release_date of this EvaluationCreateBody.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The release_date of this EvaluationCreateBody.
        :rtype: datetime
        """
        return self._release_date

    @release_date.setter
    def release_date(self, release_date: datetime) -> None:
        """
        Sets the release_date of this EvaluationCreateBody.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param release_date: The release_date of this EvaluationCreateBody.
        :type: datetime
        """
        

        self._release_date = release_date

    @property
    def status(self) -> str:
        """
        Gets the status of this EvaluationCreateBody.


        :return: The status of this EvaluationCreateBody.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this EvaluationCreateBody.


        :param status: The status of this EvaluationCreateBody.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["PENDING", "INPROGRESS", "FINISHED", "INREVIEW", "RETRACTED"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def never_release(self) -> bool:
        """
        Gets the never_release of this EvaluationCreateBody.


        :return: The never_release of this EvaluationCreateBody.
        :rtype: bool
        """
        return self._never_release

    @never_release.setter
    def never_release(self, never_release: bool) -> None:
        """
        Sets the never_release of this EvaluationCreateBody.


        :param never_release: The never_release of this EvaluationCreateBody.
        :type: bool
        """
        

        self._never_release = never_release

    @property
    def date_assignee_changed(self) -> datetime:
        """
        Gets the date_assignee_changed of this EvaluationCreateBody.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_assignee_changed of this EvaluationCreateBody.
        :rtype: datetime
        """
        return self._date_assignee_changed

    @date_assignee_changed.setter
    def date_assignee_changed(self, date_assignee_changed: datetime) -> None:
        """
        Sets the date_assignee_changed of this EvaluationCreateBody.
        Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_assignee_changed: The date_assignee_changed of this EvaluationCreateBody.
        :type: datetime
        """
        

        self._date_assignee_changed = date_assignee_changed

    @property
    def assignee(self) -> 'EvaluationCreateUser':
        """
        Gets the assignee of this EvaluationCreateBody.


        :return: The assignee of this EvaluationCreateBody.
        :rtype: EvaluationCreateUser
        """
        return self._assignee

    @assignee.setter
    def assignee(self, assignee: 'EvaluationCreateUser') -> None:
        """
        Sets the assignee of this EvaluationCreateBody.


        :param assignee: The assignee of this EvaluationCreateBody.
        :type: EvaluationCreateUser
        """
        

        self._assignee = assignee

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this EvaluationCreateBody.
        The URI for this object

        :return: The self_uri of this EvaluationCreateBody.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this EvaluationCreateBody.
        The URI for this object

        :param self_uri: The self_uri of this EvaluationCreateBody.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

