# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import OverrideEscalationTarget

class EscalationTarget(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        EscalationTarget - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'target_type': 'str',
            'destination': 'str',
            'override': 'OverrideEscalationTarget'
        }

        self.attribute_map = {
            'target_type': 'targetType',
            'destination': 'destination',
            'override': 'override'
        }

        self._target_type = None
        self._destination = None
        self._override = None

    @property
    def target_type(self) -> str:
        """
        Gets the target_type of this EscalationTarget.
        Defines the target that the message will be escalated to.

        :return: The target_type of this EscalationTarget.
        :rtype: str
        """
        return self._target_type

    @target_type.setter
    def target_type(self, target_type: str) -> None:
        """
        Sets the target_type of this EscalationTarget.
        Defines the target that the message will be escalated to.

        :param target_type: The target_type of this EscalationTarget.
        :type: str
        """
        if isinstance(target_type, int):
            target_type = str(target_type)
        allowed_values = ["Conversation"]
        if target_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for target_type -> " + target_type)
            self._target_type = "outdated_sdk_version"
        else:
            self._target_type = target_type

    @property
    def destination(self) -> str:
        """
        Gets the destination of this EscalationTarget.
        Defines the destination of the escalation.SourceIntegration means use the SocialMedia Source Integration as the destination.OverrideIntegration means the set integration will be used regardless of the source.

        :return: The destination of this EscalationTarget.
        :rtype: str
        """
        return self._destination

    @destination.setter
    def destination(self, destination: str) -> None:
        """
        Sets the destination of this EscalationTarget.
        Defines the destination of the escalation.SourceIntegration means use the SocialMedia Source Integration as the destination.OverrideIntegration means the set integration will be used regardless of the source.

        :param destination: The destination of this EscalationTarget.
        :type: str
        """
        if isinstance(destination, int):
            destination = str(destination)
        allowed_values = ["SourceIntegration", "OverrideIntegration"]
        if destination.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for destination -> " + destination)
            self._destination = "outdated_sdk_version"
        else:
            self._destination = destination

    @property
    def override(self) -> 'OverrideEscalationTarget':
        """
        Gets the override of this EscalationTarget.
        Set the integration ID.Only valid when type is OverrideIntegration.

        :return: The override of this EscalationTarget.
        :rtype: OverrideEscalationTarget
        """
        return self._override

    @override.setter
    def override(self, override: 'OverrideEscalationTarget') -> None:
        """
        Sets the override of this EscalationTarget.
        Set the integration ID.Only valid when type is OverrideIntegration.

        :param override: The override of this EscalationTarget.
        :type: OverrideEscalationTarget
        """
        

        self._override = override

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

