# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import EscalationTarget

class EscalationRuleRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        EscalationRuleRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'match_criteria': 'str',
            'priority': 'int',
            'division_id': 'str',
            'description': 'str',
            'status': 'str',
            'open_escalation': 'EscalationTarget',
            'facebook_escalation': 'EscalationTarget',
            'instagram_escalation': 'EscalationTarget',
            'twitter_escalation': 'EscalationTarget'
        }

        self.attribute_map = {
            'name': 'name',
            'match_criteria': 'matchCriteria',
            'priority': 'priority',
            'division_id': 'divisionId',
            'description': 'description',
            'status': 'status',
            'open_escalation': 'openEscalation',
            'facebook_escalation': 'facebookEscalation',
            'instagram_escalation': 'instagramEscalation',
            'twitter_escalation': 'twitterEscalation'
        }

        self._name = None
        self._match_criteria = None
        self._priority = None
        self._division_id = None
        self._description = None
        self._status = None
        self._open_escalation = None
        self._facebook_escalation = None
        self._instagram_escalation = None
        self._twitter_escalation = None

    @property
    def name(self) -> str:
        """
        Gets the name of this EscalationRuleRequest.
        The name of the escalation rule.

        :return: The name of this EscalationRuleRequest.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this EscalationRuleRequest.
        The name of the escalation rule.

        :param name: The name of this EscalationRuleRequest.
        :type: str
        """
        

        self._name = name

    @property
    def match_criteria(self) -> str:
        """
        Gets the match_criteria of this EscalationRuleRequest.
        The criteria that defines when a social media message should be escalated.

        :return: The match_criteria of this EscalationRuleRequest.
        :rtype: str
        """
        return self._match_criteria

    @match_criteria.setter
    def match_criteria(self, match_criteria: str) -> None:
        """
        Sets the match_criteria of this EscalationRuleRequest.
        The criteria that defines when a social media message should be escalated.

        :param match_criteria: The match_criteria of this EscalationRuleRequest.
        :type: str
        """
        

        self._match_criteria = match_criteria

    @property
    def priority(self) -> int:
        """
        Gets the priority of this EscalationRuleRequest.
        The priority of the escalation rule. The lower the number the higer the priority. Once a rule is matched others are skipped.

        :return: The priority of this EscalationRuleRequest.
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority: int) -> None:
        """
        Sets the priority of this EscalationRuleRequest.
        The priority of the escalation rule. The lower the number the higer the priority. Once a rule is matched others are skipped.

        :param priority: The priority of this EscalationRuleRequest.
        :type: int
        """
        
        if priority < 1:
            raise ValueError("Invalid value for `priority`, must be a value greater than or equal to `1`")


        self._priority = priority

    @property
    def division_id(self) -> str:
        """
        Gets the division_id of this EscalationRuleRequest.
        The ID of the division the social escalation rule belongs to.

        :return: The division_id of this EscalationRuleRequest.
        :rtype: str
        """
        return self._division_id

    @division_id.setter
    def division_id(self, division_id: str) -> None:
        """
        Sets the division_id of this EscalationRuleRequest.
        The ID of the division the social escalation rule belongs to.

        :param division_id: The division_id of this EscalationRuleRequest.
        :type: str
        """
        

        self._division_id = division_id

    @property
    def description(self) -> str:
        """
        Gets the description of this EscalationRuleRequest.
        A description of the social escalation rule.

        :return: The description of this EscalationRuleRequest.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this EscalationRuleRequest.
        A description of the social escalation rule.

        :param description: The description of this EscalationRuleRequest.
        :type: str
        """
        

        self._description = description

    @property
    def status(self) -> str:
        """
        Gets the status of this EscalationRuleRequest.
        The status of the escalation rule.

        :return: The status of this EscalationRuleRequest.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this EscalationRuleRequest.
        The status of the escalation rule.

        :param status: The status of this EscalationRuleRequest.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Active", "Paused"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def open_escalation(self) -> 'EscalationTarget':
        """
        Gets the open_escalation of this EscalationRuleRequest.
        The target integration configuration used for an open social media message if the match criteria returns true.

        :return: The open_escalation of this EscalationRuleRequest.
        :rtype: EscalationTarget
        """
        return self._open_escalation

    @open_escalation.setter
    def open_escalation(self, open_escalation: 'EscalationTarget') -> None:
        """
        Sets the open_escalation of this EscalationRuleRequest.
        The target integration configuration used for an open social media message if the match criteria returns true.

        :param open_escalation: The open_escalation of this EscalationRuleRequest.
        :type: EscalationTarget
        """
        

        self._open_escalation = open_escalation

    @property
    def facebook_escalation(self) -> 'EscalationTarget':
        """
        Gets the facebook_escalation of this EscalationRuleRequest.
        The target integration configuration used for a Facebook social media message if the match criteria returns true.

        :return: The facebook_escalation of this EscalationRuleRequest.
        :rtype: EscalationTarget
        """
        return self._facebook_escalation

    @facebook_escalation.setter
    def facebook_escalation(self, facebook_escalation: 'EscalationTarget') -> None:
        """
        Sets the facebook_escalation of this EscalationRuleRequest.
        The target integration configuration used for a Facebook social media message if the match criteria returns true.

        :param facebook_escalation: The facebook_escalation of this EscalationRuleRequest.
        :type: EscalationTarget
        """
        

        self._facebook_escalation = facebook_escalation

    @property
    def instagram_escalation(self) -> 'EscalationTarget':
        """
        Gets the instagram_escalation of this EscalationRuleRequest.
        The target integration configuration used for an Instagram social media message if the match criteria returns true.

        :return: The instagram_escalation of this EscalationRuleRequest.
        :rtype: EscalationTarget
        """
        return self._instagram_escalation

    @instagram_escalation.setter
    def instagram_escalation(self, instagram_escalation: 'EscalationTarget') -> None:
        """
        Sets the instagram_escalation of this EscalationRuleRequest.
        The target integration configuration used for an Instagram social media message if the match criteria returns true.

        :param instagram_escalation: The instagram_escalation of this EscalationRuleRequest.
        :type: EscalationTarget
        """
        

        self._instagram_escalation = instagram_escalation

    @property
    def twitter_escalation(self) -> 'EscalationTarget':
        """
        Gets the twitter_escalation of this EscalationRuleRequest.
        The target integration configuration used for a X (formerly Twitter) social media message if the match criteria returns true.

        :return: The twitter_escalation of this EscalationRuleRequest.
        :rtype: EscalationTarget
        """
        return self._twitter_escalation

    @twitter_escalation.setter
    def twitter_escalation(self, twitter_escalation: 'EscalationTarget') -> None:
        """
        Sets the twitter_escalation of this EscalationRuleRequest.
        The target integration configuration used for a X (formerly Twitter) social media message if the match criteria returns true.

        :param twitter_escalation: The twitter_escalation of this EscalationRuleRequest.
        :type: EscalationTarget
        """
        

        self._twitter_escalation = twitter_escalation

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

