# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import EnrichFieldRule

class EnrichFieldRules(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        EnrichFieldRules - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'default_action': 'str',
            'rules': 'list[EnrichFieldRule]',
            'default_array_action': 'str'
        }

        self.attribute_map = {
            'default_action': 'defaultAction',
            'rules': 'rules',
            'default_array_action': 'defaultArrayAction'
        }

        self._default_action = None
        self._rules = None
        self._default_array_action = None

    @property
    def default_action(self) -> str:
        """
        Gets the default_action of this EnrichFieldRules.
        Default behavior for combining data from the submitted request with any entity found in the database. The default behavior if unspecified is `PreferProvided`, meaning any non-null fields in the submitted request will override data in the database, but all null fields will remain unchanged. Omitting a field in the request payload means that it will be treated as null.

        :return: The default_action of this EnrichFieldRules.
        :rtype: str
        """
        return self._default_action

    @default_action.setter
    def default_action(self, default_action: str) -> None:
        """
        Sets the default_action of this EnrichFieldRules.
        Default behavior for combining data from the submitted request with any entity found in the database. The default behavior if unspecified is `PreferProvided`, meaning any non-null fields in the submitted request will override data in the database, but all null fields will remain unchanged. Omitting a field in the request payload means that it will be treated as null.

        :param default_action: The default_action of this EnrichFieldRules.
        :type: str
        """
        if isinstance(default_action, int):
            default_action = str(default_action)
        allowed_values = ["AlwaysUseProvided", "PreferExisting", "PreferProvided"]
        if default_action.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for default_action -> " + default_action)
            self._default_action = "outdated_sdk_version"
        else:
            self._default_action = default_action

    @property
    def rules(self) -> List['EnrichFieldRule']:
        """
        Gets the rules of this EnrichFieldRules.
        Field-specific behaviors for how to combine data from different sources. For example, you can set a `defaultAction` of `PreferProvided`, but use different behaviors such as `AlwaysUseProvided` or `PreferExisting` for specific fields.

        :return: The rules of this EnrichFieldRules.
        :rtype: list[EnrichFieldRule]
        """
        return self._rules

    @rules.setter
    def rules(self, rules: List['EnrichFieldRule']) -> None:
        """
        Sets the rules of this EnrichFieldRules.
        Field-specific behaviors for how to combine data from different sources. For example, you can set a `defaultAction` of `PreferProvided`, but use different behaviors such as `AlwaysUseProvided` or `PreferExisting` for specific fields.

        :param rules: The rules of this EnrichFieldRules.
        :type: list[EnrichFieldRule]
        """
        

        self._rules = rules

    @property
    def default_array_action(self) -> str:
        """
        Gets the default_array_action of this EnrichFieldRules.
        Default behavior for combining items in array field from the submitted request with any array entity found in the database. The default behavior if unspecified is `fill`, meaning the field value will always be the partial concatenation of both the array in the Database and the array in the contact body, up to the size limit of the array

        :return: The default_array_action of this EnrichFieldRules.
        :rtype: str
        """
        return self._default_array_action

    @default_array_action.setter
    def default_array_action(self, default_array_action: str) -> None:
        """
        Sets the default_array_action of this EnrichFieldRules.
        Default behavior for combining items in array field from the submitted request with any array entity found in the database. The default behavior if unspecified is `fill`, meaning the field value will always be the partial concatenation of both the array in the Database and the array in the contact body, up to the size limit of the array

        :param default_array_action: The default_array_action of this EnrichFieldRules.
        :type: str
        """
        if isinstance(default_array_action, int):
            default_array_action = str(default_array_action)
        allowed_values = ["Replace", "Extend", "Fill"]
        if default_array_action.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for default_array_action -> " + default_array_action)
            self._default_array_action = "outdated_sdk_version"
        else:
            self._default_array_action = default_array_action

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

