# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class EnrichFieldRule(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        EnrichFieldRule - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'field': 'str',
            'action': 'str',
            'array_action': 'str'
        }

        self.attribute_map = {
            'field': 'field',
            'action': 'action',
            'array_action': 'arrayAction'
        }

        self._field = None
        self._action = None
        self._array_action = None

    @property
    def field(self) -> str:
        """
        Gets the field of this EnrichFieldRule.
        A restricted JSONPath naming the specific field this combining behavior should apply to. You may use dot-notation for named fields, and array indexing for lists, but nothing more sophisticated (e.g. wildcards, sublists, filter expressions, etc). For example, to target the `firstName` field of a Contact, this should be \"$.firstName\".

        :return: The field of this EnrichFieldRule.
        :rtype: str
        """
        return self._field

    @field.setter
    def field(self, field: str) -> None:
        """
        Sets the field of this EnrichFieldRule.
        A restricted JSONPath naming the specific field this combining behavior should apply to. You may use dot-notation for named fields, and array indexing for lists, but nothing more sophisticated (e.g. wildcards, sublists, filter expressions, etc). For example, to target the `firstName` field of a Contact, this should be \"$.firstName\".

        :param field: The field of this EnrichFieldRule.
        :type: str
        """
        

        self._field = field

    @property
    def action(self) -> str:
        """
        Gets the action of this EnrichFieldRule.
        The behavior for how to combine data from the request body and the database.

        :return: The action of this EnrichFieldRule.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action: str) -> None:
        """
        Sets the action of this EnrichFieldRule.
        The behavior for how to combine data from the request body and the database.

        :param action: The action of this EnrichFieldRule.
        :type: str
        """
        if isinstance(action, int):
            action = str(action)
        allowed_values = ["AlwaysUseProvided", "PreferExisting", "PreferProvided"]
        if action.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for action -> " + action)
            self._action = "outdated_sdk_version"
        else:
            self._action = action

    @property
    def array_action(self) -> str:
        """
        Gets the array_action of this EnrichFieldRule.
        The behavior for how to combine items in array field from the request body and the database.

        :return: The array_action of this EnrichFieldRule.
        :rtype: str
        """
        return self._array_action

    @array_action.setter
    def array_action(self, array_action: str) -> None:
        """
        Sets the array_action of this EnrichFieldRule.
        The behavior for how to combine items in array field from the request body and the database.

        :param array_action: The array_action of this EnrichFieldRule.
        :type: str
        """
        if isinstance(array_action, int):
            array_action = str(array_action)
        allowed_values = ["Replace", "Extend", "Fill"]
        if array_action.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for array_action -> " + array_action)
            self._array_action = "outdated_sdk_version"
        else:
            self._array_action = array_action

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

